<script src="{{asset('assets/js/app.js')}}"></script>
<script>
  // Initialize Select2 for the type dropdown when modal is shown
  $(document).ready(function() {
    // Initialize Select2 for type dropdown
    if (typeof $.fn.select2 !== 'undefined') {
      $('#type-email-verifier').select2({
        dir: "ltr",
        minimumResultsForSearch: Infinity,
        dropdownParent: $('#modal .modal-content')
      });
    }
  });
  
  $("#type-email-verifier").change(function() {
    var type = $("#type-email-verifier").val();
    loadEmailVerifiersAttributes(type, 'create');
  });
  loadEmailVerifiersAttributes('relayzo', 'create');
  $('[data-bs-toggle="popover"]').popover({
    container: 'body'
  });
</script>
<div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg">
    <div class="modal-content">
      <form id="frm-group" method="post" action="{{route('email_verifiers.store')}}" class="needs-validation" novalidate>
        @csrf
        <div class="modal-header">
          <div class="d-flex align-items-center">
            <div class="me-3">
              <span class="avatar avatar-sm avatar-rounded bg-info svg-white">
                <i class="bi bi-plus-circle"></i>
              </span>
            </div>
            <h6 class="modal-title mb-0 fw-semibold">{{__('app.add_new_email_verifier')}}</h6>
          </div>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="{{__('app.close')}}"></button>
        </div>
        <div class="modal-body">
          <!-- Basic Information Section -->
          <div class="row mb-3">
            <div class="col-md-8">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{__('app.name')}}</label>
                <input type="text" class="form-control" placeholder="{{__('app.name')}}" value="" name="name" required>
                <div class="invalid-feedback">{{__('app.name_required')}}</div>
              </div>
            </div>
            <div class="col-md-4">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{__('app.active')}}</label>
                <select name="is_active" class="form-select form-select-lg">
                  <option value="1">{{ __('app.yes')}}</option>
                  <option value="0">{{ __('app.no') }}</option>
                </select>
              </div>
            </div>
          </div>

          <!-- Configuration Section -->
          <div class="row mb-3">
            <div class="col-12">
              <div class="d-flex align-items-center">
                <div class="me-3">
                  <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                    <i class="bi bi-gear"></i>
                  </span>
                </div>
                <h6 class="mb-0 text-info fw-semibold fs-14">{{__('app.configuration')}}</h6>
              </div>
            </div>
            <div class="col-12">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{__('app.type')}}
                  <a tabindex="-1" role="button" data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" 
                     title="{{__('app.type')}}" data-bs-content="{{__('app.email_verifier_type_help')}}" 
                     data-bs-custom-class="header-primary" class="text-primary ms-1">
                    <i class="bi bi-question-circle"></i>
                  </a>
                </label>
                <select name="type" id="type-email-verifier" class="single-select form-control">
                  @foreach(\App\Http\Helper\Helper::emailVerifiers() as $type => $value)
                    <option value="{{ $type }}">{{ $value }}</option>
                  @endforeach
                </select>
              </div>
            </div>
            <div class="col-12">
              <div id="email_verifiers-attributes"></div>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-light" data-bs-dismiss="modal">
            <i class="bi bi-arrow-left me-1"></i>{{__('app.cancel')}}
          </button>
          <button type="submit" class="btn btn-primary btn-loading">
            <i class="bi bi-check-lg me-1"></i>{{__('app.submit')}}
          </button>
        </div>
      </form>
    </div>
</div>
