<div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg">
    <div class="modal-content">
      <form>
        @csrf
        <div class="modal-header">
          <div class="d-flex align-items-center">
            <div class="me-3">
              <span class="avatar avatar-sm avatar-rounded bg-info svg-white">
                <i class="bi bi-envelope-check"></i>
              </span>
            </div>
            <h6 class="modal-title mb-0 fw-semibold">{{__('app.verify_email')}}</h6>
          </div>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="{{__('app.close')}}"></button>
        </div>
        <div class="modal-body">
          <!-- Email Verifier Selection Section -->
          <div class="row mb-3">
            <div class="col-12">
              <div class="d-flex align-items-center">
                <div class="me-3">
                  <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                    <i class="bi bi-gear"></i>
                  </span>
                </div>
                <h6 class="mb-0 text-info fw-semibold fs-14">{{__('app.type')}}</h6>
              </div>
            </div>
            <div class="col-12">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2"></label>
                <select name="type" id="type-email-verifier" class="single-select form-control">
                  @php $active_email_verifyers = \App\Models\EmailVerifier::whereIsActive(true)->get(); @endphp
                  @foreach($active_email_verifyers as $verifier)
                    <option value="{{ $verifier->id }}" {{ !empty($email_verifier) && !empty($email_verifier->id) && $verifier->id == $email_verifier->id ? 'selected' : '' }}>{{ $verifier->name }}</option>
                  @endforeach
                </select>
              </div>
            </div>
          </div>

          <!-- Email Input Section -->
          <div class="row mb-3">
            <div class="col-12">
              <div class="d-flex align-items-center">
                <div class="me-3">
                  <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                    <i class="bi bi-envelope"></i>
                  </span>
                </div>
                <h6 class="mb-0 text-info fw-semibold fs-14">{{__('app.email')}}</h6>
              </div>
            </div>
            <div class="col-12">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2"></label>
                <input type="email" id="email" class="form-control" placeholder="{{__('app.email')}}" value="{{ $email ?? ''}}" name="email" required>
                <div class="invalid-feedback">{{__('app.email_required')}}</div>
              </div>
            </div>
          </div>

          <!-- Result Message -->
          <div class="row">
            <div class="col-12">
              <div id="msg" class="alert d-none">
                <i class="bi bi-info-circle me-2"></i>
                <span class="message-content"></span>
              </div>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-light" data-bs-dismiss="modal">
            <i class="bi bi-arrow-left me-1"></i>{{__('app.cancel')}}
          </button>
          <button type="button" id="btn-verify-email" class="btn btn-primary btn-loading">
            <i class="bi bi-check-lg me-1"></i>{{__('app.verify')}}
          </button>
        </div>
      </form>
    </div>
</div>
