<div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg">
    <div class="modal-content">
      <form>
        @csrf
        <div class="modal-header">
          <div class="d-flex align-items-center">
            <div class="me-3">
              <span class="avatar avatar-sm avatar-rounded bg-info svg-white">
                <i class="bi bi-list-check"></i>
              </span>
            </div>
            <h6 class="modal-title mb-0 fw-semibold">{{__('app.verify_list')}}</h6>
          </div>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="{{__('app.close')}}"></button>
        </div>
        <div class="modal-body">
          <!-- Email Verifier Selection Section -->
          <div class="row mb-3">
            <div class="col-12">
              <div class="d-flex align-items-center">
                <div class="me-3">
                  <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                    <i class="bi bi-gear"></i>
                  </span>
                </div>
                <h6 class="mb-0 text-info fw-semibold fs-14">{{__('app.type')}}</h6>
              </div>
            </div>
            <div class="col-12">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2"></label>
                <select name="type" id="type-email-verifier" class="single-select form-control">
                  @php $active_email_verifyers = \App\Models\EmailVerifier::whereIsActive(true)->get(); @endphp
                  @foreach($active_email_verifyers as $verifier)
                    <option value="{{ $verifier->id }}" {{ !empty($email_verifier) && !empty($email_verifier->id) && $verifier->id == $email_verifier->id ? 'selected' : '' }}>{{ $verifier->name }}</option>
                  @endforeach
                </select>
              </div>
            </div>
          </div>

          <!-- List Selection Section -->
          <div class="row mb-3">
            <div class="col-12">
              <div class="d-flex align-items-center justify-content-between">
                <div class="d-flex align-items-center">
                  <div class="me-3">
                    <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                      <i class="bi bi-list-ul"></i>
                    </span>
                  </div>
                  <h6 class="mb-0 text-info fw-semibold fs-14">{{__('app.list_verification')}}</h6>
                </div>
                <a href="{{route('lists.create')}}" class="text-primary">
                  <i class="bi bi-plus-circle"></i>
                </a>
              </div>
            </div>
            <div class="col-12">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2"></label>
                @php $list_ids = !empty($list_id) ? [$list_id] : []; @endphp
                @include('includes.dropdown_lists', ['popup' => 1, 'multiple' => 1, 'required' => 1])
              </div>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-light" data-bs-dismiss="modal">
            <i class="bi bi-arrow-left me-1"></i>{{__('app.cancel')}}
          </button>
          <button type="button" id="btn-verify-list" class="btn btn-primary btn-loading">
            <i class="bi bi-check-lg me-1"></i>{{__('app.verify')}}
          </button>
        </div>
      </form>
    </div>
</div>
<span id="list_verify_msg" data-route="{{ __('app.list_verify_msg') }}"></span>
