@extends('layouts.app')
@section('title', $page_title)

{{-- Include global DataTable styling --}}
@include('components.datatable-styles')

@push('scripts')
<script>
$(function () {
  var table = $('#data').DataTable({
    "columnDefs": [{"sortable": false, "targets": [0, 3]}],
    "order": [[ 1, "desc" ]],
    "lengthMenu": [[50, 100, 200], [50, 100, 200]],
    "ajax": $('#route-emails_pages').data('route'),
  });
  table.on('draw', function() {
    $('#data_paginate a').addClass('btn btn-primary me-1');
    $('#data_paginate .paginate_button.current').addClass('btn-light').removeClass('btn-primary');
  });

});
</script>
@endpush
@section('content')
<div class="row">
    <div class="col-xl-12">
        <div class="card custom-card">
            <div class="card-body">
                <div class="table-responsive">
                    <table id="data" class="table table-bordered text-nowrap w-100">
                        <thead>
                            <tr>
                                <th><input type="checkbox" id='checkAll' value="0" class="form-check-input"></th>
                                <th>{{ __('app.id') }}</th>
                                <th>{{ __('app.name') }}</th>
                                <th>{{ __('app.actions') }}</th>
                            </tr>
                        </thead>
                         <tbody></tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<span id="route-emails_pages" data-route="{{ route('get.emails_pages', ['type' => request('type')]) }}"></span>
@include('includes.datatables')
@endsection
