@if($popup)
<link rel="stylesheet" href="{{asset('components/multiselect/css/bootstrap-multiselect.css')}}" type="text/css"/>
<link rel="stylesheet" href="{{asset('assets/css/multidropdown.css')}}" type="text/css"/>
<script type="text/javascript" src="{{asset('components/multiselect/js/bootstrap-multiselect.js')}}"></script>
<script type="text/javascript">
    $(document).ready(function() {
        $('#modal').on('shown.bs.modal', function() {
            var $select = $('#broadcast_ids');
            if ($select.data('multiselect')) {
                $select.multiselect('destroy');
            }
            
            $select.multiselect({
                enableClickableOptGroups: true,
                enableCollapsibleOptGroups: true,
                enableFiltering: true,
                includeSelectAllOption: true,
                buttonWidth: '100%',
                maxHeight: 400,
                nonSelectedText: '{{__('app.multiselect_none_selected')}}',
                allSelectedText: '{{__('app.multiselect_all_selected')}}',
                nSelectedText: '{{__('app.multiselect_n_selected')}}',
                selectAllText: ' {{__('app.select_all')}}',
                deselectAllText: ' {{__('app.deselect_all')}}',
                filterPlaceholder: '{{__('app.multiselect_search')}}'
            });
            // Hide the original select element
            $select.hide();
            
            // Make Select All and Group names bold, and style collapse icon
            setTimeout(function() {
                // Ensure Select All text is multilingual
                var selectAllText = '{{__('app.select_all')}}';
                var deselectAllText = '{{__('app.deselect_all')}}';
                $('.multiselect-container .multiselect-all label').each(function() {
                    var $label = $(this);
                    var $input = $label.find('input[value="multiselect-all"]');
                    if ($input.length > 0) {
                        var $textNode = $label.contents().filter(function() {
                            return this.nodeType === 3 && this.textContent.trim() !== '';
                        });
                        if ($input.is(':checked')) {
                            if ($textNode.length > 0) {
                                $textNode.first().replaceWith(' ' + deselectAllText);
                            } else {
                                $label.append(' ' + deselectAllText);
                            }
                        } else {
                            if ($textNode.length > 0) {
                                $textNode.first().replaceWith(' ' + selectAllText);
                            } else {
                                $label.append(' ' + selectAllText);
                            }
                        }
                    }
                });
                $('.multiselect-container .multiselect-all, .multiselect-container .multiselect-all *').css('font-weight', 'bold');
                $('.multiselect-container .multiselect-group, .multiselect-container .multiselect-group *').css('font-weight', 'bold');
                $('.multiselect-container .multiselect-group .caret-container').css({
                    'font-weight': 'bold',
                    'margin-right': '8px'
                });
                // Add left spacing to options under groups
                $('.multiselect-container .multiselect-group ~ li.multiselect-option').css({
                    'padding-left': '40px',
                    'margin-left': '10px'
                });
                // Ensure scrollbar is visible
                $('.multiselect-container').css({
                    'max-height': '400px',
                    'height': '400px',
                    'overflow-y': 'scroll',
                    'overflow-x': 'hidden'
                });
                $('.multiselect-container ul, .multiselect-container .dropdown-menu').css({
                    'max-height': '400px',
                    'overflow-y': 'scroll',
                    'overflow-x': 'hidden'
                });
            }, 100);
        });
    });
</script>
@else
@push('styles')
<link rel="stylesheet" href="{{asset('components/multiselect/css/bootstrap-multiselect.css')}}" type="text/css"/>
<link rel="stylesheet" href="{{asset('assets/css/multidropdown.css')}}" type="text/css"/>
@endpush
@push('scripts')
<script type="text/javascript" src="{{asset('components/multiselect/js/bootstrap-multiselect.js')}}"></script>
<script type="text/javascript">
    $(document).ready(function() {
        var $select = $('#broadcast_ids');
        if ($select.data('multiselect')) {
            $select.multiselect('destroy');
        }
        
        $select.multiselect({
            enableClickableOptGroups: true,
            enableCollapsibleOptGroups: true,
            enableFiltering: true,
            includeSelectAllOption: true,
            buttonWidth: '100%',
            maxHeight: 400,
            nonSelectedText: '{{__('app.multiselect_none_selected')}}',
            allSelectedText: '{{__('app.multiselect_all_selected')}}',
            nSelectedText: '{{__('app.multiselect_n_selected')}}',
            selectAllText: ' {{__('app.select_all')}}',
            deselectAllText: ' {{__('app.deselect_all')}}',
            filterPlaceholder: '{{__('app.multiselect_search')}}'
        });
        // Hide the original select element
        $select.hide();
        
        // Make Select All and Group names bold, and style collapse icon
        setTimeout(function() {
            // Ensure Select All text is multilingual
            var selectAllText = '{{__('app.select_all')}}';
            var deselectAllText = '{{__('app.deselect_all')}}';
            $('.multiselect-container .multiselect-all label').each(function() {
                var $label = $(this);
                var $input = $label.find('input[value="multiselect-all"]');
                if ($input.length > 0) {
                    var $textNode = $label.contents().filter(function() {
                        return this.nodeType === 3 && this.textContent.trim() !== '';
                    });
                    if ($input.is(':checked')) {
                        if ($textNode.length > 0) {
                            $textNode.first().replaceWith(' ' + deselectAllText);
                        } else {
                            $label.append(' ' + deselectAllText);
                        }
                    } else {
                        if ($textNode.length > 0) {
                            $textNode.first().replaceWith(' ' + selectAllText);
                        } else {
                            $label.append(' ' + selectAllText);
                        }
                    }
                }
            });
            $('.multiselect-container .multiselect-all, .multiselect-container .multiselect-all *').css('font-weight', 'bold');
            $('.multiselect-container .multiselect-group, .multiselect-container .multiselect-group *').css('font-weight', 'bold');
            $('.multiselect-container .multiselect-group .caret-container').css({
                'font-weight': 'bold',
                'margin-right': '8px'
            });
            // Add left spacing to options under groups
            $('.multiselect-container .multiselect-group ~ li.multiselect-option').css({
                'padding-left': '40px',
                'margin-left': '10px'
            });
        }, 100);
    });
</script>
@endpush
@endif
<select name="@if(isset($multiple) && $multiple == 1)broadcast_ids[]@else broadcast_id @endif" class="form-select form-select-lg @if(isset($multiple) && $multiple == 1) use-multiselect no-choices @endif" id="broadcast_ids" @if(isset($multiple) && $multiple == 1) multiple data-use-multiselect="true" @endif  @if((!isset($disabled) || $disabled != 1) && (isset($required) && $required == 1)) required @endif @if(isset($disabled) && $disabled == 1) disabled @endif>
  @if(!isset($multiple) || $multiple != 1)
  <option value="">{{__('app.select_broadcast')}}</option>
  @endif
  @foreach(\App\Models\Broadcast::groupBroadcasts() as $group)
    <optgroup label="{{ $group->name }}">
      @foreach($group->broadcasts as $broadcast)
        <option value="{{ $broadcast->id }}" {{ ((!empty($broadcast_ids) && in_array($broadcast->id, $broadcast_ids)) || (isset($broadcast_id) && $broadcast->id == $broadcast_id)) ? 'selected="selected"' : '' }}>{{$broadcast->name}}</option>
      @endforeach
    </optgroup>
  @endforeach
</select>
@if((!isset($disabled) || $disabled != 1) && (isset($required) && $required == 1))
<div class="invalid-feedback" id="broadcast_ids_feedback">{{__('app.broadcast_required')}}</div>
@endif
