@push('scripts')
  <script type="text/javascript">
    let multipleLists;
    (function () {
      "use strict";
      multipleLists = new Choices(document.getElementById('schedule_campaign_stat_ids'), {
        searchEnabled: true,
        removeItemButton: true,
        placeholder: true, // Optional: Show placeholder text
        shouldSort: false, // Prevents automatic sorting
      });
    })();
  </script>
@endpush
<select name="schedule_campaign_stat_ids[]" class="form-select form-select-lg" id="schedule_campaign_stat_ids" @if(isset($multiple) && $multiple == 1) multiple @endif  @if(isset($required)) required @endif>
  <option value="">{{__('app.select_campaign')}}</option>
  @foreach(\App\Models\ScheduleCampaignStat::getScheduledCampaigns() as $schedule_stat)
    <option value="{{ $schedule_stat->id }}" {{ !empty($schedule_campaign_stat_ids) && in_array($schedule_stat->id, $schedule_campaign_stat_ids) ? 'selected="selected"' : '' }}>{{ $schedule_stat->schedule_campaign_name }}</option>
  @endforeach
</select>
@if(isset($required))
<div class="invalid-feedback">Please select at least one option.</div>
@endif
