@php
if(isset($client_package_lists) && $client_package_lists == 1) {
    $client_lists = \App\Http\Helper\Helper::getClientAttributeValue(\Auth::user()->app_id, 'list_ids');
}
@endphp

@if(isset($popup) && $popup == 1)
<link rel="stylesheet" href="{{asset('components/multiselect/css/bootstrap-multiselect.css')}}" type="text/css"/>
<link rel="stylesheet" href="{{asset('assets/css/multidropdown.css')}}" type="text/css"/>
<script type="text/javascript" src="{{asset('components/multiselect/js/bootstrap-multiselect.js')}}"></script>
<script type="text/javascript">
    $(document).ready(function() {
        $('#modal').on('shown.bs.modal', function() {
            var $select = $('#list_ids');
            if ($select.data('multiselect')) {
                $select.multiselect('destroy');
            }
            
            $select.multiselect({
                enableClickableOptGroups: true,
                enableCollapsibleOptGroups: true,
                enableFiltering: true,
                includeSelectAllOption: true,
                buttonWidth: '100%',
                maxHeight: 400,
                nonSelectedText: '{{__('app.multiselect_none_selected')}}',
                allSelectedText: '{{__('app.multiselect_all_selected')}}',
                nSelectedText: '{{__('app.multiselect_n_selected')}}',
                selectAllText: ' {{__('app.select_all')}}',
                deselectAllText: ' {{__('app.deselect_all')}}',
                filterPlaceholder: '{{__('app.multiselect_search')}}'
            });
            // Hide the original select element
            $select.hide();
            
            // Make Select All and Group names bold, and style collapse icon
            setTimeout(function() {
                // Ensure Select All text is multilingual
                var selectAllText = '{{__('app.select_all')}}';
                var deselectAllText = '{{__('app.deselect_all')}}';
                $('.multiselect-container .multiselect-all label').each(function() {
                    var $label = $(this);
                    var $input = $label.find('input[value="multiselect-all"]');
                    if ($input.length > 0) {
                        var $textNode = $label.contents().filter(function() {
                            return this.nodeType === 3 && this.textContent.trim() !== '';
                        });
                        if ($input.is(':checked')) {
                            if ($textNode.length > 0) {
                                $textNode.first().replaceWith(' ' + deselectAllText);
                            } else {
                                $label.append(' ' + deselectAllText);
                            }
                        } else {
                            if ($textNode.length > 0) {
                                $textNode.first().replaceWith(' ' + selectAllText);
                            } else {
                                $label.append(' ' + selectAllText);
                            }
                        }
                    }
                });
                $('.multiselect-container .multiselect-all, .multiselect-container .multiselect-all *').css('font-weight', 'bold');
                $('.multiselect-container .multiselect-group, .multiselect-container .multiselect-group *').css('font-weight', 'bold');
                $('.multiselect-container .multiselect-group .caret-container').css({
                    'font-weight': 'bold',
                    'margin-right': '8px'
                });
                // Add left spacing to options under groups
                $('.multiselect-container .multiselect-group ~ li.multiselect-option').css({
                    'padding-left': '40px',
                    'margin-left': '10px'
                });
                // Ensure scrollbar is visible
                $('.multiselect-container').css({
                    'max-height': '400px',
                    'height': '400px',
                    'overflow-y': 'scroll',
                    'overflow-x': 'hidden'
                });
                $('.multiselect-container ul, .multiselect-container .dropdown-menu').css({
                    'max-height': '400px',
                    'overflow-y': 'scroll',
                    'overflow-x': 'hidden'
                });
                // Make sure dropdown is closed by default
                $('.multiselect-container').removeClass('show');
            }, 100);
        });
    });
</script>
@else
@push('styles')
<link rel="stylesheet" href="{{asset('components/multiselect/css/bootstrap-multiselect.css')}}" type="text/css"/>
<link rel="stylesheet" href="{{asset('assets/css/multidropdown.css')}}" type="text/css"/>
@endpush
@push('scripts')
<script type="text/javascript" src="{{asset('components/multiselect/js/bootstrap-multiselect.js')}}"></script>
<script type="text/javascript">
    $(document).ready(function() {
        var $select = $('#list_ids');
        if ($select.data('multiselect')) {
            $select.multiselect('destroy');
        }
        
        $select.multiselect({
            enableClickableOptGroups: true,
            enableCollapsibleOptGroups: true,
            enableFiltering: true,
            includeSelectAllOption: true,
            buttonWidth: '100%',
            maxHeight: 400,
            nonSelectedText: '{{__('app.multiselect_none_selected')}}',
            allSelectedText: '{{__('app.multiselect_all_selected')}}',
            nSelectedText: '{{__('app.multiselect_n_selected')}}',
            selectAllText: ' {{__('app.select_all')}}',
            deselectAllText: ' {{__('app.deselect_all')}}',
            filterPlaceholder: '{{__('app.multiselect_search')}}'
        });
        // Hide the original select element
        $select.hide();
        
        // Make Select All and Group names bold, and style collapse icon
        setTimeout(function() {
            // Ensure Select All text is multilingual
            var selectAllText = '{{__('app.select_all')}}';
            var deselectAllText = '{{__('app.deselect_all')}}';
            $('.multiselect-container .multiselect-all label').each(function() {
                var $label = $(this);
                var $input = $label.find('input[value="multiselect-all"]');
                if ($input.length > 0) {
                    var $textNode = $label.contents().filter(function() {
                        return this.nodeType === 3 && this.textContent.trim() !== '';
                    });
                    if ($input.is(':checked')) {
                        if ($textNode.length > 0) {
                            $textNode.first().replaceWith(' ' + deselectAllText);
                        } else {
                            $label.append(' ' + deselectAllText);
                        }
                    } else {
                        if ($textNode.length > 0) {
                            $textNode.first().replaceWith(' ' + selectAllText);
                        } else {
                            $label.append(' ' + selectAllText);
                        }
                    }
                }
            });
            $('.multiselect-container .multiselect-all, .multiselect-container .multiselect-all *').css('font-weight', 'bold');
            $('.multiselect-container .multiselect-group, .multiselect-container .multiselect-group *').css('font-weight', 'bold');
            $('.multiselect-container .multiselect-group .caret-container').css({
                'font-weight': 'bold',
                'margin-right': '8px'
            });
            // Add left spacing to options under groups
            $('.multiselect-container .multiselect-group ~ li.multiselect-option').css({
                'padding-left': '40px',
                'margin-left': '10px'
            });
        }, 100);
    });
</script>
@endpush
@endif
<select name="list_ids[]" class="form-select form-select-lg @if(isset($multiple) && $multiple == 1) use-multiselect no-choices @endif" id="list_ids" @if(isset($multiple) && $multiple == 1) multiple data-use-multiselect="true" @endif  @if(isset($required)) required @endif @if(isset($disabled)) disabled @endif>
  <option value="">{{__('app.select_list')}}</option>
  @if(!empty($client_lists))
    @foreach(\App\Models\Lists::groupListsClient($client_lists) as $group)
      <optgroup label="{{ $group->name }}">
        @foreach($group->lists as $list)
          @if(in_array($list->id, $client_lists))
            <option value="{{ $list->id }}" {{ !empty($list_ids) && in_array($list->id, $list_ids) ? 'selected="selected"' : '' }}>{{ $list->name }} ({{$list->total_contacts}})</option>
          @endif
        @endforeach
      </optgroup>
    @endforeach
  @endif
  @foreach(\App\Models\Lists::groupLists() as $group)
    <optgroup label="{{ $group->name }}">
      @foreach($group->lists as $list)
        <option value="{{ $list->id }}" {{ ((!empty($list_ids) && in_array($list->id, $list_ids)) || (isset($list_id) && $list->id == $list_id)) ? 'selected="selected"' : '' }}>{{$list->name}} ({{$list->total_contacts ?? 0}})</option>
      @endforeach
    </optgroup>
  @endforeach
</select>
@if(isset($required) && $required)
<div class="invalid-feedback" id="list_ids_feedback">{{__('app.lists_required')}}</div>
@endif
