@push('scripts')
  <script type="text/javascript">
    let multipleLists;
    (function () {
      "use strict";
      multipleLists = new Choices(document.getElementById('segment_ids'), {
        searchEnabled: true,
        removeItemButton: true,
        placeholder: true, // Optional: Show placeholder text
      });
    })();
  </script>
@endpush
<select name="segment_ids[]" class="form-select form-select-lg" id="segment_ids" @if(isset($multiple) && $multiple == 1) multiple @endif  @if(isset($required)) required @endif>
  <option value="">{{__('app.select_segmentation')}}</option>
  @foreach(\App\Models\Segmentation::all() as $segment)
        <option value="{{ $segment->id }}" {{ ((!empty($segment_ids) && in_array($segment->id, $segment_ids)) || (isset($segment_id) && $list->id == $segment_id)) ? 'selected="selected"' : '' }}>{{$segment->name}} ({{$segment->total ?? 0}})</option>
  @endforeach
</select>
@if(isset($required))
<div class="invalid-feedback">Please select at least one option.</div>
@endif
