@php $client_sending_domains = \App\Http\Helper\Helper::getClientAttributeValue(\Auth::user()->app_id, 'sending_domain_ids'); @endphp

@if(isset($popup) && $popup == 1)
<script type="text/javascript">
(function () {
    "use strict";
    document.getElementById('modal').addEventListener('shown.bs.modal', function () {
      const multipleSendingDomains = new Choices(document.getElementById('sending_domain_ids'), {
        removeItemButton: true,
        dropdownParent: document.getElementById('modal') // Attach to modal
      });
    });
});
</script>
@else
  @if(isset($multiple) && $multiple == 1)
    @push('scripts')
    <script type="text/javascript">
      let multipleSendingDomains;
      (function () {
        "use strict";
        multipleSendingDomains = new Choices(document.getElementById('sending_domain_ids'), {
          searchEnabled: true,
          removeItemButton: true,
        });
      })();
    </script>
    @endpush
  @endif
@endif

@if(isset($multiple) && $multiple == 1)
<select name="sending_domain_ids[]" class="form-select form-select-lg" id="sending_domain_ids" @if(isset($multiple) && $multiple == 1) multiple @endif  @if(isset($required)) required @endif @if(isset($disabled)) disabled @endif>
@endif

<option value="">{{__('app.select_domain')}}</option>

@if(!empty($client_sending_domains)) 
  @foreach($client_sending_domains as $packege_domain)
        <option value="{{ $packege_domain }}" {{ ((isset($from_email_domain) && $from_email_domain == $packege_domain)) ? 'selected="selected"' : '' }}>{{ $packege_domain }}</option>
  @endforeach
@endif

@foreach(\App\Models\SendingDomain::getSendingDomains() as $sending_domain)
  <option value="{{ $sending_domain->domain }}" {{ (!empty($sending_domain_ids) && in_array($sending_domain->domain, $sending_domain_ids)) || ((isset($from_email_domain) && $from_email_domain == $sending_domain->domain)) ? 'selected="selected"' : ''  }}>{{ $sending_domain->domain }}</option>
@endforeach


@if(isset($multiple) && $multiple == 1)
</select>
@endif
