<header class="app-header sticky" id="header">

    <!-- Start::main-header-container -->
    <div class="main-header-container container-fluid">

        <!-- Start::header-content-left -->
        <div class="header-content-left">

            <!-- Start::header-element -->
            <div class="header-element">
                <div class="horizontal-logo">
                    <a href="{{route('dashboard')}}" class="header-logo">
                        <img src="{{asset('images/app/site_logo.png')}}" alt="logo" class="desktop-logo">
                        <img src="{{asset('images/app/site_logo.png')}}" alt="logo" class="toggle-dark">
                        <img src="{{asset('images/app/site_logo.png')}}" alt="logo" class="desktop-dark">
                        <img src="{{asset('images/app/site_logo.png')}}" alt="logo" class="toggle-logo">
                        <img src="{{asset('images/app/site_logo.png')}}" alt="logo" class="toggle-white">
                        <img src="{{asset('images/app/site_logo.png')}}" alt="logo" class="desktop-white">
                    </a>
                </div>
            </div>
            <!-- End::header-element -->

            <!-- Start::header-element -->
            <div class="header-element mx-lg-0 mx-2">
                <a aria-label="Hide Sidebar" class="sidemenu-toggle header-link animated-arrow hor-toggle horizontal-navtoggle" data-bs-toggle="sidebar" href="javascript:void(0);"><span></span></a>
            </div>
            <!-- End::header-element -->


            <!-- Start::header-element -->
            <div class="header-element d-md-block d-none">
                <!-- Start::header-link -->
                <span class="top-bar-timezone">
                    <span id="time_zone" style="display: none;">{{isset($time_zone) ? $time_zone : 'Europe/London'}}</span>
                    <div id="clock"></div>
                </span>
                <!-- End::header-link -->
            </div>
            <!-- End::header-element -->

        </div>
        <!-- End::header-content-left -->

        <!-- Start::header-content-right -->
        <ul class="header-content-right">
            <!-- Start::header-link|dropdown-toggle -->

            @if(Auth::user()->chatgpt_enabled && \App\Http\Helper\Helper::checkPermissions('settings_chatGPT', false))
            <!-- Start::header-element -->
            <li class="header-element header-theme-mode">
                <!-- Start::header-link|layout-setting -->
                <a href="javascript:void(0);" onclick="chatGPT('modal', '{{ route('chatGPT') }}', 'null');" class="header-link">
                    <span class="header-link-icon ">
                        <!-- Start::header-link-icon -->
                        <i fill="none" class="bi bi-stars text-primary2" fill="none"></i>
                        <!-- End::header-link-icon -->
                    </span>
                </a>
                <!-- End::header-link|layout-setting -->
            </li>
            <!-- End::header-element -->
            @endif
            
            @if(\App\Http\Helper\Helper::checkPermissions('languages', false))
            <!-- Start::header-element -->
            <li class="header-element header-theme-mode">
                <a href="javascript:void(0);" class="header-link dropdown-toggle" data-bs-auto-close="outside" data-bs-toggle="dropdown">
                    <svg xmlns="https://www.w3.org/2000/svg" class="w-6 h-6 header-link-icon" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" d="m10.5 21 5.25-11.25L21 21m-9-3h7.5M3 5.621a48.474 48.474 0 0 1 6-.371m0 0c1.12 0 2.233.038 3.334.114M9 5.25V3m3.334 2.364C11.176 10.658 7.69 15.08 3 17.502m9.334-12.138c.896.061 1.785.147 2.666.257m-4.589 8.495a18.023 18.023 0 0 1-3.827-5.802" />
                      </svg>
                      
                </a>
                <!-- End::header-link|dropdown-toggle -->
                <ul class="main-header-dropdown dropdown-menu dropdown-menu-end" data-popper-placement="none">
                    <li>
                        <a class="dropdown-item d-flex align-items-center" href="{{ route('lang', 'en') }}">
                            <div class="d-flex align-items-center justify-content-between">
                                <div class="d-flex align-items-center">
                                    <span class="avatar avatar-rounded avatar-xs lh-1 me-2">
                                        <img src="{{asset('assets/images/flags/us_flag.jpg')}}" alt="img">
                                    </span>
                                    English
                                </div>
                            </div>
                        </a>
                    </li>
                    <li>
                        <a class="dropdown-item d-flex align-items-center" href="{{ route('lang', 'ar') }}">
                            <div class="d-flex align-items-center justify-content-between">
                                <div class="d-flex align-items-center">
                                    <span class="avatar avatar-rounded avatar-xs lh-1 me-2">
                                        <img src="{{asset('assets/images/flags/uae_flag.jpg')}}" alt="img">
                                    </span>
                                    العربية
                                </div>
                            </div>
                        </a>
                    </li>
                    <li>
                        <a class="dropdown-item d-flex align-items-center" href="{{ route('lang', 'es') }}">
                            <span class="avatar avatar-rounded avatar-xs lh-1 me-2">
                                <img src="{{asset('assets/images/flags/spain_flag.jpg')}}" alt="img" >
                            </span>
                            Español
                        </a>
                    </li>
                    <li>
                        <a class="dropdown-item d-flex align-items-center" href="{{ route('lang', 'fr') }}">
                            <span class="avatar avatar-rounded avatar-xs lh-1 me-2">
                                <img src="{{asset('assets/images/flags/french_flag.jpg')}}" alt="img" >
                            </span>
                            Français
                        </a>
                    </li>
                    <li>
                        <a class="dropdown-item d-flex align-items-center" href="{{ route('lang', 'de') }}">
                            <span class="avatar avatar-rounded avatar-xs lh-1 me-2">
                                <img src="{{asset('assets/images/flags/germany_flag.jpg')}}" alt="img" >
                            </span>
                            Deutsch
                        </a>
                    </li>
                    <li>
                        <a class="dropdown-item d-flex align-items-center" href="{{ route('lang', 'it') }}">
                            <span class="avatar avatar-rounded avatar-xs lh-1 me-2">
                                <img src="{{asset('assets/images/flags/italian_flag.jpg')}}" alt="img" >
                            </span>
                            Italian
                        </a>
                    </li>
                    <li>
                        <a class="dropdown-item d-flex align-items-center" href="{{ route('lang', 'ru') }}">
                            <span class="avatar avatar-rounded avatar-xs lh-1 me-2">
                                <img src="{{asset('assets/images/flags/russia_flag.jpg')}}" alt="img" >
                            </span>
                            русский
                        </a>
                    </li>
                    <li>
                        <a class="dropdown-item d-flex align-items-center" href="{{ route('lang', 'zh') }}">
                            <span class="avatar avatar-rounded avatar-xs lh-1 me-2">
                                <img src="{{asset('assets/images/flags/china_flag.jpg')}}" alt="img" >
                            </span>
                            中文
                        </a>
                    </li>
                </ul>
            </li>
            <!-- End::header-element -->
            @endif

            <!-- Start::header-element -->
            <li class="header-element header-theme-mode">
                <!-- Start::header-link|layout-setting -->
                <a href="javascript:void(0);" class="header-link layout-setting">
                    <span class="light-layout">
                        <!-- Start::header-link-icon -->
                        <svg xmlns="https://www.w3.org/2000/svg" class="w-6 h-6 header-link-icon" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M21.752 15.002A9.72 9.72 0 0 1 18 15.75c-5.385 0-9.75-4.365-9.75-9.75 0-1.33.266-2.597.748-3.752A9.753 9.753 0 0 0 3 11.25C3 16.635 7.365 21 12.75 21a9.753 9.753 0 0 0 9.002-5.998Z" />
                          </svg>
                        <!-- End::header-link-icon -->
                    </span>
                    <span class="dark-layout">
                        <!-- Start::header-link-icon -->
                        <svg xmlns="https://www.w3.org/2000/svg" class="w-6 h-6 header-link-icon" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M12 3v2.25m6.364.386-1.591 1.591M21 12h-2.25m-.386 6.364-1.591-1.591M12 18.75V21m-4.773-4.227-1.591 1.591M5.25 12H3m4.227-4.773L5.636 5.636M15.75 12a3.75 3.75 0 1 1-7.5 0 3.75 3.75 0 0 1 7.5 0Z" />
                          </svg>
                        <!-- End::header-link-icon -->
                    </span>
                </a>
                <!-- End::header-link|layout-setting -->
            </li>
            <!-- End::header-element -->
            @if(\App\Http\Helper\Helper::checkPermissions('system_notifications', false))
            <!-- Start::header-element -->            
            <li class="header-element notifications-dropdown d-xl-block d-none dropdown">
                <!-- Start::header-link|dropdown-toggle -->
                <a href="javascript:void(0);" class="header-link dropdown-toggle" data-bs-toggle="dropdown" data-bs-auto-close="outside" id="messageDropdown" aria-expanded="false">
                    <i class="bi bi-bell w-6 h-6 header-link-icon"></i>
                    @if(count($notifications))
                    <span class="header-icon-pulse bg-primary2 rounded pulse pulse-secondary"></span>
                    @endif
                </a>
                <!-- End::header-link|dropdown-toggle -->
                <!-- Start::main-header-dropdown -->
                <div class="main-header-dropdown dropdown-menu dropdown-menu-end" data-popper-placement="none">
                    <div class="p-3">
                        <div class="d-flex align-items-center justify-content-between">
                            <p class="mb-0 fs-15 fw-medium">{{__('app.notifications')}}</p>
                            <span class="badge bg-secondary text-fixed-white" id="notifiation-data">{{count($notifications)}} {{__('app.unread')}}</span>
                        </div>
                    </div>
                    <div class="dropdown-divider"></div>
                    <ul class="list-unstyled mb-0" id="header-notification-scroll">
                        @foreach($notifications as $notification)
                        @switch($notification->type)
                        @case('export')
                        @php ($icon = 'bi-download')
                        @php ($title = __('app.download'))
                        @break
                        @case('import')
                        @php ($icon = 'bi-check')
                        @php ($title = __('app.import'))
                        @break
                        @default
                        @php ($icon = 'bi-bell')
                        @php ($title = __('app.read'))
                        @endswitch
                        <li class="dropdown-item">
                            <div class="d-flex align-items-center">                                
                                <div class="flex-grow-1 d-flex align-items-center justify-content-between">
                                    <div>
                                        <p class="mb-0 fw-medium"><a href="{{ route('notification.read', ['id' => $notification->id]) }}">{{$title}}</a></p>
                                        <div class="text-dark fw-normal fs-12 header-notification-text text-truncate">{{ $notification->name}}</div>
                                        <div class="fw-normal fs-10 text-dark op-8">{{ App\Http\Helper\Helper::datetimeDisplay($notification->created_at)}}</div>
                                    </div>
                                    <div><i class="bi {{$icon}}"></i></div>
                                </div>
                            </div>
                        </li>
                        @endforeach
                    </ul>

                    @if(count($notifications))
                    <div class="p-3 empty-header-item1 border-top">
                        <div class="row">
                            <div class="d-grid col-md-6">
                                <a href="{{ route('notifications') }}" class="btn btn-primary btn-wave">{{__('app.show_all_notifications')}}</a>
                            </div>
                            <div class="d-grid col-md-6">
                                <a href="{{ route('notification.read.all') }}" class="btn btn-danger btn-wave">{{__('app.clear_all')}}</a>
                            </div>
                        </div>
                    </div>
                    @endif                 
                </div>
                <!-- End::main-header-dropdown -->
            </li>
            <!-- End::header-element -->
            @endif

            <!-- Start::header-element -->
            <li class="header-element header-fullscreen">
                <!-- Start::header-link -->
                <a onclick="openFullscreen();" href="javascript:void(0);" class="header-link">
                    <i class="bi bi-fullscreen w-6 h-6 full-screen-open header-link-icon"></i>
                    <i class="bi bi-fullscreen-exit w-6 h-6 full-screen-close header-link-icon d-none"></i>
                </a>
                <!-- End::header-link -->
            </li>
            <!-- End::header-element -->

            <!-- Start::header-element -->
            <li class="header-element dropdown">
                <!-- Start::header-link|dropdown-toggle -->
                <a href="javascript:void(0);" class="header-link dropdown-toggle" id="mainHeaderProfile" data-bs-toggle="dropdown" data-bs-auto-close="outside" aria-expanded="false">
                    <i class="bi bi-person-circle w-6 h-6 header-link-icon"></i>
                </a>
                <!-- End::header-link|dropdown-toggle -->
                <ul class="main-header-dropdown dropdown-menu pt-0 overflow-hidden header-profile-dropdown dropdown-menu-end" aria-labelledby="mainHeaderProfile">
                    <li>
                        <div class="dropdown-item text-center border-bottom">
                            <span>
                                {{ Auth::user()->name ?? '' }}
                            </span>
                            <span class="d-block fs-12">{{  Auth::user()->roles->pluck('display_name')[0] ?? '' }}</span>
                        </div>
                    </li>
                    <li><a class="dropdown-item d-flex align-items-center" href="{{ route('profile')}}"><i class="fe fe-user p-1 rounded-circle bg-primary-transparent me-2 fs-16"></i>{{__('app.profile')}}</a></li>
                    <li class="border-top bg-light">
                        <a class="dropdown-item d-flex align-items-center" href="javascript:;" onclick="viewModal('modal', '{{route('help')}}');"><i class="fe fe-help-circle p-1 rounded-circle bg-primary-transparent set me-2 fs-16"></i>{{__('app.help')}}</a></li>
                    <li><a class="dropdown-item d-flex align-items-center" href="javascript:;" onclick="clearCache()"><i class="fe fe-user p-1 rounded-circle bg-primary-transparent me-2 fs-16"></i>{{__('app.clear_cache')}}</a></li>
                    <li class="border-top bg-light"><a class="dropdown-item d-flex align-items-center" href="{{ route('logout') }}"  
                        onclick="event.preventDefault();
                        document.getElementById('logout-form').submit();">
                        <i class="fe fe-lock p-1 rounded-circle bg-primary-transparent ut me-2 fs-16"></i>{{__('app.logout')}}</a></li>
                        <form id="logout-form" action="{{ route('logout') }}" method="POST" class="display-none">
                            @csrf
                        </form>

                    </ul>
                </li>  
                <!-- End::header-element -->

                @if(\App\Http\Helper\Helper::checkPermissions('theme_layout', false))
                <!-- Start::header-element -->
                <li class="header-element">
                    <!-- Start::header-link|switcher-icon -->
                    <a href="javascript:void(0);" class="header-link switcher-icon" data-bs-toggle="offcanvas" data-bs-target="#switcher-canvas">
                        <span class="bi bi-palette w-6 h-6 header-link-icon colorful-palette"></span>
                    </a>
                    <!-- End::header-link|switcher-icon -->
                </li>
                <!-- End::header-element -->
                @endif

            </ul>
            <!-- End::header-content-right -->

        </div>
        <!-- End::main-header-container -->
</header>
