<script src="{{asset('assets/js/app.js')}}"></script>
<style>
/* Override any conflicting CSS from schedule.css or smart_wizard CSS */
.modal-dialog {
  max-width: 600px !important;
  width: 90% !important;
  margin: 1.75rem auto !important;
}

.modal-content {
  border-radius: 0.5rem !important;
  box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15) !important;
}

.modal-body {
  max-height: 70vh !important;
  overflow-y: auto !important;
  padding: 1rem !important;
  scrollbar-width: thin !important;
  scrollbar-color: #888 #f0f0f0 !important;
}

.select2-container {
  z-index: 10 !important;
}

/* Professional form styling */
.modal .form-label {
  font-weight: 600 !important;
  color: var(--bs-body-color) !important;
  margin-bottom: 0.5rem !important;
}

.modal .form-control {
  border-radius: 0.375rem !important;
  border: 1px solid var(--bs-border-color) !important;
  font-size: 0.875rem !important;
  transition: border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out !important;
}

.modal .form-control:focus {
  border-color: var(--bs-primary) !important;
  box-shadow: 0 0 0 0.2rem rgba(var(--bs-primary-rgb), 0.25) !important;
}

.modal textarea.form-control {
  resize: vertical !important;
  min-height: 120px !important;
}
</style>
<div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
  <div class="modal-content">
    <form id="frm-group" method="post" action="" class="needs-validation" novalidate>
      @csrf
      <div class="modal-header">
        <div class="d-flex align-items-center">
          <div class="p-2 border border-primary border-opacity-10 bg-primary-transparent rounded-circle me-3">
            <span class="avatar avatar-sm avatar-rounded bg-primary svg-white">
              <i class="bi bi-question-circle"></i>
            </span>
          </div>
          <h6 class="modal-title mb-0 fw-semibold">{{__('app.help')}}</h6>
        </div>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="{{__('app.close')}}"></button>
      </div>
      
      <div class="modal-body">
        <!-- Subject Field -->
        <div class="row mb-3">
          <div class="col-12">
            <div class="form-group">
              <label class="form-label fw-semibold">{{__('app.subject')}}</label>
              <input type="text" class="form-control" placeholder="{{__('app.subject')}}" value="" name="subject" required>
              <div class="invalid-feedback">{{__('app.subject_required')}}</div>
            </div>
          </div>
        </div>
        
        <!-- Detail Field -->
        <div class="row mb-3">
          <div class="col-12">
            <div class="form-group">
              <label class="form-label fw-semibold">{{__('app.detail')}}</label>
              <textarea class="form-control" name="detail" rows="7" placeholder="{{ __('app.help_enter_problem') }}" required></textarea>
              <div class="invalid-feedback">{{__('app.detail_required')}}</div>
            </div>
          </div>
        </div>
        
        <!-- Message Display -->
        <div class="row">
          <div class="col-12">
            <div id="msg"></div>
          </div>
        </div>
      </div>
      
      <div class="modal-footer">
        <button type="button" class="btn btn-light" data-bs-dismiss="modal">
          <i class="bi bi-arrow-left me-1"></i>{{__('app.close')}}
        </button>
        <button type="button" id="send-test-email" class="btn btn-primary btn-loading" onclick="sendHelp(this.form)">
          <i class="bi bi-send me-1"></i>{{ __('app.send') }}
        </button>
      </div>
    </form>
  </div>
</div>
