<script src="{{asset('assets/js/app.js')}}"></script>
<div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
<div class="modal-content">
  <form>
    @csrf
    <div class="modal-header">
      <div class="d-flex align-items-center">
        <div class="p-2 border border-primary border-opacity-10 bg-primary-transparent rounded-circle me-3">
          <span class="avatar avatar-sm avatar-rounded bg-primary svg-white">
            <i class="bi bi-send"></i>
          </span>
        </div>
        <h6 class="modal-title mb-0 fw-semibold">{{__('app.send_test_email')}} {{ !empty($display_name) ? ' - '.$display_name : '' }}</h6>
      </div>
      <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
    </div>
    
    <div class="modal-body">

    @if(!empty($broadcast_id) || !empty($template_id))
      <!-- Delivery Server Field -->
      <div class="row">
        <div class="col-12">
          <div class="form-group">
            <label class="form-label fw-semibold">{{__('app.delivery_servers')}}
              <a href="{{ route('sending_servers.create') }}" class="text-primary ms-1">
                <i class="bi bi-plus-circle"></i>
              </a>
            </label>
            @include('includes.dropdown_sending_server', ['popup' => 1, 'multiple' => 0])
          </div>
        </div>
      </div>
      @else
      <input type="hidden" name="sending_server_ids[]" value="{{ $sending_server_id }}">
      @endif      
      <!-- Email Field -->
      <div class="row mb-3">
        <div class="col-12">
          <div class="form-group">
            <label class="form-label fw-semibold">{{__('app.email')}} <small>({{__('app.multiple_emails_help')}})</small></label>
            <textarea class="form-control" placeholder="{{__('app.email_placeholder')}}" name="email" id="email-input" rows="3" required></textarea>
            <div class="invalid-feedback">{{__('app.email_required')}}</div>
            <small class="form-text">{{__('app.multiple_emails_note')}}</small>
          </div>
        </div>
      </div>
      
      <!-- Message Display -->
      <div class="row">
        <div class="col-12">
          <div id="msg"></div>
        </div>
      </div>
    </div>
    
    <div class="modal-footer">
      <input type="hidden" name="broadcast_id" value="{{ $broadcast_id }}">
      <input type="hidden" name="template_id" value="{{ $template_id }}">
      <button type="button" class="btn btn-light" data-bs-dismiss="modal">
        <i class="bi bi-arrow-left me-1"></i>{{__('app.close')}}
      </button>
      <button type="button" id="send-test-email" class="btn btn-primary" 
              data-send-text="{{ __('app.send') }}" 
              data-sending-text="{{ __('app.sending') }}..." 
              data-email-required="{{ __('app.email_required') }}"
              data-invalid-emails="{{ __('app.invalid_emails') }}"
              data-send-failed="{{ __('app.send_failed') }}"
              onclick="sendEmailTest(this.form)">
        <i class="bi bi-send me-1"></i>{{ __('app.send') }}
      </button>
    </div>
  </form>
</div>
</div>
