<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" dir="{{ session('theme_direction', 'ltr') }}" data-nav-layout="vertical" data-theme-mode="light" data-header-styles="light" data-menu-styles="dark" data-toggled="close">
<head>
    <meta charset="UTF-8">
    <meta name='viewport' content='width=device-width, initial-scale=1.0'>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>@yield('title') - {{$settings->app_name ?? 'Relayzo'}}</title>
    <link rel="icon" href="{{asset('images/app/favicon.ico')}}" type="image/x-icon">
    <link id="style" href="{{asset('assets/libs/bootstrap/css/' . (session('theme_direction', 'ltr') === 'rtl' ? 'bootstrap.rtl.min.css' : 'bootstrap.min.css'))}}" rel="stylesheet" >
    <link href="{{asset('assets/css/styles.css')}}" rel="stylesheet" >
    <link href="{{asset('assets/css/icons.css')}}" rel="stylesheet" >
    <link href="{{asset('assets/css/sweetalert.css')}}" rel="stylesheet" >
    <link href="{{asset('assets/css/toastr.min.css')}}" rel="stylesheet" >
    <link href="{{asset('assets/libs/node-waves/waves.min.css')}}" rel="stylesheet" > 
    <link href="{{asset('assets/libs/simplebar/simplebar.min.css')}}" rel="stylesheet" >
    <link rel="stylesheet" href="{{asset('assets/libs/@simonwep/pickr/themes/nano.min.css')}}">
    <link rel="stylesheet" href="{{asset('assets/libs/choices.js/public/assets/styles/choices.min.css')}}">
    <link rel="stylesheet" href="{{asset('assets/libs/flatpickr/flatpickr.min.css')}}">
    <link rel="stylesheet" href="{{asset('assets/libs/select2/css/select2.min.css')}}">
    <link rel="stylesheet" href="{{asset('components/multiselect/css/bootstrap-multiselect.css')}}" type="text/css"/>
    <link href="{{asset('assets/css/custom.css')}}" rel="stylesheet" >
    <style>
    .page-header-breadcrumb{
        margin-block: 1em !important;
    }
    
    /* Global modal z-index fix to ensure modals appear above all dropdowns */
    .modal {
        z-index: 1055 !important;
    }
    .modal-backdrop {
        z-index: 1050 !important;
    }
    .modal-dialog {
        z-index: 1055 !important;
    }
    .modal-content {
        z-index: 1055 !important;
    }
    
    /* Generic button height reduction */
    .btn {
        padding: 0.25rem 0.5rem;
        font-size: 0.875rem;
        line-height: 1.5;
        border-radius: 0.25rem;
    }
    
    /* Specific styling for dropdown toggle buttons */
    .btn-outline-primary.dropdown-toggle {
        padding: 0.25rem 0.5rem;
        font-size: 0.875rem;
        line-height: 1.5;
        border-radius: 0.25rem;
    }
    
    /* DataTable elements styling */
    .dataTables_wrapper .dataTables_length select,
    .dataTables_wrapper .dataTables_filter input {
        padding: 0.25rem 0.5rem;
        font-size: 0.875rem;
        line-height: 1.5;
        border-radius: 0.25rem;
        height: calc(0.25rem * 2 + 0.875rem * 1.5);
        min-height: calc(0.25rem * 2 + 0.875rem * 1.5);
    }
    
    .dataTables_wrapper .dataTables_length,
    .dataTables_wrapper .dataTables_filter {
        font-size: 0.875rem;
    }
    
    .dataTables_wrapper .dataTables_paginate .paginate_button {
        padding: 0.25rem 0.5rem;
        font-size: 0.875rem;
        line-height: 1.5;
        border-radius: 0.25rem;
    }
    
    /* Fix DataTable length selector dropdown arrow */
    .dataTables_wrapper .dataTables_length select {
        background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16'%3e%3cpath fill='none' stroke='%23343a40' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='m1 6 7 7 7-7'/%3e%3c/svg%3e");
        background-repeat: no-repeat;
        background-position: right 0.75rem center;
        background-size: 16px 12px;
        padding-right: 2.5rem;
        appearance: none;
        -webkit-appearance: none;
        -moz-appearance: none;
    }
    </style>
    @yield('styles')   
</head>
<body>
    <!-- Start Switcher -->
    @include('includes.switcher')
    <!-- End Switcher -->

    <!-- Loader -->
    <div id="loader" >
        <img src="{{asset('assets/images/media/loader.svg')}}" alt="">
    </div>
    <!-- Loader -->
    <div class="page">
         <!-- app-header -->
         @include('includes.header')
        <!-- /app-header -->

        <!-- Start::app-sidebar -->
        @include('includes.sidebar')
        <!-- End::app-sidebar -->

        <!-- Start::app-content -->
        <div class="main-content app-content">
            <div class="container-fluid">
                @include('includes.breadcrumbs')
                @yield('content')
            </div>
        </div>
        <!-- End::app-content -->

        <!-- Footer Start -->
        @include('includes.footer')
        <!-- Footer End -->
    </div>

<!-- Scroll To Top -->
<div class="scrollToTop">
    <span class="arrow"><i class="ti ti-arrow-narrow-up fs-20"></i></span>
</div>
<div id="responsive-overlay"></div>
<!-- Scroll To Top -->

<script src="{{asset('assets/js/jquery.min.js')}}"></script>
<script src="{{asset('assets/js/sweetalert.min.js')}}"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="{{asset('assets/js/toastr.min.js')}}"></script>
<script src="{{asset('assets/libs/choices.js/public/assets/scripts/choices.min.js')}}"></script>
<script src="{{asset('assets/js/main.js')}}"></script>
<script src="{{asset('assets/libs/@popperjs/core/umd/popper.min.js')}}"></script>
<script src="{{asset('assets/libs/bootstrap/js/bootstrap.bundle.min.js')}}"></script>
<script src="{{asset('assets/js/defaultmenu.min.js')}}"></script>
<script src="{{asset('assets/libs/node-waves/waves.min.js')}}"></script>
<script src="{{asset('assets/js/sticky.js')}}"></script>
<script src="{{asset('assets/libs/simplebar/simplebar.min.js')}}"></script>
<script src="{{asset('assets/js/simplebar.js')}}"></script>
<script src="{{asset('assets/libs/@simonwep/pickr/pickr.es5.min.js')}}"></script>
<script src="{{asset('assets/libs/datatables/js/jquery.dataTables.min.js')}}"></script>
<script src="{{asset('assets/libs/select2/js/select2.min.js')}}"></script>
<script src="{{asset('assets/libs/flatpickr/flatpickr.min.js')}}"></script>
<script type="text/javascript" src="{{asset('components/multiselect/js/bootstrap-multiselect.js')}}"></script>
<script src="{{asset('assets/js/custom.js')}}"></script>
<script src="{{asset('assets/js/custom-switcher.min.js')}}"></script>
<script src="{{asset('assets/js/moment.js')}}"></script>
<script src="{{asset('assets/js/moment-timezone-with-data.js')}}"></script>
<script src="{{asset('assets/js/clock.js')}}"></script>
<script src="{{asset('assets/js/datatable.init.js')}}"></script>
<script src="{{asset('assets/js/show-password.js')}}"></script>
<script src="{{asset('assets/js/app.js')}}"></script>
@stack('scripts')
<script type="text/javascript">
$.ajaxSetup({
    headers: {
      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    }
});
</script>
@if(empty($settings->license_key))
  @include('tools.license_refresh')
  <script type="text/javascript">
    $(window).on('load',function(){
        $('#modal-refresh-license').modal('show');
    });
  </script>
@else
   @include('includes.modal') 
@endif

<script type="text/javascript">
// Auto-set theme direction based on user's language preference
$(document).ready(function() {
    const themeDirection = '{{ session("theme_direction", "ltr") }}';
    
    // Function to apply theme direction
    function applyThemeDirection(direction) {
        const html = document.querySelector('html');
        const styleLink = document.querySelector('#style');
        
        if (direction === 'rtl') {
            // Apply RTL
            html.setAttribute("dir", "rtl");
            if (styleLink && !styleLink.href.includes('bootstrap.rtl.min.css')) {
                styleLink.setAttribute("href", "../assets/libs/bootstrap/css/bootstrap.rtl.min.css");
            }
            
            // Set RTL switcher as checked
            if (document.querySelector('#switcher-rtl')) {
                document.querySelector('#switcher-rtl').checked = true;
                document.querySelector('#switcher-ltr').checked = false;
            }
            
            // Set localStorage to maintain state
            localStorage.setItem("xintrartl", true);
            localStorage.removeItem("xintraltr");
        } else {
            // Apply LTR
            html.setAttribute("dir", "ltr");
            if (styleLink && !styleLink.href.includes('bootstrap.min.css')) {
                styleLink.setAttribute("href", "../assets/libs/bootstrap/css/bootstrap.min.css");
            }
            
            // Set LTR switcher as checked
            if (document.querySelector('#switcher-ltr')) {
                document.querySelector('#switcher-ltr').checked = true;
                document.querySelector('#switcher-rtl').checked = false;
            }
            
            // Set localStorage to maintain state
            localStorage.setItem("xintraltr", true);
            localStorage.removeItem("xintrartl");
        }
    }
    
    // Apply theme direction on page load
    applyThemeDirection(themeDirection);
    
    // Listen for language change events (if any)
    $(document).on('click', 'a[href*="/language/"]', function(e) {
        // Extract language from href
        const href = $(this).attr('href');
        const langMatch = href.match(/\/language\/([^\/]+)/);
        if (langMatch) {
            const lang = langMatch[1];
            const direction = (lang === 'ar') ? 'rtl' : 'ltr';
            
            // Apply theme direction immediately
            applyThemeDirection(direction);
        }
    });
});
</script>
</body>
</html>
