<script src="{{asset('assets/js/app.js')}}"></script>
<style>
/* Ensure popovers appear above modals */
.popover {
    z-index: 9999 !important;
}
</style>
<script>
$('[data-bs-toggle="popover"]').popover({
    container: 'body'
});
</script>
<div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg">
<div class="modal-content">
  <form class="form-horizontal" id="frm-group" method="post" class="needs-validation" novalidate>
    @csrf
    <div class="modal-header">
      <div class="d-flex align-items-center">
        <div class="me-3">
          <span class="avatar avatar-sm avatar-rounded bg-info svg-white">
            <i class="bi bi-arrow-repeat"></i>
          </span>
        </div>
        <h6 class="modal-title mb-0 fw-semibold">{{ __('app.bulk_update') }}</h6>
      </div>
      <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
    </div>
    <div class="modal-body">
      <div class="box-body">
        <!-- Preference Section -->
        <div class="row mb-3">
          <div class="col-12">
            <div class="d-flex align-items-center justify-content-between">
              <div class="d-flex align-items-center">
                <div class="me-3">
                  <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                    <i class="bi bi-gear"></i>
                  </span>
                </div>
                <h6 class="mb-0 text-info fw-semibold fs-14">
                  {{__('app.preference')}}
                </h6>
              </div>
              <a tabindex="-1" role="button" data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="left" 
                 title="{{__('app.preference')}}" data-bs-content="{{__('app.bulk_update_preference_help')}}" 
                 data-bs-custom-class="header-primary" class="text-primary">
                <i class="bi bi-question-circle"></i>
              </a>
            </div>
          </div>
          <div class="col-12">
            <div class="form-group">
              <label class="form-label fw-semibold">
              </label>
              <select name="option" id="option" class="form-select">
              <option value="file">{{ __('app.file') }}</option>
                <option value="list">{{ __('app.lists') }}</option>                   
                <option value="write">{{ __('app.emails') }}</option>            
              </select>
            </div>
          </div>
        </div>

        <!-- Lists Selection Section -->
        <div class="row mb-3">
          <div class="col-12">
            <div class="d-flex align-items-center justify-content-between">
              <div class="d-flex align-items-center">
                <div class="me-3">
                  <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                    <i class="bi bi-list-ul"></i>
                  </span>
                </div>
                <h6 class="mb-0 text-info fw-semibold fs-14">{{__('app.lists')}}</h6>
              </div>
              <a tabindex="-1" role="button" data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="left" 
                 title="{{__('app.lists')}}" data-bs-content="{{__('app.bulk_update_lists_help')}}" 
                 data-bs-custom-class="header-primary" class="text-primary">
                <i class="bi bi-question-circle"></i>
              </a>
            </div>
          </div>
          <div class="col-12">
            <div class="form-group">
              <label class="form-label fw-semibold"></label>
              @php $list_ids = []; @endphp
              @include('includes.dropdown_lists', ['popup' => 1, 'multiple' => 1])
            </div>
          </div>
        </div>

        <!-- Data Input Section -->
        <div class="row mb-3" id="data-input-section">
          <div class="col-12">
            <div class="d-flex align-items-center">
              <div class="me-3">
                <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                  <i class="bi bi-upload"></i>
                </span>
              </div>
              <h6 class="mb-0 text-info fw-semibold fs-14">{{__('app.data_input')}}</h6>
            </div>
          </div>
          <div class="col-12" id="section-emails" style="display: none;">
            <div class="form-group">
              <label class="form-label fw-semibold"></label>
              <textarea class="form-control" name="emails" rows="6" placeholder="{{__('app.email_addresses')}}, {{ __('app.multiple_emails_placeholder') }}" required></textarea>
            </div>
          </div>
          <div class="col-12" id="section-file">
            <div class="form-group">
              <label class="form-label fw-semibold"></label>
              <input class="form-control" name="file" type="file" id="file">
            </div>
          </div>
          <div class="col-12 pt-3" id="info-filesize">
            {!! \App\Http\Helper\Helper::getMaxFileSize(false, true) !!}
          </div>
        </div>

        <!-- Action Section -->
        <div class="row mb-2">
          <div class="col-12">
            <div class="d-flex align-items-center justify-content-between">
              <div class="d-flex align-items-center">
                <div class="me-3">
                  <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                    <i class="bi bi-lightning"></i>
                  </span>
                </div>
                <h6 class="mb-0 text-info fw-semibold fs-14">{{__('app.action')}}</h6>
              </div>
              <a tabindex="-1" role="button" data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="left" 
                 title="{{__('app.action')}}" data-bs-content="{{__('app.bulk_update_action_help')}}" 
                 data-bs-custom-class="header-primary" class="text-primary">
                <i class="bi bi-question-circle"></i>
              </a>
            </div>
          </div>
          <div class="col-12">
            <div class="form-group">
              <label class="form-label fw-semibold"></label>
              <select name="action" id="action" class="form-select">
                <option value="active">{{__('app.set_as_active')}}</option>
                <option value="inactive">{{__('app.set_as_inactive')}}</option>
                <option value="confirmed">{{__('app.set_as_confirmed')}}</option>
                <option value="unconfirmed">{{__('app.set_as_unconfirmed')}}</option>
                <option value="subscribed">{{__('app.set_as_subscribed')}}</option>
                <option value="unsubscribed">{{__('app.set_as_unsubscribed')}}</option>
                <option value="verified">{{__('app.set_as_verified')}}</option>
                <option value="unverified">{{__('app.set_as_unverified')}}</option>
              </select>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="modal-footer">
      <button type="button" class="btn btn-light" data-bs-dismiss="modal">
        <i class="bi bi-x-lg me-1"></i>{{__('app.close')}}
      </button>
      <button id="btn-import" type="button" class="btn btn-primary btn-loading" onclick="importBulkUpdate(this.form);">
        <i class="bi bi-arrow-repeat me-1"></i>{{__('app.update')}}
      </button>
    </div>
  </form>
</div>
</div>
<span id="msg_update" data-value="{{__('app.updated_successfully')}}"></span>
