@extends('layouts.app')
@section('title', $page_title)

@push('scripts')
<script>
$(document).ready(function() {
  // Initialize Choices.js for custom fields
  (function () {
    'use strict';
    const multipleDefault = new Choices(document.getElementById('custom_fields'), {
      allowHTML: true,
      removeItemButton: true,
    });
  })();
  
  // Initialize Select2 for group dropdown
  $('#group_id').select2({
    placeholder: '{{__("app.select_group")}}',
    allowClear: false,
    width: '100%',
    dropdownParent: $('body')
  });
  
  // Initialize Select2 for email domain dropdown
  $('#sending-domains').select2();
});
</script>
@endpush

@section('styles')
<style type="text/css">
/* Keep Choices.js z-index appropriate */
#custom_fields + .choices {
   z-index: 1000 !important;
}

/* Group dropdown styling */
.select2-container { z-index: 1040 !important; }
.select2-dropdown { max-height: 300px; overflow-y: auto; z-index: 1040 !important; position: absolute !important; }
.select2-results__options { max-height: 250px; overflow-y: auto; }
.select2-results__option { padding: 8px 12px; font-size: 14px; }
.select2-results__option--highlighted { background-color: #007bff; color: white; }
.select2-container--default .select2-results > .select2-results__options { max-height: 250px; overflow-y: auto; }
.select2-dropdown--below { z-index: 1040 !important; }
.form-group { overflow: visible !important; }
.col-md-6 { overflow: visible !important; }

/* Email input group styling */
.input-group > .select2-container {
  flex: 1 1 auto;
  width: auto !important;
}
#from_email_part1 {
  height: 100%;
}
</style>
@endsection

@section('content')
<div class="row">
  <div class="col-12">
<div class="card custom-card">
  <div class="card-body">
        <form method="POST" action="{{ route('lists.store') }}" class="needs-validation" novalidate>
      @csrf
          
          <!-- General Information Section -->
          <div class="row mb-3">
            
            <div class="col-md-6">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{__('app.group')}}
                  <a href="javascript:;" onclick="viewModal('modal', '{{route('group.create', ['type_id' => config('custom.group_lists')])}}');" class="text-primary ms-1">
                    <i class="bi bi-plus-circle"></i>
          </a>
        </label>
        <select name="group_id" class="form-select" id="group_id" required>
          <option value="">{{__('app.select_group')}}</option>
          @foreach($groups as $id => $group_name)
          <option value="{{ $id }}" {{ old('group_id') == $id ? 'selected' : '' }}>{{$group_name}}</option>
          @endforeach
        </select>
        <div class="invalid-feedback">{{ __('app.select_group_error')}}</div>
      </div>
            </div>
            
            <div class="col-md-6">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{__('app.name')}}</label>
        <input type="text" class="form-control" placeholder="{{__('app.name')}}" value="{{ old('name') }}" name="name" required>
                <div class="invalid-feedback">{{__('app.name_required')}}</div>
              </div>
            </div>
            
            <div class="col-12">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{__('app.description')}}</label>
                <textarea class="form-control" placeholder="{{__('app.description')}}" rows="3" name="description">{{ old('description') }}</textarea>
      </div>
      </div>
            
            <div class="col-12">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{__('app.custom_field')}}
                  <a href="javascript:;" onclick="viewModal('modal', '{{route('custom_fields.create')}}');" class="text-primary ms-1">
                    <i class="bi bi-plus-circle"></i>
                  </a>
                  <a tabindex="-1" role="button" data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" 
                     title="{{__('app.custom_field')}}" data-bs-content="{{__('app.list_custom_fields')}}" 
                     data-bs-custom-class="header-primary" class="text-primary ms-1">
                    <i class="bi bi-question-circle"></i>
            </a>
        </label>
        <select name="custom_fields[]" id="custom_fields" class="form-control" multiple>
          @foreach($custom_fields as $id => $custom_field)
          <option value="{{ $id }}" {{ in_array($id, old('custom_fields', [])) ? 'selected' : '' }}>{{ $custom_field }}</option>
          @endforeach
        </select>
      </div>
            </div>
          </div>

          <!-- Email Settings Section -->
          <div class="row mb-3">
            <div class="col-12">
              <div class="d-flex align-items-center">
                <div class="me-3">
                  <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                    <i class="bi bi-envelope"></i>
                  </span>
                </div>
                <h6 class="mb-0 text-info fw-semibold fs-14">{{__('app.email_settings')}}</h6>
              </div>
            </div>
            
            <div class="col-md-4">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{__('app.double_optin')}}
                  <a tabindex="-1" role="button" data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" 
                     title="{{__('app.double_optin')}}" data-bs-content="{{__('app.list_double_optin')}}" 
                     data-bs-custom-class="header-primary" class="text-primary ms-1">
                    <i class="bi bi-question-circle"></i>
                  </a>
                </label>
                <select name="double_optin" class="form-select">
          <option value="No" {{ old('double_optin', 'No') == 'No' ? 'selected' : '' }}>{{ __('app.no')}}</option>
          <option value="Yes" {{ old('double_optin') == 'Yes' ? 'selected' : '' }}>{{ __('app.yes') }}</option>
        </select>
      </div>
            </div>
            
            <div class="col-md-4">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{__('app.welcome_email')}}
                  <a tabindex="-1" role="button" data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" 
                     title="{{__('app.welcome_email')}}" data-bs-content="{{__('app.list_welcome_email')}}" 
                     data-bs-custom-class="header-primary" class="text-primary ms-1">
                    <i class="bi bi-question-circle"></i>
                  </a>
                </label>
                <select name="welcome_email" class="form-select">
          <option value="No" {{ old('welcome_email') == 'No' ? 'selected' : '' }}>{{ __('app.no')}}</option>
          <option value="Yes" {{ old('welcome_email') == 'Yes' ? 'selected' : '' }}>{{ __('app.yes') }}</option>
        </select>
      </div>
            </div>
            
            <div class="col-md-4">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{__('app.unsub_email')}}
                  <a tabindex="-1" role="button" data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" 
                     title="{{__('app.unsub_email')}}" data-bs-content="{{__('app.list_unsub_email')}}" 
                     data-bs-custom-class="header-primary" class="text-primary ms-1">
                    <i class="bi bi-question-circle"></i>
                  </a>
                </label>
                <select name="unsub_email" class="form-select">
          <option value="No" {{ old('unsub_email') == 'No' ? 'selected' : '' }}>{{ __('app.no')}}</option>
          <option value="Yes" {{ old('unsub_email') == 'Yes' ? 'selected' : '' }}>{{ __('app.yes') }}</option>
        </select>
      </div>
            </div>
            
            <div class="col-12">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{__('app.notify_email')}}
                  <a tabindex="-1" role="button" data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" 
                     title="{{__('app.notify_email')}}" data-bs-content="{{__('app.list_notify_email')}}" 
                     data-bs-custom-class="header-primary" class="text-primary ms-1">
                    <i class="bi bi-question-circle"></i>
                  </a>
                </label>
                <input type="email" class="form-control" placeholder="{{__('app.notify_email')}}" value="{{ old('notify_email') }}" name="notify_email">
              </div>
            </div>
          </div>

          <!-- Sender Information Section -->
          <div class="row mb-3">
            <div class="col-12">
              <div class="d-flex align-items-center">
                <div class="me-3">
                  <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                    <i class="bi bi-person-gear"></i>
                  </span>
                </div>
                <h6 class="mb-0 text-info fw-semibold fs-14">{{__('app.sender_information')}}
                  <a tabindex="-1" role="button" data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" 
                     title="{{__('app.from_detail')}}" data-bs-content="{{__('app.list_from_detail')}}" 
                     data-bs-custom-class="header-primary" class="text-primary ms-1">
                    <i class="bi bi-question-circle"></i>
                  </a>
                </h6>
              </div>
      </div>
      
            <div class="col-md-4">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{__('app.from_name')}}</label>
                <input type="text" class="form-control" placeholder="{{__('app.from_name')}}" value="{{ old('from_name') }}" name="from_name" required>
                <div class="invalid-feedback">{{__('app.from_name_required')}}</div>
              </div>
      </div>

            <div class="col-md-4">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{__('app.from_email')}}
                  <a href="{{route('sending_domains.index')}}" class="text-primary ms-1">
                    <i class="bi bi-plus-circle"></i>
                  </a>
                </label>
        <div class="input-group">
                  <div style="width: 35%;">
                    <input type="text" name="from_email_part1" id="from_email_part1" class="form-control" placeholder="{{__('app.from_email_example')}}" value="{{ old('from_email_part1') }}" required>
                  </div>
                  <span class="input-group-text">@</span>
                  <select name="from_email_part2" id="sending-domains" class="single-select form-select" required>
                    @include('includes.dropdown_sending_domains')
                  </select>
                </div>
                <div class="invalid-feedback">{{__('app.from_email_required')}}</div>
        </div>
      </div>

            <div class="col-md-4">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{__('app.reply_email')}}</label>
                <input type="email" class="form-control" placeholder="{{__('app.reply_email')}}" value="{{ old('reply_email') }}" name="reply_email" required>
                <div class="invalid-feedback">{{__('app.reply_email_required')}}</div>
              </div>
            </div>
      </div>

          <!-- Action Buttons -->
          <div class="row">
            <div class="col-12">
              <div class="d-flex gap-2 justify-content-start">
                <button type="submit" name="save_continue" value="1" class="btn btn-primary">
                  <i class="bi bi-save me-1"></i>{{__('app.save_continue')}}
                </button>
                <button type="submit" name="save_exit" value="1" class="btn btn-success">
                  <i class="bi bi-check-lg me-1"></i>{{__('app.save_exit')}}
                </button>
                <a href="{{route('lists.index')}}" class="btn btn-light">
                  <i class="bi bi-arrow-left me-1"></i>{{__('app.cancel')}}
                </a>
              </div>
            </div>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>
@include('includes.modal')
@endsection
