<style>
.modal-body {
  overflow-y: scroll !important; /* Ensures scrolling */
  scrollbar-width: thin; /* For Firefox */
  scrollbar-color: #888 #f0f0f0; /* Scrollbar track and thumb color */
}
</style>

<div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-xl">
  <div class="modal-content">
    <div class="modal-header">
      <h6 class="modal-title">
        <i class="bi bi-list-ul me-2"></i>{{ __('app.list_details') }}
      </h6>
      <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="{{__('app.close')}}"></button>
    </div>
    
    <div class="modal-body">
      <!-- Statistics Cards -->
      <div class="row">
        <div class="col-md-6 col-lg-4 col-xl">
          <div class="card custom-card crm-card">
            <div class="card-body p-2">
              <div class="d-flex align-items-center">
                <div class="p-1 border border-info border-opacity-10 bg-info-transparent rounded-circle me-2">
                  <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                    <i class="bi bi-people"></i>
                  </span>
                </div>
                <div>
                  <p class="fs-11 mb-0">{{ __('app.total_contacts') }}</p>
                  <h6 class="mb-0">{{ $list->contacts->count() }}</h6>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="col-md-6 col-lg-4 col-xl">
          <div class="card custom-card crm-card">
            <div class="card-body p-2">
              <div class="d-flex align-items-center">
                <div class="p-1 border border-info border-opacity-10 bg-info-transparent rounded-circle me-2">
                  <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                    <i class="bi bi-check-circle"></i>
                  </span>
                </div>
                <div>
                  <p class="fs-11 mb-0">{{ __('app.active_contacts') }}</p>
                  <h6 class="mb-0">{{ $list->contacts()->where('is_active', 1)->count() }}</h6>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="col-md-6 col-lg-4 col-xl">
          <div class="card custom-card crm-card">
            <div class="card-body p-2">
              <div class="d-flex align-items-center">
                <div class="p-1 border border-info border-opacity-10 bg-info-transparent rounded-circle me-2">
                  <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                    <i class="bi bi-envelope"></i>
                  </span>
                </div>
                <div>
                  <p class="fs-11 mb-0">{{ __('app.confirmed_contacts') }}</p>
                  <h6 class="mb-0">{{ $list->contacts()->where('is_confirmed', 1)->count() }}</h6>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="col-md-6 col-lg-4 col-xl">
          <div class="card custom-card crm-card">
            <div class="card-body p-2">
              <div class="d-flex align-items-center">
                <div class="p-1 border border-info border-opacity-10 bg-info-transparent rounded-circle me-2">
                  <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                    <i class="bi bi-shield-check"></i>
                  </span>
                </div>
                <div>
                  <p class="fs-11 mb-0">{{ __('app.verified_contacts') }}</p>
                  <h6 class="mb-0">{{ $list->contacts()->where('is_verified', 1)->count() }}</h6>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="col-md-6 col-lg-4 col-xl">
          <div class="card custom-card crm-card">
            <div class="card-body p-2">
              <div class="d-flex align-items-center">
                <div class="p-1 border border-info border-opacity-10 bg-info-transparent rounded-circle me-2">
                  <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                    <i class="bi bi-person-x"></i>
                  </span>
                </div>
                <div>
                  <p class="fs-11 mb-0">{{ __('app.unsubscribed_contacts') }}</p>
                  <h6 class="mb-0">{{ $list->contacts()->where('is_unsubscribed', 1)->count() }}</h6>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>

      <!-- Basic Information Section -->
      <div class="card custom-card">
        <div class="card-body">
          <h6><i class="bi bi-info-circle"></i> {{ __('app.basic_information') }}</h6>
          
          <div class="row mb-3">
            <label class="col-md-3 form-label">{{ __('app.name') }}</label>
            <div class="col-md-9">{{ $list->name }}</div>
          </div>
          
          <div class="row mb-3">
            <label class="col-md-3 form-label">{{ __('app.group') }}</label>
            <div class="col-md-9">{{ $list->group->name }}</div>
          </div>
          
          <div class="row mb-3">
            <label class="col-md-3 form-label">{{ __('app.created') }}</label>
            <div class="col-md-9">{{ \App\Http\Helper\Helper::datetimeDisplay($list->created_at) }}</div>
          </div>
        </div>
      </div>

      <!-- Email Settings Section -->
      <div class="card custom-card">
        <div class="card-body">
          <h6><i class="bi bi-envelope-gear"></i>{{ __('app.email_settings') }}</h6>
          
          <div class="row mb-3">
            <label class="col-md-3 form-label">{{ __('app.double_optin') }}</label>
            <div class="col-md-9">{{ $list->double_optin == 'Yes' ? __('app.yes') : __('app.no') }}</div>
          </div>
          
          <div class="row mb-3">
            <label class="col-md-3 form-label">{{ __('app.welcome_email') }}</label>
            <div class="col-md-9">{{ $list->welcome_email == 'Yes' ? __('app.yes') : __('app.no') }}</div>
          </div>
          
          <div class="row mb-3">
            <label class="col-md-3 form-label">{{ __('app.unsub_email') }}</label>
            <div class="col-md-9">{{ $list->unsub_email == 'Yes' ? __('app.yes') : __('app.no') }}</div>
          </div>
          
          <div class="row mb-3">
            <label class="col-md-3 form-label">{{ __('app.notify_email') }}</label>
            <div class="col-md-9">{{ $list->notify_email ?? '---' }}</div>
          </div>
        </div>
      </div>

      <!-- Sender Information Section -->
      <div class="card custom-card">
        <div class="card-body">
          <h6><i class="bi bi-person-gear"></i> {{ __('app.sender_information') }}</h6>
          
          <div class="row mb-3">
            <label class="col-md-3 form-label">{{ __('app.from_name') }}</label>
            <div class="col-md-9">{{ $list->from_name ?? '---' }}</div>
          </div>
          
          <div class="row mb-3">
            <label class="col-md-3 form-label">{{ __('app.from_email') }}</label>
            <div class="col-md-9">{{ $list->from_email ?? '---' }}</div>
          </div>
          
          <div class="row mb-3">
            <label class="col-md-3 form-label">{{ __('app.reply_email') }}</label>
            <div class="col-md-9">{{ $list->reply_email ?? '---' }}</div>
          </div>
        </div>
      </div>

      <!-- Custom Fields Section -->
      <div class="card custom-card">
        <div class="card-body">
          <h6><i class="bi bi-list-check"></i> {{ __('app.custom_fields') }}</h6>
          
          @php ($custom_fields = $list->customFields) @endphp
          @forelse($custom_fields as $custom_field)
            <div class="row mb-3">
              <label class="col-md-3 form-label">{{ $custom_field->name }}</label>
              <div class="col-md-9">{{ ucfirst($custom_field->type) }}</div>
            </div>
          @empty
            <div class="text-center">
              <i class="bi bi-inbox"></i>
              <h6>{{ __('app.no_custom_fields') }}</h6>
              <p>{{ __('app.no_custom_fields_description') }}</p>
            </div>
          @endforelse
        </div>
      </div>
    </div>
    
    <div class="modal-footer">
      <button type="button" class="btn btn-danger" data-bs-dismiss="modal">{{__('app.close')}}</button>
      <a href="{{ route('lists.edit', [$list->id]) }}">
        <button type="button" class="btn btn-primary">{{ __('app.edit') }}</button>
      </a>
    </div>
  </div>
</div>
