@extends('layouts.app')
@section('title', $page_title)

{{-- Include global DataTable styling --}}
@include('components.datatable-styles')

@push('scripts')
<script>
$(function () {
    'use strict';
    var table = $('#data').DataTable({
        "columnDefs": [{"sortable": false, "targets": []}],
        "order": [[ 1, "desc" ]],
        "lengthMenu": [[100, 200, 500], [100, 200, 500]],
        "ajax": $('#route-activity-logs').data('route'),
    });
    table.on('draw', function() {
        $('#data_paginate a').addClass('btn btn-primary me-1');
        $('#data_paginate .paginate_button.current').addClass('btn-light').removeClass('btn-primary');
    });
});
</script>
@endpush

@section('content')
<div class="row">
    <div class="col-xl-12">
        <div class="card custom-card">
            <div class="card-body">
                <div class="table-responsive">
                    <table id="data" class="table table-bordered text-nowrap w-100">
                        <thead>
                            <tr>
                                <th>{{ __('app.id') }}</th>
                                <th>{{ __('app.user') }}</th>
                                <th>{{ __('app.name') }}</th>
                                <th>{{ __('app.description') }}</th>
                                <th>{{ __('app.created') }}</th>
                            </tr>
                        </thead>
                         <tbody></tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<span id="route-activity-logs" data-route="{{ route('activitylogs') }}"></span>
@include('includes.datatables')
@endsection
