@extends('layouts.app')
@section('title', $page_title)

@section('content')
<div class="row">
    <div class="col-xl-12">
        <div class="card custom-card">
            <div class="card-body">
                <div class="row mb-3">
                    <div class="col-md-6">
                        <a href="{{route('error.logs.clear')}}" class="btn btn-primary btn-loading" id="clear-error-logs-btn">
                            <i class="bi bi-trash me-2"></i>{{__('app.clear_error_logs')}}
                        </a>
                    </div>
                </div>
                <pre style="background: #1e1e1e; font-size:14px; color: #fff; padding: 15px; border-radius: 5px; overflow: auto; max-height: 100%; font-family: monospace; text-wrap: auto;">
{!! \App\Http\Helper\Helper::getLaravelLogs(100) !!}
                </pre>
            </div>
        </div>
    </div>
</div>
@push('scripts')
<script>
$(function () {
    // Handle Clear Error Logs button click with error handling
    $('#clear-error-logs-btn').on('click', function(e) {
        e.preventDefault();
        var href = $(this).attr('href');
        var $btn = $(this);
        var $icon = $btn.find('i');
        $icon.removeClass('bi-trash').addClass('spinner-border spinner-border-sm');
        $.ajax({
            url: href, type: 'GET',
            success: function() { window.location.href = href; },
            error: function(xhr) {
                $icon.removeClass('spinner-border spinner-border-sm').addClass('bi-trash');
                if (xhr.status === 401) { alert('You do not have permission to clear error logs. Please contact your administrator.'); }
                else if (xhr.status === 403) { alert('Access forbidden. You do not have the required permissions.'); }
                else { alert('An error occurred while trying to clear error logs. Please try again.'); }
            }
        });
    });
});
</script>
@endpush
@endsection
