@php
session_save_path(__DIR__ . '/sessions');
if (!is_dir(__DIR__ . '/sessions')) {
    mkdir(__DIR__ . '/sessions', 0777, true);
}
session_start();
$_SESSION['user_id'] = Auth::user()->id; // will be us in mc_imageuploader
$_SESSION['lang'] = Auth::user()->language; // will be us in mc_imageuploader
@endphp
@extends('layouts.app')
@section('title', $page_title)

@section('styles')
<style>
.image-manager{
	min-height: 700px;
	border-radius: 8px;
	border: 1px solid #e3e6f0;
	background: transparent;
}
.image-manager-header {
	background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
	border-radius: 8px 8px 0 0;
	padding: 0.5rem 1rem;
	margin-bottom: 0;
}
</style>
@endsection

@section('content')
<div class="row">
  <div class="col-12">
    <div class="card custom-card">
      <!-- Image Manager Header -->
      <div class="image-manager-header">
        <div class="d-flex align-items-center">
          <div class="p-1 border border-white border-opacity-20 bg-white-transparent rounded-circle me-2">
            <span class="avatar avatar-xs avatar-rounded bg-white svg-primary">
              <i class="bi bi-images"></i>
            </span>
          </div>
          <div>
            <p class="mb-0 text-white-50 fs-12">{{__('app.manage_and_organize_your_images')}}</p>
          </div>
        </div>
      </div>
      
      <!-- Image Manager Content -->
      <div class="card-body p-0">
        <div class="col-12">
          <iframe src="/components/ckeditor/plugins/mc_uploader/uploader.php?CKEditor=content_html&CKEditorFuncNum=0&langCode={{$_SESSION['lang']}}&su_id={{$_SESSION['user_id']}}" frameborder="0" scrolling="yes" width="100%" class="image-manager"></iframe>
        </div>
      </div>
    </div>
  </div>
</div>
@endsection
