@extends('layouts.app')
@section('title', $page_title)

{{-- Include global DataTable styling --}}
@include('components.datatable-styles')

@push('scripts')
<script>
$(function () {
    'use strict';
    var table = $('#data').DataTable({
        "order": [[ 2, "desc" ]],
        "lengthMenu": [[100, 200, 500], [100, 200, 500]],
        "ajax": $('#route-notifications').data('route'),
    });
    table.on('draw', function() {
        $('#data_paginate a').addClass('btn btn-primary me-1');
        $('#data_paginate .paginate_button.current').addClass('btn-light').removeClass('btn-primary');
    });
});
</script>
@endpush

@section('content')
<div class="row">
    <div class="col-xl-12">
        <div class="card custom-card">
            <div class="card-body">
                <div class="table-responsive">
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <a href="{{ route('notification.read.all') }}" class="btn btn-primary" id="addRow" style="display: none;">
                                <i class="bi bi-check-circle me-2"></i>{{__('app.clear_all')}}
                            </a>
                        </div>
                        <div class="col-md-6 text-end">
                            <div class="btn-group">
                                <button type="button" class="btn btn-outline-primary dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                                    <i class="bi bi-gear me-1"></i>{{__('app.actions')}}
                                </button>
                                <ul class="dropdown-menu">
                                    <li><a class="dropdown-item" href="javascript:;" onclick="destroyMany('{{ route('contacts.destroy', [0]) }}')">
                                        <i class="bi bi-trash me-2"></i>{{ __('app.delete') }}
                                    </a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <table id="data" class="table table-bordered text-nowrap w-100">
                        <thead>
                            <tr>
                                <th>{{ __('app.name') }}</th>
                                <th>{{ __('app.type') }}</th>
                                <th>{{ __('app.created') }}</th>
                                <th>{{ __('app.delete') }}</th>
                            </tr>
                        </thead>
                         <tbody></tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<span id="route-notifications" data-route="{{ route('get.notifications') }}"></span>
@include('includes.datatables')
@endsection
