<script src="{{asset('assets/js/app.js')}}"></script>
<script type="text/javascript">
  $('[data-bs-toggle="popover"]').popover({
    container: 'body'
  });
</script>
<div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg">
    <div class="modal-content">
        <form id="frm-group" method="post" action="{{route('notes.store')}}" class="needs-validation" novalidate>
            @csrf
            <!-- Modal Header -->
            <div class="modal-header bg-primary text-white">
                <div class="d-flex align-items-center">
                    <div class="p-2 border border-white border-opacity-25 bg-white bg-opacity-10 rounded-circle me-3">
                        <span class="avatar avatar-xs avatar-rounded bg-white text-primary">
                            <i class="bi bi-sticky"></i>
                        </span>
                    </div>
                    <div>
                        <h6 class="modal-title mb-0 fw-semibold">{{__('app.add_note')}}</h6>
                        <small class="opacity-75">{{__('app.add_note_description')}}</small>
                    </div>
                </div>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="{{__('app.close')}}"></button>
            </div>
            
            <!-- Modal Body -->
            <div class="modal-body p-4">
                
                <div class="row">
                    <div class="col-12">
                        <div class="form-group mb-4">
                            <label class="form-label fw-semibold">{{__('app.title')}} <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" placeholder="{{__('app.enter_note_title')}}" value="" name="title" required>
                            <div class="invalid-feedback">{{__('app.title_required')}}</div>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-12">
                        <div class="form-group">
                            <label class="form-label fw-semibold">{{__('app.detail')}} <span class="text-danger">*</span></label>
                            <textarea class="form-control" name="content" rows="7" placeholder="{{ __('app.enter_note_content') }}" required></textarea>
                            <div class="invalid-feedback">{{__('app.content_required')}}</div>
                            <div class="form-text">{{__('app.note_content_help')}}</div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Modal Footer -->
            <div class="modal-footer bg-light">
                <button type="button" class="btn btn-light" data-bs-dismiss="modal">
                    <i class="bi bi-x-circle me-1"></i>{{__('app.cancel')}}
                </button>
                <button type="submit" class="btn btn-primary btn-loading">
                    <i class="bi bi-check-circle me-1"></i>{{__('app.add')}}
                </button>
            </div>
        </form>
    </div>
</div>
