@extends('layouts.app')
@section('title', $page_title)

{{-- Include global DataTable styling --}}
@include('components.datatable-styles')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card custom-card">
            <div class="card-body">
                <!-- Page Header -->
                <div class="row mb-4">
                    <div class="col-12">
                        <div class="d-flex align-items-center justify-content-between">
                            <div class="d-flex align-items-center">
                                <div class="p-2 border border-primary border-opacity-10 bg-primary-transparent rounded-circle me-3">
                                    <span class="avatar avatar-xs avatar-rounded bg-primary svg-white">
                                        <i class="bi bi-sticky"></i>
                                    </span>
                                </div>
                                <div>
                                    <h6 class="mb-0 text-primary fw-semibold fs-14">{{ __('app.notes') }}</h6>
                                    <p class="mb-0 fs-12">{{ __('app.notes_description') }}</p>
                                </div>
                            </div>
                            <div>
                                <a href="javascript:;" class="btn btn-primary btn-loading" id="add-note-btn">
                                    <i class="bi bi-plus-circle me-2"></i>{{__('app.add_note')}}
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Notes List -->
                <div class="row">
                    @forelse($notes as $note)
                    <div class="col-md-6 col-lg-4 mb-4">
                        <div class="card custom-card h-100 border-0 shadow-sm">
                            <div class="card-body p-4 position-relative" style="background: linear-gradient(135deg, #FFF9C4 0%, #FFFDE7 100%);">
                                @if($note->is_pinned)
                                <div class="position-absolute top-0 end-0 p-2">
                                    <i class="bi bi-pin-fill text-warning fs-5"></i>
                                </div>
                                @endif
                                
                                <div class="d-flex justify-content-between align-items-start mb-3">
                                    <h6 class="card-title fw-bold mb-0">{{$note->title}}</h6>
                                    <small>{{\App\Http\Helper\Helper::datetimeDisplay($note->created_at)}}</small>
                                </div>
                                
                                <div class="note-content mb-3">
                                    <p class="mb-0" style="line-height: 1.5;">{{$note->content}}</p>
                                </div>
                                
                                <div class="d-flex gap-2 justify-content-end">
                                    <button class="btn btn-outline-info btn-sm" onclick="pinNote('{{route('note.pin', [$note->id])}}', '{{$note->title}}', 0)" style="{{$note->is_pinned ? '' : 'display:none'}}">
                                        <i class="bi bi-pin-angle me-1"></i>{{__('app.unpin')}}
                                    </button>
                                    <button class="btn btn-outline-secondary btn-sm" onclick="pinNote('{{route('note.pin', [$note->id])}}', '{{$note->title}}', 1)" style="{{$note->is_pinned ? 'display:none' : ''}}">
                                        <i class="bi bi-pin me-1"></i>{{__('app.pin_to_dashboard')}}
                                    </button>
                                    <a href="javascript:;" onclick="viewModal('modal', '{{route('notes.edit', [$note->id])}}');" class="btn btn-outline-primary btn-sm">
                                        <i class="bi bi-pencil me-1"></i>{{__('app.edit')}}
                                    </a>
                                    <button class="btn btn-outline-danger btn-sm" onclick="deleteNote('{{route('notes.destroy', [$note->id])}}', '{{__('app.note_delete_confirm_msg')}}')">
                                        <i class="bi bi-trash me-1"></i>{{__('app.delete')}}
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                    @empty
                    <div class="col-12">
                        <div class="text-center py-5">
                            <div class="mb-4">
                                <i class="bi bi-sticky" style="font-size: 4rem;"></i>
                            </div>
                            <h5 class="mb-2">{{__('app.no_notes_found')}}</h5>
                            <p class="mb-4">{{__('app.no_notes_found_description')}}</p>
                            <a href="javascript:;" class="btn btn-primary btn-loading" id="add-first-note-btn">
                                <i class="bi bi-plus-circle me-2"></i>{{__('app.create_first_note')}}
                            </a>
                        </div>
                    </div>
                    @endforelse
                </div>
            </div>
        </div>
    </div>
</div>
@include('includes.datatables')

@push('scripts')
<script>
$(function () {
    // Handle Add Note button click with loading indicator
    $('#add-note-btn').on('click', function(e) {
        e.preventDefault();
        var $btn = $(this);
        var $icon = $btn.find('i');
        $icon.removeClass('bi-plus-circle').addClass('spinner-border spinner-border-sm');
        $.ajax({
            url: '{{route('notes.create')}}', type: 'GET',
            success: function() {
                $icon.removeClass('spinner-border spinner-border-sm').addClass('bi-plus-circle');
                viewModal('modal', '{{route('notes.create')}}');
            },
            error: function(xhr) {
                $icon.removeClass('spinner-border spinner-border-sm').addClass('bi-plus-circle');
                if (xhr.status === 401) { alert('You do not have permission to create notes. Please contact your administrator.'); }
                else if (xhr.status === 403) { alert('Access forbidden. You do not have the required permissions.'); }
                else { alert('An error occurred while trying to access the create note page. Please try again.'); }
            }
        });
    });

    // Handle Add First Note button click with loading indicator
    $('#add-first-note-btn').on('click', function(e) {
        e.preventDefault();
        var $btn = $(this);
        var $icon = $btn.find('i');
        $icon.removeClass('bi-plus-circle').addClass('spinner-border spinner-border-sm');
        $.ajax({
            url: '{{route('notes.create')}}', type: 'GET',
            success: function() {
                $icon.removeClass('spinner-border spinner-border-sm').addClass('bi-plus-circle');
                viewModal('modal', '{{route('notes.create')}}');
            },
            error: function(xhr) {
                $icon.removeClass('spinner-border spinner-border-sm').addClass('bi-plus-circle');
                if (xhr.status === 401) { alert('You do not have permission to create notes. Please contact your administrator.'); }
                else if (xhr.status === 403) { alert('Access forbidden. You do not have the required permissions.'); }
                else { alert('An error occurred while trying to access the create note page. Please try again.'); }
            }
        });
    });
});
</script>
@endpush
@endsection
