@extends('layouts.app')
@section('title', $page_title)

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card custom-card">
            <div class="card-body">
                <form method="POST" action="{{ route('packages.store') }}" class="needs-validation" novalidate>
                    @csrf
                    
                    <!-- Basic Information Section -->
                    
                    <div class="row mb-3">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="form-label fw-semibold">{{__('app.name')}} <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" placeholder="{{__('app.enter_package_name')}}"
                                aria-label="{{__('app.name')}}" value="{{ old('name') }}" name="name" required>
                                <div class="invalid-feedback">{{__('app.name_required')}}</div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row mb-3">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="form-label fw-semibold">{{__('app.detail')}}</label>
                                <textarea class="form-control" placeholder="{{__('app.enter_package_description')}}" rows="3" name="description">{{ old('description') }}</textarea>
                            </div>
                        </div>
                    </div>

                    <!-- Limits Section -->
                    <div class="row mb-3">
                        <div class="col-12">
                            <div class="d-flex align-items-center">
                                <div class="me-3">
                                  <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                                        <i class="bi bi-graph-up"></i>
                                    </span>
                                </div>
                                <h6 class="mb-0 text-info fw-semibold fs-14">{{__('app.package_limits')}}</h6>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row mb-3 mt-3">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label fw-semibold">{{__('app.contact_limit')}}</label>
                                <small class="">({{__('app.minus_1_unlimited')}})</small>
                                <input type="number" class="form-control" name="no_of_contacts" value="{{ old('no_of_contacts') ?? -1 }}" min="-1">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label fw-semibold">{{__('app.sending_server_limit')}}</label>
                                <small class="">({{__('app.minus_1_unlimited')}})</small>
                                <input type="number" class="form-control" name="no_of_sending_servers" value="{{ old('no_of_sending_servers') ?? -1 }}">
                            </div>
                        </div>
                    </div>
                    <!-- Package Resources Section -->
                    <div class="row mb-3">
                        <div class="col-12">
                            <div class="d-flex align-items-center">
                                <div class="me-3">
                                  <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                                        <i class="bi bi-gear"></i>
                                    </span>
                                </div>
                                <h6 class="mb-0 text-info fw-semibold fs-14">{{__('app.package_resources')}}</h6>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row mb-3 mt-3">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="form-label fw-semibold">{{__('app.lists')}}
                                    <a tabindex="-1" role="button"
                                    data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.lists')}}"
                                    data-bs-content="{{__('app.packages_lists')}}" data-bs-custom-class="header-primary">
                                        <i class="bi bi-question-circle text-primary"></i>
                                    </a>
                                </label>
                                @include('includes.dropdown_lists', ['popup' => 0, 'multiple' => 1])
                            </div>
                        </div>
                    </div>
                    
                    <div class="row mb-3">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="form-label fw-semibold">{{__('app.delivery_servers')}}
                                    <a tabindex="-1" role="button"
                                    data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.delivery_servers')}}"
                                    data-bs-content="{{__('app.packages_delivery_servers')}}" data-bs-custom-class="header-primary">
                                        <i class="bi bi-question-circle text-primary"></i>
                                    </a>
                                </label>
                                @include('includes.dropdown_sending_server', ['popup' => 0, 'multiple' => 1])
                            </div>
                        </div>
                    </div>
                    
                    <div class="row mb-3">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="form-label fw-semibold">{{__('app.sending_domains')}}
                                    <a tabindex="-1" role="button"
                                    data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.sending_domains')}}"
                                    data-bs-content="{{__('app.packages_sending_domains')}}" data-bs-custom-class="header-primary">
                                        <i class="bi bi-question-circle text-primary"></i>
                                    </a>
                                </label>
                                @include('includes.dropdown_sending_domains', ['popup' => 0, 'multiple' => 1])
                            </div>
                        </div>
                    </div>

                    <!-- Action Buttons -->
                    <div class="row mt-4">
                        <div class="col-12">
                            <div class="d-flex gap-2">
                                <button type="submit" class="btn btn-primary btn-loading">
                                    <i class="bi bi-check-circle me-1"></i>{{__('app.create')}}
                                </button>
                                <a href="{{route('packages.index')}}" class="btn btn-light">
                                    <i class="bi bi-arrow-left me-1"></i>{{__('app.cancel')}}
                                </a>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
