@extends('layouts.app')
@section('title', $page_title)

@section('styles')
<link href="{{asset('assets/css/smart_wizard_all.min.css')}}" rel="stylesheet" >
<style>
  .page {
    display: flex;
    flex-direction: column;
    min-height: 100vh;
  }
  .main-content {
    flex: 1;
    display: flex;
    flex-direction: column;
  }
  .footer {
    margin-top: auto;
    width: 100%;
  }
  .app-content {
    flex: 1;
  }
  .card.custom-card {
    max-height: calc(100vh - 150px);
    overflow-y: auto;
  }
  .card.custom-card .card-body {
    max-height: calc(100vh - 200px);
    overflow-y: auto;
  }
</style>
@endsection

@push('scripts')
<script src="{{asset('assets/js/jquery.smartWizard.min.js')}}"></script>
<script src="{{asset('assets/js/pmta.js')}}"></script>
<script src="{{asset('assets/js/show-password.js')}}"></script>
<script type="text/javascript">
  $(document).ready(function() {
    $('#server_os').select2();
  });
</script>
@endpush

@section('content')
<div class="row">
  <div class="col-12">
<div class="card custom-card">
  <div class="card-body">       
        
      <!-- SmartWizard html -->
      <div id="smartwizard">
        <ul class="nav nav-progress">
          <li class="nav-item">
            <a class="nav-link" href="#step-1">
              <div class="num">1</div>
                <div class="step-title">{{__('app.pmta_server_settings')}}</div>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="#step-2">
              <span class="num">2</span>
                <div class="step-title">{{__('app.pmta_settings')}}</div>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="#step-3">
              <span class="num">3</span>
                <div class="step-title">{{__('app.pmta_ips_domains')}}</div>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="#step-4">
              <div class="num">4</div>
                <div class="step-title">{{__('app.pmta_ips_domains_mapping')}}</div>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="#step-5">
              <div class="num">5</div>
                <div class="step-title">{{__('app.pmta_bounces')}}</div>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="#step-6">
              <div class="num">6</div>
                <div class="step-title">{{__('app.pmta_dns_entries')}}</div>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="#step-7">
              <div class="num">7</div>
                <div class="step-title">{{__('app.pmta_review')}}</div>
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="#step-8">
              <div class="num">8</div>
                <div class="step-title">{{__('app.pmta_finish')}}</div>
            </a>
          </li>
        </ul>

        <form class="needs-validation" novalidate id="frm-pmta">
        <input type="hidden" class="form-control" name="pmta_id" value="{{ $id ?? null }}" >
        @csrf
        
        <div class="tab-content">
          <div id="step-1" class="tab-pane" role="tabpanel" aria-labelledby="step-1">
            <!-- Step Header -->
            
            <div class="alert alert-info mb-4 border-0 shadow-sm">
              <div class="d-flex justify-content-between align-items-start">
                  <div class="d-flex align-items-center">
                  <div class="p-2 bg-info bg-opacity-10 rounded-circle me-3">
                    <i class="bi bi-server text-info fs-5"></i>
                    </div>
                  <div>
                    <h6 class="mb-1 text-info fw-semibold">{{ __('app.server_management') }}</h6>
                    <p class="mb-0 text-muted small">{{ __('app.pmta_tab_server_settings_text') }}</p>
                  </div>
                </div>
                
                <div class="d-flex align-items-center gap-3">
                  <div id="action" class="text-end"></div>
            
              @if(!empty($pmta))
            @php $pmta_web_monitor_url = ($pmta->server_ip ?? '').':'.($pmta->management_port ?? '').'/ui' ; @endphp
                  <div class="btn-group">
                    <button type="button" class="btn btn-primary btn-sm dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                      <i class="bi bi-gear me-1"></i>{{__('app.actions')}}
                    </button>
                  <ul class="dropdown-menu dropdown-menu-end shadow">
                    <li><h6 class="dropdown-header">{{ __('app.server_operations') }}</h6></li>
                    <li><a class="dropdown-item" href="javascript:;" onclick="downloadPmtaSettings({{ !empty($id) ? $id : 1 }})">
                      <i class="bi bi-download me-2 text-primary"></i>{{ __('app.pmta_msg_download_config') }}
                    </a></li>
                    <li><hr class="dropdown-divider"></li>
                    <li><a href="javascript:;" class="server-operation dropdown-item" data-value="start" data-id='{{ !empty($id) ? $id : 1 }}'>
                      <i class="bi bi-play-circle me-2 text-success"></i>{{ __('app.pmta_server_start') }}
                    </a></li>
                    <li><a href="javascript:;" class="server-operation dropdown-item" data-value="restart" data-id='{{ !empty($id) ? $id : 1 }}'>
                      <i class="bi bi-recycle me-2 text-warning"></i>{{ __('app.pmta_server_restart') }}
                    </a></li>
                    <li><a href="javascript:;" class="server-operation dropdown-item" data-value="stop" data-id='{{ !empty($id) ? $id : 1 }}'>
                      <i class="bi bi-stop-circle me-2 text-danger"></i>{{ __('app.pmta_server_stop') }}
                    </a></li>
                    <li><hr class="dropdown-divider"></li>
                    <li><a href="javascript:;" class="server-operation dropdown-item" data-value="pmta-reset-counters" data-id='{{ !empty($id) ? $id : 1 }}'>
                      <i class="bi bi-bootstrap-reboot me-2 text-info"></i>{{ __('app.pmta_server_reset_counters') }}
                    </a></li>
                    <li><a href="javascript:;" class="server-operation dropdown-item" data-value="pmta-flush-queue" data-id='{{ !empty($id) ? $id : 1 }}'>
                      <i class="bi bi-trash me-2 text-warning"></i>{{ __('app.pmta_server_flush_queue') }}
                    </a></li>
                    <li><a class="dropdown-item" href="//{{$pmta_web_monitor_url}}" target="_blank">
                      <i class="bi bi-globe me-2 text-primary"></i>{{ __('app.pmta_server_web_monitor') }}
                    </a></li>
                    <li><hr class="dropdown-divider"></li>
                    <li><a href="javascript:;" class="server-operation dropdown-item text-danger" data-value="pmta-reset" data-id='{{ !empty($id) ? $id : 1 }}'>
                      <i class="bi bi-bootstrap-reboot me-2"></i>{{ __('app.pmta_server_reset') }}
                    </a></li>
                    </ul>
                  </div>
                  @endif
                </div>
              </div>
            </div>
            
            <div class="row">
              <div class="col-md-6">
                <div class="form-group">
                  <label class="form-label fw-semibold">{{__('app.pmta_server_name')}}</label>
                  <input type="text" class="form-control" placeholder="{{__('app.pmta_server_name')}}" name="server_name" value="{{ !empty($pmta->server_name) ? $pmta->server_name : '' }}" required>
                  <div class="invalid-feedback">{{__('app.server_name_required')}}</div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group">
                  <label class="form-label fw-semibold">{{__('app.pmta_version')}}</label>
                <select name="version" class="form-select form-select-lg">
                  <option value="5.0" {{ !empty($pmta->version) && $pmta->version == '5.0' ? 'selected' : '' }}>5.0</option>
                </select>
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group">
                  <label class="form-label fw-semibold">{{__('app.pmta_server_os')}}</label>
                <select name="server_os" class="form-select form-select-lg">
                  <option value="centos10.x" {{ !empty($pmta->server_os) && $pmta->server_os == 'centos8.x' ? 'selected' : '' }}>CentOS 10</option>
                  <option value="centos9.x" {{ !empty($pmta->server_os) && $pmta->server_os == 'centos8.x' ? 'selected' : '' }}>CentOS 9</option>
                  <option value="centos8.x" {{ !empty($pmta->server_os) && $pmta->server_os == 'centos8.x' ? 'selected' : '' }}>CentOS 8</option>
                  <option value="centos8.x" {{ !empty($pmta->server_os) && $pmta->server_os == 'almalinux9.x' ? 'selected' : '' }}>AlmaLinux 9</option>
                  <option value="ubuntu24.04" {{ !empty($pmta->server_os) && $pmta->server_os == 'ubuntu24.04' ? 'selected' : '' }}>Ubuntu 24.04</option>
                  <option value="ubuntu22.04" {{ !empty($pmta->server_os) && $pmta->server_os == 'ubuntu22.04' ? 'selected' : '' }}>Ubuntu 22.04</option>
                  <option value="ubuntu20.04" {{ !empty($pmta->server_os) && $pmta->server_os == 'ubuntu20.04' ? 'selected' : '' }}>Ubuntu 20.04</option>
                </select>
              </div> 
            </div>
            </div>
            <div class="row mt-3">           
              <div class="col-md-6">
                <div class="form-group">
                  <label class="form-label fw-semibold">{{__('app.pmta_server_ip')}}</label>
                <input type="text" class="form-control" placeholder="{{__('app.pmta_server_ip')}}" id="server-ip" name="server_ip" value="{{ !empty($pmta->server_ip) ? $pmta->server_ip : '' }}" required>
                  <div class="invalid-feedback">{{__('app.server_ip_required')}}</div>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label class="form-label fw-semibold">{{__('app.pmta_server_port')}}</label>
                <input type="number" class="form-control" placeholder="{{__('app.pmta_server_port')}}" id="server-port" name="server_port" value="{{ !empty($pmta->server_port) ? $pmta->server_port : '22' }}" min="0" required>
                  <div class="invalid-feedback">{{__('app.server_port_required')}}</div>
                </div>
              </div>
            </div>
            <div class="row mt-3">         
              <div class="col-md-6">
                <div class="form-group">
                  <label class="form-label fw-semibold">{{__('app.pmta_server_username')}}</label>
                <input type="text" class="form-control" placeholder="{{__('app.pmta_server_username')}}" id="server-username" name="server_username" value="{{ !empty($pmta->server_username) ? $pmta->server_username : 'root' }}" required>
                  <div class="invalid-feedback">{{__('app.server_username_required')}}</div>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <div class="position-relative">
                    <label class="form-label fw-semibold">{{__('app.pmta_server_password')}}</label>
                <input type="password" class="form-control" placeholder="{{__('app.pmta_server_password')}}" id="server-password" name="server_password" required>
                    <a tabindex="-1" href="javascript:void(0);" class="show-password-button " onclick="createpassword('server-password',this)" id="button-addon2">
                      <i class="ri-eye-off-line align-middle text-primary"></i>
                    </a>
                    <div class="invalid-feedback">{{__('app.server_password_required')}}</div>
                  </div>
                </div>
              </div>
            </div>
            <div class="row mt-3">
              <div class="col-md-12">
                <div class="d-flex gap-2">
                  <button type="button" class="btn btn-success btn-loading" id="validate">
                    <i class=""></i>{{ __('app.validate') }}
                  </button>
                  <span id="server-msg" class="align-self-center"></span>
                </div>
              </div>
            </div>
          </div>

          <div id="step-2" class="tab-pane" role="tabpanel" aria-labelledby="step-2">
            
            <div class="alert alert-info mb-4">
              <i class="bi bi-info-circle me-2"></i>{{__('app.pmta_smtp_settings_text')}}
            </div>
            
            <div class="row mb-3">
              <div class="col-12">
                <div class="d-flex align-items-center">
                  <div class="p-2 border border-primary border-opacity-10 bg-primary-transparent rounded-circle me-3">
                    <span class="avatar avatar-xs avatar-rounded bg-primary svg-white">
                      <i class="bi bi-envelope"></i>
                    </span>
                  </div>
                  <h6 class="mb-0 text-primary fw-semibold fs-14">{{__('app.smtp_settings')}}</h6>
                </div>
              </div>
            </div>
            <div class="row">
              <div class="col-md-6">
                <div class="form-group">
                  <label class="form-label fw-semibold">{{__('app.pmta_smtp_host')}}</label>
                <input type="text" class="form-control" placeholder="{{__('app.pmta_smtp_host')}}" name="smtp_host" value="{{ !empty($pmta->smtp_host) ? $pmta->smtp_host : 'smtp' }}" required>
                  <div class="invalid-feedback">{{__('app.smtp_host_required')}}</div>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label class="form-label fw-semibold">{{__('app.pmta_smtp_port')}}</label>
                <input type="text" class="form-control" placeholder="{{__('app.pmta_smtp_port')}}" name="smtp_port" value="{{ !empty($pmta->smtp_port) ? $pmta->smtp_port : '25' }}" required>
                  <div class="invalid-feedback">{{__('app.smtp_port_required')}}</div>
                </div>
              </div>
            </div>
            <div class="row mt-3"> 
              <div class="col-md-6">
                <div class="form-group">
                  <label class="form-label fw-semibold">{{__('app.pmta_smtp_encryption')}}</label>
                <select name="smtp_encryption" class="form-select form-select-lg">
                  <option value="none"  {{ !empty($pmta->smtp_encryption) && $pmta->smtp_encryption == 'none' ? 'selected' : '' }}>{{ __('app.none') }}</option>
                  <option value="tls"  {{ !empty($pmta->smtp_encryption) && $pmta->smtp_encryption == 'tls' ? 'selected' : '' }}>TLS</option>
                </select>
              </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label class="form-label fw-semibold">{{__('app.pmta_smtp_body_encoding')}}</label>
                <select name="body_encoding" class="form-select form-select-lg">
                  <option value="quoted-printable" {{ !empty($pmta->body_encoding) && $pmta->body_encoding == 'quoted-printable' ? 'selected="selected"' : '' }}>quoted-printable</option>
                  <option value="base64" {{ !empty($pmta->body_encoding) && $pmta->body_encoding == 'base64' ? 'selected="selected"' : '' }}>base64</option>
                  <option value="7-bit" {{ !empty($pmta->body_encoding) && $pmta->body_encoding == '7-bit' ? 'selected="selected"' : '' }}>7-bit</option>
                </select>
              </div>
            </div>
            </div>
            <div class="row mb-3 mt-4">
              <div class="col-12">
                <div class="d-flex align-items-center">
                  <div class="p-2 border border-warning border-opacity-10 bg-warning-transparent rounded-circle me-3">
                    <span class="avatar avatar-xs avatar-rounded bg-warning svg-white">
                      <i class="bi bi-gear-fill"></i>
                    </span>
                  </div>
                  <h6 class="mb-0 text-warning fw-semibold fs-14">{{__('app.pmta_settings')}}</h6>
                </div>
              </div>
            </div>
            
            <div class="row"> 
              <div class="col-md-6">
                <div class="form-group">
                  <label class="form-label fw-semibold">{{__('app.pmta_management_port')}}</label>
                <input type="number" class="form-control" name="management_port" value="{{ !empty($pmta->management_port) ? $pmta->management_port : '' }}" placeholder="8080" required min="0">
                  <div class="invalid-feedback">{{__('app.management_port_required')}}</div>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label class="form-label fw-semibold">{{__('app.pmta_admin_ips')}} 
                <a tabindex="-1" role="button"
                data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.pmta_admin_ips')}}"
                      data-bs-content="{{__('app.pmta_admin_ips_help')}}" data-bs-custom-class="header-primary">
                      <i class="bi bi-question-circle text-primary"></i>
                    </a>
                  </label>
                <input type="text" class="form-control" name="admin_ips" value="{{ !empty($pmta->admin_ips) ? $pmta->admin_ips : $_SERVER['SERVER_ADDR'] }}" placeholder="" required>
                  <div class="invalid-feedback">{{__('app.admin_ips_required')}}</div>
                </div>
              </div>              
            </div>
            <div class="row mt-3"> 
              <div class="col-md-6">
                <div class="form-group">
                  <label class="form-label fw-semibold">{{__('app.pmta_path')}}</label>
                  <input type="text" class="form-control" placeholder="{{__('app.pmta_path')}}" name="path" value="{{ !empty($pmta->path) ? $pmta->path : '/etc/pmta' }}" required>
                  <div class="invalid-feedback">{{__('app.pmta_path_required')}}</div>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label class="form-label fw-semibold">{{__('app.pmta_log_file_path')}}</label>
                <input type="text" class="form-control" name="log_file_path" value="{{ !empty($pmta->log_file_path) ? $pmta->log_file_path : '/var/log/pmta/pmta.log' }}" placeholder="/var/log/pmta/pmta.log" required>
                  <div class="invalid-feedback">{{__('app.log_file_path_required')}}</div>
                </div>
              </div>
            </div>            
            <div class="row mt-3"> 
              <div class="col-md-6">
                <div class="form-group">
                  <label class="form-label fw-semibold">{{__('app.pmta_acct_file_path')}}</label>
                <input type="text" class="form-control" name="acct_file_path" value="{{ !empty($pmta->acct_file_path) ? $pmta->acct_file_path : '/etc/pmta/files/acct/acct.csv' }}" placeholder="/etc/pmta/files/acct/acct.csv" required>
                  <div class="invalid-feedback">{{__('app.acct_file_path_required')}}</div>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label class="form-label fw-semibold">{{__('app.diag_file_path')}}</label>
                <input type="text" class="form-control" name="diag_file_path" value="{{ !empty($pmta->diag_file_path) ? $pmta->diag_file_path : '/etc/pmta/files/diag/diag.csv' }}" placeholder="/etc/pmta/files/diag/diag.csv" required>
                  <div class="invalid-feedback">{{__('app.diag_file_path_required')}}</div>
                </div>
              </div>
            </div>
            <div class="row mt-3"> 
              <div class="col-md-6">
                <div class="form-group">
                  <label class="form-label fw-semibold">{{__('app.pmta_spool_path')}}</label>
                <input type="text" class="form-control" name="spool_path" value="{{ !empty($pmta->spool_path) ? $pmta->spool_path : '/var/spool/pmta' }}" placeholder="/var/spool/pmta" required>
                  <div class="invalid-feedback">{{__('app.spool_path_required')}}</div>
                </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label class="form-label fw-semibold">{{__('app.pmta_dkim_path')}}</label>
                <input type="text" class="form-control" name="dkim_path" value="{{ !empty($pmta->dkim_path) ? $pmta->dkim_path : '/etc/pmta/dkim' }}" placeholder="/etc/pmta/dkim" required>
                  <div class="invalid-feedback">{{__('app.dkim_path_required')}}</div>
                </div>
              </div>
            </div>
            <div class="row mt-3"> 
              <div class="col-md-6">
                <div class="form-group">
                  <label class="form-label fw-semibold">{{__('app.pmta_dmarc_selector')}}</label>
                <select name="dmarc_policy" class="form-select form-select-lg">
                  <option value="none"  {{ !empty($pmta->dmarc_policy) && $pmta->dmarc_policy == 'none' ? 'selected' : '' }}>{{ __('app.none') }} </option>
                  <option value="quarantine"  {{ !empty($pmta->dmarc_policy) && $pmta->dmarc_policy == 'quarantine' ? 'selected' : '' }}>{{ __('app.quarantine') }} </option>
                  <option value="reject"  {{ !empty($pmta->dmarc_policy) && $pmta->dmarc_policy == 'reject' ? 'selected' : '' }}>{{ __('app.reject') }} </option>
                </select>
              </div>
              </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label class="form-label fw-semibold">{{__('app.pmta_dmarc_policy')}}</label>
                <input type="text" class="form-control" name="dmarc_selector" value="{{ !empty($pmta->dmarc_selector) ? $pmta->dmarc_selector : '_dmarc' }}" placeholder="">
                </div>
              </div>
            </div>
            <div class="row mt-3"> 
              <div class="col-md-6">
                <div class="form-group">
                  <label class="form-label fw-semibold">{{__('app.pmta_vmta_prefix')}}</label>
                <input type="text" class="form-control" name="vmta_prefix" value="{{ !empty($pmta->vmta_prefix) ? $pmta->vmta_prefix : 'vmta' }}" placeholder="">
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group">
                  <label class="form-label fw-semibold">{{__('app.pmta_dkim_selector')}}</label>
                <input type="text" class="form-control" name="dkim_selector" value="{{ !empty($pmta->dkim_selector) ? $pmta->dkim_selector : 'dkim' }}" placeholder="">
                </div>
              </div>
              <div class="col-md-3">
                <div class="form-group">
                  <label class="form-label fw-semibold">{{__('app.pmta_tracking_selector')}}</label>
                <input type="text" class="form-control" name="tracking_selector" value="{{ !empty($pmta->tracking_selector) ? $pmta->tracking_selector : 'track'}}" placeholder="">
                </div>
              </div>
            </div>
          </div>

          <div id="step-3" class="tab-pane" role="tabpanel" aria-labelledby="step-3">
            <!-- Step Header -->
            <div class="row mb-4">
              <div class="col-12">
                <div class="d-flex align-items-center justify-content-between">
                  <div class="d-flex align-items-center">
                    <div class="me-3">
                      <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                        <i class="bi bi-globe"></i>
                      </span>
                    </div>
                    <h6 class="mb-0 text-info fw-semibold fs-14">{{__('app.pmta_ips_domains')}}</h6>
                  </div>
            <a tabindex="-1" role="button"
                    data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="left" title="{{__('app.pmta_ips_domains')}}"
                    data-bs-content="{{__('app.pmta_ips_domains_help')}}" data-bs-custom-class="header-primary">
                    <i class="bi bi-question-circle text-primary fs-5"></i>
                  </a>
                </div>
              </div>
            </div>
            
            <div class="alert alert-info mb-4">
              <i class="bi bi-info-circle me-2"></i>{{ __('app.pmta_ips_domains_text') }}
            </div>
            
            <div class="row">
              <div class="col-md-6">
                <div class="form-group">
                  <label class="form-label fw-semibold">{{__('app.pmta_domains')}}
              <a tabindex="-1" role="button"
                data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.pmta_domains')}}"
                      data-bs-content="{{__('app.pmta_domains_help')}}" data-bs-custom-class="header-primary">
                      <i class="bi bi-question-circle text-primary"></i>
                </a>
              </label>
                  <textarea class="form-control" name="domains" id="domains" rows="7" required placeholder="{{__('app.pmta_domains_placeholder')}}">{{ !empty($pmta->domains) ? $pmta->domains : '' }}</textarea>
                  <div class="invalid-feedback">{{__('app.domains_required')}}</div>
                </div>
            </div>
              <div class="col-md-6">
                <div class="form-group">
                  <label class="form-label fw-semibold">{{__('app.pmta_ips')}}
              <a tabindex="-1" role="button"
                data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.pmta_ips')}}"
                      data-bs-content="{{__('app.pmta_ips_help')}}" data-bs-custom-class="header-primary">
                      <i class="bi bi-question-circle text-primary"></i>
                </a>
              </label>
                  <textarea class="form-control" name="ips" id="ips" rows="7" required placeholder="{{__('app.pmta_ips_placeholder')}}">{{ !empty($pmta->ips) ? $pmta->ips : '' }}</textarea>
                  <div class="invalid-feedback">{{__('app.ips_required')}}</div>
                </div>
              </div>
            </div>

          </div>

          <div id="step-4" class="tab-pane" role="tabpanel" aria-labelledby="step-4">
            <div id="mapping-ips-domains"></div>
          </div>

          <div id="step-5" class="tab-pane" role="tabpanel" aria-labelledby="step-5">
            <h6>{{ __('app.pmta_tab_bounces') }}</h6>
            <div>{{ __('app.pmta_tab_bounces_text') }}</div><br>
            <div id="bounces-data"></div>
          </div>

          <div id="step-6" class="tab-pane" role="tabpanel" aria-labelledby="step-6">
            <h6>{{ __('app.pmta_tab_dns_entries') }}</h6>
            <div>{{ __('app.pmta_tab_dns_entries_text') }}</div><br>
            <div id="authentication-data"></div>
          </div>

          <div id="step-7" class="tab-pane" role="tabpanel" aria-labelledby="step-7">
            <h6>{{ __('app.pmta_tab_review') }}</h6>
            <div>{{ __('app.pmta_tab_review_text') }}</div><br>
            <h6 class="text-danger">{{ __('app.pmta_finish_notice') }}</h6>
            <div><textarea id="review-data" readonly='readonly' style='width:100%;height:500px;border:none;overflow: auto;'></textarea></div>
          </div>

          <div id="step-8" class="tab-pane" role="tabpanel" aria-labelledby="step-8">
            <h6>{{ __('app.pmta_tab_finish') }}</h6>
            <h6 class="text-danger"><i><strong>{{__('app.note')}}:</strong> {{ __('app.pmta_tab_finish_text') }}</i></h6>
            <div id="finish-data" class="mt-3"></div>
          </div>

        </div>
        </form>
      </div>
    </div>
  </div>
</div>
@endsection
