@extends('layouts.app')
@section('title', $page_title)

{{-- Include global DataTable styling --}}
@include('components.datatable-styles')

@push('scripts')
<script>
$(function () {
    'use strict';
    var table = $('#data').DataTable({
        "columnDefs": [{"sortable": false, "targets": [3]}],
        "order": [[ 2, "desc" ]],
        "lengthMenu": [[50, 100, 200], [50, 100, 200]],
        "ajax": $('#route-get-pmtas').data('route'),
    });
    table.on('draw', function() {
        $('#data_paginate a').addClass('btn btn-primary me-1');
        $('#data_paginate .paginate_button.current').addClass('btn-light').removeClass('btn-primary');
    });

    // Handle Add PMTA button click with error handling
    $('#add-pmta-btn').on('click', function(e) {
        e.preventDefault();
        var href = $(this).attr('href');
        var $btn = $(this);
        var $icon = $btn.find('i');
        $icon.removeClass('bi-plus-circle').addClass('spinner-border spinner-border-sm');
        $.ajax({
            url: href, type: 'GET',
            success: function() { window.location.href = href; },
            error: function(xhr) {
                $icon.removeClass('spinner-border spinner-border-sm').addClass('bi-plus-circle');
                if (xhr.status === 401) { alert('You do not have permission to create PMTA configurations. Please contact your administrator.'); }
                else if (xhr.status === 403) { alert('Access forbidden. You do not have the required permissions.'); }
                else { alert('An error occurred while trying to access the create PMTA page. Please try again.'); }
            }
        });
    });
});
</script>
@endpush
@section('content')
<div class="row">
    <div class="col-xl-12">
        <div class="card custom-card">
            <div class="card-body">
                <div class="table-responsive">
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <a href="{{route('pmta.create.edit')}}" class="btn btn-primary btn-loading" id="add-pmta-btn"><i class="bi bi-plus-circle me-2"></i>{{__('app.add_new_pmta')}}</a>
                        </div>
                    </div>
                    <table id="data" class="table table-bordered text-nowrap w-100">
                        <thead>
                            <tr>
                                <th>{{ __('app.name') }}</th>
                                <th>{{ __('app.type') }}</th>
                                <th>{{ __('app.created') }}</th>
                                <th>{{ __('app.actions') }}</th>
                            </tr>
                        </thead>
                         <tbody></tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<span id="route-get-pmtas" data-route="{{ route('get.pmtas') }}"></span>
@include('includes.datatables')
@endsection
