@extends('layouts.app')
@section('title', $page_title)

@push('scripts')
<script src="{{asset('assets/js/show-password.js')}}"></script>
<script type="text/javascript">
  $(document).ready(function() {
    // Initialize Select2 for group dropdown
    $('#group_id').select2({
      placeholder: '{{__("app.select_group")}}',
      allowClear: false,
      width: '100%',
      dropdownParent: $('body')
    });
  });
</script>
@endpush

@section('styles')
<style type="text/css">
  /* Group dropdown styling */
  .select2-container { z-index: 1040 !important; }
  .select2-dropdown { max-height: 300px; overflow-y: auto; z-index: 1040 !important; position: absolute !important; }
  .select2-results__options { max-height: 250px; overflow-y: auto; }
  .select2-results__option { padding: 8px 12px; font-size: 14px; }
  .select2-results__option--highlighted { background-color: #007bff; color: white; }
  .select2-container--default .select2-results > .select2-results__options { max-height: 250px; overflow-y: auto; }
  .select2-dropdown--below { z-index: 1040 !important; }
  .form-group { overflow: visible !important; }
</style>
@endsection

@section('content')
<div class="row">
  <div class="col-12">
    <div class="card custom-card">
      <div class="card-body">
        <form method="POST" action="{{ route('reply_servers.update', $reply_server->id) }}" class="needs-validation" novalidate>
          @csrf
          @method('PUT')
          
          <!-- General Information Section -->
          <div class="row mb-3">
            
            <div class="col-md-4">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{__('app.group')}}
                  <a href="javascript:;" onclick="viewModal('modal', '{{route('group.create', ['type_id' => config('custom.group_reply_server')])}}');" class="text-primary ms-1">
                    <i class="bi bi-plus-circle"></i>
                  </a>
                </label>
                <select name="group_id" class="form-select" id="group_id" required>
                  <option value="">{{__('app.select_group')}}</option>
                  @foreach($groups as $id => $group_name)
                    <option value="{{ $id }}" {{ ($id == $reply_server->group_id) ? 'selected' : '' }}>{{ $group_name }}</option>
                  @endforeach
                </select>
                <div class="invalid-feedback">{{ __('app.select_group_error')}}</div>
              </div>
            </div>
            
            <div class="col-md-4">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{__('app.email')}}</label>
                <input type="email" class="form-control" placeholder="{{__('app.email')}}" value="{{ $reply_server->email }}" name="email" required>
                <div class="invalid-feedback">{{__('app.email_required')}}</div>
              </div>
            </div>
            
            <div class="col-md-4">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{__('app.status')}}</label>
                <select name="is_active" class="form-select form-select-lg">
                  <option value="1" {{ $reply_server->is_active ? 'selected' : '' }}>{{ __('app.active')}}</option>
                  <option value="0" {{ $reply_server->is_active ? '' : 'selected' }}>{{ __('app.in_active') }}</option>
                </select>
              </div>
            </div>
          </div>

          <!-- Server Configuration Section -->
          <div class="row mb-3">
            <div class="col-12">
              <div class="d-flex align-items-center">
                <div class="me-3">
                  <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                    <i class="bi bi-server"></i>
                  </span>
                </div>
                <h6 class="mb-0 text-info fw-semibold fs-14">{{__('app.server_configuration')}}</h6>
              </div>
            </div>
            
            <div class="col-md-6">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{__('app.method')}}</label>
                <select name="method" class="form-select">
                  <option value="imap" {{ $reply_server->method == 'imap' ? 'selected' : '' }}>IMAP</option>
                  <option value="pop3" {{ $reply_server->method == 'pop3' ? 'selected' : '' }}>POP3</option>
                </select>
              </div>
            </div>
            
            <div class="col-md-6">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{__('app.host')}}</label>
                <input type="text" class="form-control" placeholder="{{__('app.host')}}" value="{{ $reply_server->host }}" name="host" required>
                <div class="invalid-feedback">{{__('app.host_required')}}</div>
              </div>
            </div>
            
            <div class="col-md-6">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{__('app.port')}}</label>
                <input type="number" class="form-control" placeholder="{{__('app.port')}}" value="{{ $reply_server->port }}" name="port" required min="0">
                <div class="invalid-feedback">{{__('app.port_required')}}</div>
              </div>
            </div>
            
            <div class="col-md-6">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{__('app.encryption')}}</label>
                <select name="encryption" class="form-select form-select-lg">
                  <option value="none" {{ $reply_server->encryption == 'none' ? 'selected' : '' }}>None</option>
                  <option value="ssl" {{ $reply_server->encryption == 'ssl' ? 'selected' : '' }}>SSL</option>
                  <option value="tls" {{ $reply_server->encryption == 'tls' ? 'selected' : '' }}>TLS</option>
                </select>
              </div>
            </div>
          </div>

          <!-- Authentication Section -->
          <div class="row mb-3">
            <div class="col-12">
              <div class="d-flex align-items-center">
                <div class="me-3">
                  <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                    <i class="bi bi-shield-lock"></i>
                  </span>
                </div>
                <h6 class="mb-0 text-info fw-semibold fs-14">{{__('app.authentication')}}</h6>
              </div>
            </div>
            
            <div class="col-md-6">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{__('app.username')}}</label>
                <input type="text" class="form-control" placeholder="{{__('app.username')}}" value="{{ $reply_server->username }}" name="username" required>
                <div class="invalid-feedback">{{__('app.username_required')}}</div>
              </div>
            </div>
            
            <div class="col-md-6">
              <div class="form-group">
                <div class="position-relative">
                  <label class="form-label fw-semibold mt-2">{{__('app.password')}}</label>
                  <input id="password" type="password" class="form-control" placeholder="{{__('app.password')}}" name="password" value="{{Crypt::decrypt($reply_server->password)}}">
                  <a href="javascript:void(0);" class="show-password-button " onclick="createpassword('password',this)" id="button-addon2">
                    <i class="ri-eye-off-line align-middle text-primary"></i>
                  </a>
                </div>
                <div class="invalid-feedback">{{__('app.password_required')}}</div>
              </div>
            </div>
          </div>

          <!-- Advanced Settings Section -->
          <div class="row mb-3">
            <div class="col-12">
              <div class="d-flex align-items-center">
                <div class="me-3">
                  <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                    <i class="bi bi-gear"></i>
                  </span>
                </div>
                <h6 class="mb-0 text-info fw-semibold fs-14">{{__('app.advanced_settings')}}</h6>
              </div>
            </div>
            
            <div class="col-md-6">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{__('app.validate_cert')}}</label>
                <select name="validate_cert" class="form-select">
                  <option value="Yes" {{ $reply_server->validate_cert == 'Yes' ? 'selected' : '' }}>{{ __('app.yes') }}</option>
                  <option value="No" {{ $reply_server->validate_cert == 'No' ? 'selected' : '' }}>{{ __('app.no') }}</option>
                </select>
              </div>
            </div>
            
            <div class="col-md-6">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{__('app.delete_after_processing')}}
                  <a tabindex="-1" role="button" data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" 
                     title="{{__('app.delete_after_processing')}}" data-bs-content="{{__('app.delete_after_processing_help')}}" 
                     data-bs-custom-class="header-primary" class="text-primary ms-1">
                    <i class="bi bi-question-circle"></i>
                  </a>
                </label>
                <select name="delete_after_processing" class="form-select">
                  <option value="No" {{ $reply_server->delete_after_processing == 'No' ? 'selected' : '' }}>{{ __('app.no') }}</option>
                  <option value="Yes" {{ $reply_server->delete_after_processing == 'Yes' ? 'selected' : '' }}>{{ __('app.yes') }}</option>
                </select>
              </div>
            </div>
          </div>

          <!-- Action Buttons -->
          <div class="row">
            <div class="col-12">
              <div class="d-flex gap-2 justify-content-start">
                <input type="hidden" name="id" value="{{$reply_server->id}}">
                <button type="submit" class="btn btn-primary">
                  <i class="bi bi-save me-1"></i>{{__('app.update')}}
                </button>
                <button type="button" id="validate-imap" onclick="validateImap(this.form, '{{route('validateReplyServerImap')}}')" class="btn btn-info">
                  <i class="bi bi-check-circle me-1"></i>{{__('app.validate')}}
                </button>
                <a href="{{route('reply_servers.index')}}" class="btn btn-light">
                  <i class="bi bi-arrow-left me-1"></i>{{__('app.cancel')}}
                </a>
                <span id="imap-msg" class="mx-3"></span>
              </div>
            </div>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>
@include('includes.modal')
@endsection
