@extends('layouts.app')
@section('title', $page_title)

@section('styles')
<style>
.permission-card {
    height: 100%;
    min-height: 150px;
}
.permission-card .card-body {
    height: calc(100% - 60px);
    overflow-y: auto;
}
</style>
@endsection

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card custom-card">
            <div class="card-body">

                <form method="POST" action="{{ route('roles.store') }}" class="needs-validation" novalidate>
                    @csrf
                    
                    
                    <div class="row mb-4">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label fw-semibold">{{__('app.role_name')}} <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" placeholder="{{__('app.enter_role_name')}}"
                                aria-label="{{__('app.role_name')}}" value="" name="name" required>
                                <div class="invalid-feedback">{{__('app.role_name_required')}}</div>
                            </div>
                        </div>
                    </div>

                    <!-- Permissions Section -->
                    <div class="row mb-4">
                        <div class="col-12">
                            <div class="d-flex align-items-center justify-content-between mb-3">
                                <div class="d-flex align-items-center">
                                    <div class="me-3">
                                      <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                                            <i class="bi bi-key"></i>
                                        </span>
                                    </div>
                                    <h6 class="mb-0 text-info fw-semibold fs-14">{{ __('app.permissions') }}</h6>
                                </div>
                                <div class="form-check">
                                    <input type="checkbox" id="checkAll" class="form-check-input" value="Select All">
                                    <label class="form-check-label fw-semibold" for="checkAll">{{ __('app.select_all') }}</label>
                                </div>
                            </div>
                            <div class="alert alert-info">
                                <i class="bi bi-info-circle me-2"></i>{{ __('app.permissions_help_text') }}
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        @foreach($permissions as $modules)
                        @foreach($modules['modules'] as $module)
                        <div class="col-md-4 mb-3">
                            <div class="card border border-info border-opacity-10 permission-card">
                                <div class="card-header bg-primary-transparent">
                                    <div class="form-check">
                                        <input class="form-check-input select-all" type="checkbox" value="{{ \Illuminate\Support\Str::slug($module['title']) }}" id="module-{{ \Illuminate\Support\Str::slug($module['title']) }}">
                                        <label class="form-check-label fw-semibold text-primary" for="module-{{ \Illuminate\Support\Str::slug($module['title']) }}">
                                            {{ $module['title'] }}
                                        </label>
                                    </div>
                                </div>
                                <div class="card-body">
                                    @foreach($module['permissions'] as $key => $permission)
                                    <div class="form-check mb-2">
                                        <input type="checkbox" name="roles_permissions[]" class="{{ \Illuminate\Support\Str::slug($module['title']) }} form-check-input" value="{{ $key }}" id="permission-{{ $key }}">
                                        <label class="form-check-label" for="permission-{{ $key }}">
                                            {{ $permission }}
                                        </label>
                                    </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                        @endforeach            
                        @endforeach
                    </div>
                    <!-- Action Buttons -->
                    <div class="row mt-4">
                        <div class="col-12">
                            <div class="d-flex gap-2">
                                <button type="submit" class="btn btn-primary btn-loading">
                                    <i class="bi bi-check-circle me-1"></i>{{ __('app.create_role') }}
                                </button>
                                <a href="{{ route('roles.index', ['t' => request('t')]) }}" class="btn btn-outline-secondary">
                                    {{ __('app.cancel') }}
                                </a>
                            </div>
                        </div>
                    </div>
                    
                    <input type="hidden" value="{{ request('t') }}" name="type">
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
