@extends('layouts.app')
@section('title', $page_title)

{{-- Include global DataTable styling --}}
@include('components.datatable-styles')

@push('scripts')
<script>
$(function () {
    'use strict';
    var table = $('#data').DataTable({
        "columnDefs": [{"sortable": false, "targets": [0, 3, 5]}],
        "order": [[ 1, "desc" ]],
        "lengthMenu": [[50, 100, 200], [50, 100, 200]],
        "ajax": {
            "url" : $('#route-roles').data('route'),
            "data": {t:$('#role-type').data('roletype')}
        }

    });
    table.on('draw', function() {
        $('#data_paginate a').addClass('btn btn-primary me-1');
        $('#data_paginate .paginate_button.current').addClass('btn-light').removeClass('btn-primary');
    });

    const multipleDefault = new Choices(document.getElementById('list_id'), {
        allowHTML: true
    });

    // Ensure button starts with correct icon
    $('#add-role-btn i').removeClass('bi-plus-circle spinner-border spinner-border-sm').addClass('bi-plus-circle');

    // Handle Add Role button click with error handling
    $('#add-role-btn').on('click', function(e) {
        e.preventDefault();
        var href = $(this).attr('href');
        var $btn = $(this);
        var $icon = $btn.find('i');
        $icon.removeClass('bi-plus-circle spinner-border spinner-border-sm').addClass('spinner-border spinner-border-sm');
        
        // Add timeout to reset spinner if request takes too long
        var timeout = setTimeout(function() {
            $icon.removeClass('bi-plus-circle spinner-border spinner-border-sm').addClass('bi-plus-circle');
        }, 10000); // 10 second timeout
        
        $.ajax({
            url: href, type: 'GET',
            success: function() { 
                clearTimeout(timeout);
                window.location.href = href; 
            },
            error: function(xhr) {
                clearTimeout(timeout);
                $icon.removeClass('bi-plus-circle spinner-border spinner-border-sm').addClass('bi-plus-circle');
                if (xhr.status === 401) { alert('You do not have permission to create roles. Please contact your administrator.'); }
                else if (xhr.status === 403) { alert('Access forbidden. You do not have the required permissions.'); }
                else { alert('An error occurred while trying to access the create role page. Please try again.'); }
            }
        });
    });
});
</script>
@endpush

@section('content')
<div class="row">
    <div class="col-xl-12">
        <div class="card custom-card">
            <div class="card-body">
                <div class="table-responsive">
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <a href="{{route('roles.create', ['t' => request('t')])}}" class="btn btn-primary btn-loading" id="add-role-btn">
                                <i class="bi bi-plus-circle me-2"></i>{{__('app.add_new_role')}}
                            </a>
                        </div>
                        <div class="col-md-6 text-end">
                            <div class="btn-group">
                                <button type="button" class="btn btn-outline-primary dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                                    <i class="bi bi-gear me-1"></i>{{__('app.actions')}}
                                </button>
                                <ul class="dropdown-menu">
                                    <li><a class="dropdown-item" href="javascript:;" onclick="destroyMany('{{ route('roles.destroy', [0]) }}')">
                                        <i class="bi bi-trash me-2"></i>{{ __('app.delete') }}
                                    </a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <table id="data" class="table table-bordered text-nowrap w-100">
                        <thead>
                            <tr>
                                <th><input type="checkbox" id='checkAll' value="0" class="form-check-input"></th>
                                <th>{{ __('app.id') }}</th>
                                <th>{{ __('app.name') }}</th>
                                <th>{{ __('app.permissions') }}</th>
                                <th>{{ __('app.created') }}</th>
                                <th>{{ __('app.actions') }}</th>
                            </tr>
                        </thead>
                         <tbody></tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<span id="route-roles" data-route="{{ route('roles') }}"></span>
<span id="role-type" data-roletype="{{ request('t') }}"></span>
@include('includes.datatables')
@endsection
