@extends('layouts.app')
@section('title', $page_title)

@section('styles')
<link href="{{asset('assets/css/smart_wizard_all.min.css')}}" rel="stylesheet" >
<link href="{{asset('assets/css/schedule.css')}}" rel="stylesheet" >
<link href="https://gitcdn.github.io/bootstrap-toggle/2.2.2/css/bootstrap-toggle.min.css" rel="stylesheet">
<style>
/* Email input group styling */
.input-group > .select2-container {
  flex: 1 1 auto;
  width: auto !important;
}
#from_email_part1 {
  height: 100%;
}
</style>
@endsection

@push('scripts')
<script src="{{asset('components/ckeditor/ckeditor.js')}}"></script>
<script src="{{asset('components/ckeditor/plugins/mc_uploader/plugin.js')}}"></script>
<script src="{{asset('assets/js/campaign.js')}}"></script>
<script src="{{asset('assets/js/jquery.smartWizard.min.js')}}"></script>
<script src="{{asset('components/jquery-repeater/jquery.repeater.min.js')}}"></script>
<script src="{{asset('assets/js/schedule.js')}}"></script>
<script src="https://gitcdn.github.io/bootstrap-toggle/2.2.2/js/bootstrap-toggle.min.js"></script>
<script>updateEndTime();</script>
<script>
$(document).ready(function() {
  // Initialize Select2 for email domain dropdown with a small delay
  setTimeout(function() {
    $('#sending-domains').select2({
      placeholder: '{{__("app.select_domain")}}',
      allowClear: false,
      width: '100%'
    });
  }, 100);
});
</script>
@endpush

@section('content')
<div class="card custom-card">
  <div class="card-body">
    <form id="frm-schedule" method="POST" action="{{ route('schedule_campaigns.store') }}" enctype="multipart/form-data" class="row g-3 mt-0 needs-validation" novalidate>
      @csrf       
      <!-- SmartWizard html -->
      <div id="smartwizard">
        <ul class="nav nav-progress">
          <li class="nav-item">
            <a class="nav-link" href="#step-1">
              <div class="num">1</div>
              {{__('app.basic_info')}}
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="#step-2" data-route="{{route('broadcasts.edit', [0])}}">
              <span class="num">2</span>
              {{__('app.campaign_detail')}}
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="#step-3">
              <span class="num">3</span>
              {{__('app.settings')}}
            </a>
          </li>
          <li class="nav-item">
            <a class="nav-link" href="#step-4">
              <div class="num">4</div>
              {{__('app.review')}}
            </a>
          </li>
        </ul>

        <div class="tab-content">
          <div id="step-1" class="tab-pane" role="tabpanel" aria-labelledby="step-1">
            <label class="form-label">{{__('app.name')}}</label>
            <input type="text" class="form-control" placeholder="{{__('app.name')}}" id="name" name="name" required>
            <div class="col-md-12 mt-3">
              <label class="form-label">{{__('app.lists')}}
                <a href="{{route('lists.create')}}" tabindex="-1">
                  <i class="bi bi-plus-circle text-primary"></i>
                </a>
                <a tabindex="-1" role="button"
                data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.lists')}}"
                data-bs-content="{{__('app.schedule_lists')}}" data-bs-custom-class="header-primary"><i class="bi bi-question-square text-primary"></i>
                </a>
              </label>
              @include('includes.dropdown_lists', ['popup' => 0, 'multiple' => 1, 'required' => 1, 'client_package_lists' => 1])
            </div>                   
            <div class="col-md-12 mt-3">
              <label class="form-label">{{__('app.delivery_servers')}}
                <a href="{{route('sending_servers.create')}}" tabindex="-1">
                  <i class="bi bi-plus-circle text-primary"></i>
                </a>
                <a tabindex="-1" role="button"
                data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.lists')}}"
                data-bs-content="{{__('app.schedule_delivery_servers')}}" data-bs-custom-class="header-primary"><i class="bi bi-question-square text-primary"></i>
                </a>
              </label>
              @include('includes.dropdown_sending_server', ['popup' => 0, 'multiple' => 1, 'required' => 1])
            </div>

            <div class="col-md-12 mt-3">
              <label class="form-label">{{__('app.from_detail')}}
                <a tabindex="-1" role="button"
                data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.from_detail')}}"
                data-bs-content="{{__('app.from_detail_help')}}" data-bs-custom-class="header-primary"><i class="bi bi-question-square text-primary"></i>
                </a>
              </label><br>
              <input name="from_detail" class="form-check-input ms-2" type="radio" checked="checked" value="sending_server"> {{__('app.as_defined_for_sending_server')}} &nbsp;
              <input name="from_detail" class="form-check-input ms-2" type="radio" value="list"> {{__('app.as_defined_for_list')}} &nbsp;
              <input name="from_detail" class="form-check-input ms-2" type="radio" value="custom"> {{__('app.custom')}}
            </div>
            <div class="row mt-3" id="custom_email_data" style="display: none;">
              <div class="col-md-3">
                 <input type="text" class="form-control" placeholder="{{__('app.from_name')}}" value="" name="from_name">
              </div>
              <div class="col-md-5">
                 <div class="input-group">
                    <div style="width: 35%;">
                      <input type="text" name="from_email_part1" value="" class="form-control" placeholder="{{__('app.from_email_example')}}">
                    </div>
                    <span class="input-group-text">@</span>
                    <select name="from_email_part2" id="sending-domains" class="single-select form-select">
                      <option value="">{{__('app.select_domain')}}</option>
                      @foreach(\App\Models\SendingDomain::getSendingDomains() as $sending_domain)
                        <option value="{{ $sending_domain->domain }}">{{ $sending_domain->domain }}</option>
                      @endforeach
                    </select>
                  </div>
              </div>
              <div class="col-md-4">
                 <input type="email" class="form-control" placeholder="{{__('app.reply_email')}}" value="" name="reply_email">
              </div>
            </div>

            <div class="col-md-12 mt-4">
              <label class="form-label">{{__('app.tracking_detail')}}</label>
              <a tabindex="-1" role="button"
                data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.tracking_detail')}}"
                data-bs-content="{!! __('app.tracking_detail_help') !!}" data-bs-custom-class="header-primary"><i class="bi bi-question-square text-primary"></i>
                </a>
                <br>
              <input type="checkbox" checked class="form-check-input" id="open_tracking" name="open_tracking" value="1"> {{__('app.open_tracking')}}
              <span class="mx-3"></span>
              <input type="checkbox" checked class="form-check-input" id="click_tracking" name="click_tracking" value="1"> {{__('app.click_tracking')}}
            </div>

          </div>
          <div id="step-2" class="tab-pane" role="tabpanel" aria-labelledby="step-2">

            <div class="row">
              <div class="col-md-9">
                <label class="form-label">{{__('app.subject')}}</label>
                <a tabindex="-1" role="button"
                data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.subject')}}"
                data-bs-content="{{__('app.subject_help')}}" data-bs-custom-class="header-primary"><i class="bi bi-question-square text-primary"></i>
                </a>
                <input type="text" class="form-control" placeholder="{{__('app.subject')}}" value="@if(!empty($broadcast)) {{\App\Http\Helper\Helper::decodeString($broadcast->email_subject)}} @endif" name="email_subject" id="email_subject">
            </div>
            <div class="col-md-3">
              <label class="form-label">{{__('app.sending_content')}}
                <a tabindex="-1" role="button"
                  data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="left" title="{{__('app.sending_content')}}"
                  data-bs-content="{{__('app.sending_content_help')}}" data-bs-custom-class="header-primary"><i class="bi bi-question-square text-primary"></i>
                  </a>
                </label>
              <select class="form-select form-select-lg" name="sending_content" id="sending_content">
                <option value="html">{{ __('app.html') }}</option>
                <option value="text">{{ __('app.text') }}</option>
              </select>
            </div>
          </div>

         <div class="col-md-12 mt-3">
            <label class="form-label">{{__('app.content_html')}}</label>
            {!! \App\Http\Helper\Helper::contentEditorButtons('content_html', true, true, false, true, true) !!}
            <textarea class="form-control" id="content_html" name="content_html" rows="10">
              @if(!empty($broadcast)) {{\App\Http\Helper\Helper::decodeString($broadcast->content_html)}} @endif </textarea>
         </div>

         <div class="col-md-12 mt-3">
            <label class="form-label">{{__('app.content_text')}} <span class="ps-5"></span></label>
            <button type="button" class="btn btn-outline-primary btn-sm" tabindex="-1" href="javascript:;" id="copy-as-text">{{__('app.copy_html_as_text')}}</button> 
              <textarea class="form-control" id="content_text" name="content_text" rows="15">@if(!empty($broadcast)) {{\App\Http\Helper\Helper::decodeString($broadcast->content_text)}} @endif </textarea>
         </div>

         <div class="col-md-12 mt-3">
           <label class="form-label">{{__('app.attachments')}} <small>(jpeg, png, gif, pdf, txt, doc, docx, xls, xlsx, zip, csv)</small></label>
           <div class="box-body repeater-attachments">
            <div data-repeater-list="attachments">
              <div data-repeater-item class="row mt-1">
                <div class="col-md-6">
                  <input class="form-control" name="file" type="file" id="file">
                </div>
                <div class="col-md-1">
                  <input data-repeater-delete type="button" class="btn btn-danger" value="Delete"/>
                </div>
              </div>
            </div>
            <div class="col-12 mt-2">
              <input data-repeater-create type="button" class="btn btn-primary" value="Add"/>
            </div>
          </div>
        </div>

          </div>

          <div id="step-3" class="tab-pane" role="tabpanel" aria-labelledby="step-3">
            <div class="col-md-12 mt-3">
              <label class="form-label">{{ __('app.send') }}
                  <a tabindex="-1" role="button"
                data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.send')}}"
                data-bs-content="{{__('app.send_help')}}" data-bs-custom-class="header-primary"><i class="bi bi-question-square text-primary"></i>
                </a>
              </label>
              <select name="send" id="send-option" class="form-select form-select-lg">
                <option value="now">{{ __('app.now') }}</option>
                <option value="later">{{ __('app.later') }}</option>
              </select>
            </div>

            <div class="col-md-12 mt-3" id="send-datetime" style="display: none;">
              <label class="form-label">{{ __('app.sending_datetime') }}</label>
              <div class="form-group">
                <div class="input-group">
                  <div class="input-group-text "> <i class="ri-calendar-line"></i> </div>
                  <input type="text" name="send_datetime" class="form-control" id="send_datetime" placeholder="{{ __('app.choose_date_time') }}">
                  <input type="hidden" name="db_send_datetime" id="db_send_datetime" value="">
                  <input type="hidden" name="timezone" id="timezone" value="{{ \Auth::user()->timezone }}" >
                </div>
              </div>
            </div>

            <div class="col-md-12 mt-3">
              <label class="form-label">{{ __('app.delivery_timing') }}
                <a tabindex="-1" role="button"
                  data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.delivery_timing')}}"
                  data-bs-content="{{__('app.delivery_timing_help')}}" data-bs-custom-class="header-primary"><i class="bi bi-question-square text-primary"></i>
                  </a>
              </label>
              <select name="delivery_timing" id="delivery_timing" class="form-select form-select-lg">
                <option value="no_time_restriction">{{ __('app.no_time_restriction') }}</option>
                <option value="specific_hours">{{ __('app.specific_hours') }}</option>
              </select>
            </div>

            <div class="row" id="delivery_timing_options" style="display: none;">
            <div class="col-md-12 mt-3">
              <div class="form-check d-flex align-items-center">
                <input class="form-check-input" type="checkbox" name="auto_scheduled_next" id="auto_scheduled_next" value="1">
                <label class="form-check-label me-2 ms-1 mt-1" for="auto_scheduled_next">
                  {{ __('app.auto_scheduled_next') }}
                </label>
                <a tabindex="-1" role="button" href="javascript:void(0);" onclick="event.stopPropagation();"
                  data-bs-toggle="popover" data-bs-trigger="click" data-bs-placement="right" title="{{__('app.auto_scheduled_next')}}"
                  data-bs-content="{{__('app.auto_scheduled_next_help')}}" data-bs-custom-class="header-primary">
                  <i class="bi bi-question-square text-primary"></i>
                </a>
              </div>
            </div>
            <div class="col-md-8 mt-3" >
              <label class="form-label">{{ __('app.days') }}</label>
              <select name="days[]" id="days" class="form-select form-select-lg" multiple>
                @foreach(\App\Http\Helper\Helper::getWeekDays() as $key => $day)
                  <option value="{{ $key }}">{{ $day }}</option>
                @endforeach
              </select>
            </div>
            <div class="col-md-2 mt-3" >
                <label class="form-label">{{ __('app.start_time') }}</label>
                  <select name="start_time" id="startTime" class="form-select form-select-lg" onchange="updateEndTime()">
                    @foreach(\App\Http\Helper\Helper::timeOptions(23) as $key => $time)
                      <option value="{{$key}}">{{$time}}</option>
                    @endforeach
                  </select>
            </div>
            <div class="col-md-2 mt-3" >
                <label class="form-label">{{ __('app.end_time') }}</label>
                  <select name="end_time" id="endTime" class="form-select form-select-lg">
                    @foreach(\App\Http\Helper\Helper::timeOptions(24) as $key => $time)
                      <option value="{{$key}}">{{$time}}</option>
                    @endforeach
                  </select>
            </div>
          </div>

            <div class="col-md-12 mt-3">
              <label class="col-md-2 form-label">{{ __('app.sending_speed') }}
              <a tabindex="-1" role="button"
            data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.sending_speed')}}"
            data-bs-content="{{__('app.sending_speed_help')}}" data-bs-custom-class="header-primary"><i class="bi bi-question-square text-primary"></i>
            </a>
              </label>
              <select name="speed" id="speed" class="form-select form-select-lg">
                <option value="unlimited">{{ __('app.unlimited') }}</option>
                <option value="limited">{{ __('app.limited') }}</option>
              </select>
            </div>

            <div class="row" id="speed-attributes" style="display: none;">
            <div class="col-md-6 mt-3" >
                <input type="number" class="form-control" name="limit" id="limit" value="" min="1" placeholder="1000">
            </div>
            <div class="col-md-6 mt-3" >
                <select name="duration" id="duration" class="form-control" >
                  <option value="hour">{{ __('app.hourly') }}</option>
                </select>
            </div>
            <div class="col-md-6 mt-3" >
                <label class="form-label">{{ __('app.pause_after_send') }} 
                <a tabindex="-1" role="button"
            data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.pause_after_send')}}"
            data-bs-content="{{__('app.pause_after_send_help')}}" data-bs-custom-class="header-primary"><i class="bi bi-question-square text-primary"></i>
            </a>
                </label>
                <input type="number" class="form-control" name="pause_limit" value="0" min="0" placeholder="0">
            </div>
            <div class="col-md-6 mt-3" >
              <label class="form-label">&nbsp;</label>
                <select name="pause_duration" class="form-control" >
                  <option value="minutes">{{ __('app.minutes') }}</option>
                </select>
            </div>
          </div>

          </div>

          <div id="step-4" class="tab-pane" role="tabpanel" aria-labelledby="step-4">
            <div class="row">
              <div class="col-12">
                <div class="card custom-card">
                  <div class="card-header">
                    <div class="d-flex align-items-center">
                      <i class="bi bi-check-circle-fill text-success me-2"></i>
                      <h5 class="mb-0">{{ __('app.review') }}</h5>
                    </div>
                  </div>
                  <div class="card-body">
                    <div class="row">
                      <div class="col-md-4">
                        <div class="card border-0 bg-light">
                          <div class="card-body p-2">
                            <h6 class="card-title text-primary mb-2">
                              <i class="bi bi-envelope me-2"></i>{{ __('app.campaign_detail') }}
                            </h6>
                            <div id="review-campaign-detail"></div>
                          </div>
                        </div>
                      </div>
                      <div class="col-md-4">
                        <div class="card border-0 bg-light">
                          <div class="card-body p-2">
                            <h6 class="card-title text-primary mb-2">
                              <i class="bi bi-gear me-2"></i>{{ __('app.settings') }}
                            </h6>
                            <div id="review-settings"></div>
                          </div>
                        </div>
                      </div>
                      <div class="col-md-4">
                        <div class="card border-0 bg-light">
                          <div class="card-body p-2">
                            <h6 class="card-title text-primary mb-2">
                              <i class="bi bi-list-ul me-2"></i>{{ __('app.targeting') }}
                            </h6>
                            <div id="review-targeting"></div>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>

        </div>
      </div>
      <input type="hidden" name="operation" id="operation" value="">
    </form>
  </div>
</div>
<span id="attachment_delete_msg" data-value="{{ __('app.attachment_delete_msg')}}"></span>
<span id="review_name" data-value="{{ __('app.name')}}"></span>
<span id="review_from_detail" data-value="{{ __('app.from_detail')}}"></span>
<span id="review_from_name" data-value="{{ __('app.from_name')}}"></span>
<span id="review_from_email" data-value="{{ __('app.from_email')}}"></span>
<span id="review_reply_email" data-value="{{ __('app.reply_email')}}"></span>
<span id="review_subject" data-value="{{ __('app.subject')}}"></span>
<span id="review_sending_content" data-value="{{ __('app.sending_content')}}"></span>
<span id="review_open_tracking" data-value="{{ __('app.open_tracking')}}"></span>
<span id="review_click_tracking" data-value="{{ __('app.click_tracking')}}"></span>
<span id="review_send" data-value="{{ __('app.send')}}"></span>
<span id="review_send_at" data-value="{{ __('app.sending_datetime')}}"></span>
<span id="review_sending_speed" data-value="{{ __('app.sending_speed')}}"></span>
<span id="review_limit" data-value="{{ __('app.limit')}}"></span>
<span id="review_maximum" data-value="{{ __('app.unlimited')}}"></span>
<span id="review_lists" data-value="{{ __('app.lists')}}"></span>
<span id="review_delivery_servers" data-value="{{ __('app.delivery_servers')}}"></span>
<span id="review_delivery_timing" data-value="{{ __('app.delivery_timing')}}"></span>
<span id="review_auto_scheduled_next" data-value="{{ __('app.auto_scheduled_next')}}"></span>
<span id="review_days" data-value="{{ __('app.days')}}"></span>
<span id="review_start_time" data-value="{{ __('app.start_time')}}"></span>
<span id="review_end_time" data-value="{{ __('app.end_time')}}"></span>
<span id="review_pause_limit" data-value="{{ __('app.pause_after_send')}}"></span>

@endsection
