@extends('layouts.app')
@section('title', $page_title)

{{-- Include global DataTable styling --}}
@include('components.datatable-styles')

@push('scripts')
<script>
$(function () {
    'use strict';
    window.datatable = $('#data').DataTable({
        "columnDefs": [{"sortable": false, "targets": [0, 9]}],
        "order": [[ 1, "desc" ]],
        "lengthMenu": [[50, 100, 200], [50, 100, 200]],
        "ajax": {
            "url": $('#route-schedule-campaigns').data('route'),
            "data": function(d) {
                d.auto_scheduled_next = $('#auto-scheduled-filter').val();
            }
        }
    });
    
    window.datatable.on('draw', function() {
        $('#data_paginate a').addClass('btn btn-primary me-1');
        $('#data_paginate .paginate_button.current').addClass('btn-light').removeClass('btn-primary');
    });

    // Filter change handler
    $('#auto-scheduled-filter').on('change', function() {
        window.datatable.ajax.reload();
    });

    setInterval(function(){ window.datatable.ajax.reload(null, false); }, 30*1000);

    // Handle Add Schedule Campaign button click with error handling
    $('#add-schedule-campaign-btn').on('click', function(e) {
        e.preventDefault();
        var href = $(this).attr('href');
        var $btn = $(this);
        var $icon = $btn.find('i');
        $icon.removeClass('bi-plus-circle').addClass('spinner-border spinner-border-sm');
        $.ajax({
            url: href, type: 'GET',
            success: function() { window.location.href = href; },
            error: function(xhr) {
                $icon.removeClass('spinner-border spinner-border-sm').addClass('bi-plus-circle');
                if (xhr.status === 401) { alert('You do not have permission to create schedule campaigns. Please contact your administrator.'); }
                else if (xhr.status === 403) { alert('Access forbidden. You do not have the required permissions.'); }
                else { alert('An error occurred while trying to access the create schedule campaign page. Please try again.'); }
            }
        });
    });
});

// Function to stop auto scheduled campaign
function stopAutoScheduled(campaignId, confirmMessage) {
    Swal.fire({
        title: '{{__("app.stop_auto_scheduled")}}',
        text: confirmMessage,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#3085d6',
        confirmButtonText: '{{__("app.yes")}}',
        cancelButtonText: '{{__("app.cancel")}}'
    }).then((result) => {
        if (result.isConfirmed) {
            // Make AJAX request to stop auto scheduled
            $.ajax({
                url: '{{ route("schedule_campaigns.stop_auto_scheduled", ":id") }}'.replace(':id', campaignId),
                type: 'POST',
                data: {
                    _token: '{{ csrf_token() }}'
                },
                success: function(response) {
                    if (response.success) {
                        Swal.fire({
                            title: '{{__("app.success")}}',
                            text: response.message,
                            icon: 'success',
                            timer: 2000,
                            showConfirmButton: false
                        });
                        // Reload the datatable
                        window.datatable.ajax.reload();
                    } else {
                        Swal.fire({
                            title: '{{__("app.error")}}',
                            text: response.message,
                            icon: 'error'
                        });
                    }
                },
                error: function() {
                    Swal.fire({
                        title: '{{__("app.error")}}',
                        text: '{{__("app.something_went_wrong")}}',
                        icon: 'error'
                    });
                }
            });
        }
    });
}
</script>
@endpush
@section('content')
<div class="row">
    <div class="col-xl-12">
        <div class="card custom-card">
            <div class="card-body">
                <div class="table-responsive">
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <a href="{{route('schedule_campaigns.create')}}" class="btn btn-primary btn-loading" id="add-schedule-campaign-btn" style="margin: 0px; display: none;">
                                <i class="bi bi-plus-circle me-2"></i>{{__('app.schedule_campaign')}}
                            </a>
                        </div>
                        <div class="col-md-6 text-end">
                            <div class="d-flex align-items-center justify-content-end gap-3">
                                <div class="d-flex align-items-center">
                                    <label class="form-label me-2 mb-0">{{__('app.auto_scheduled')}}:</label>
                                    <select id="auto-scheduled-filter" class="form-select" style="width: auto;">
                                        <option value="0" selected>{{__('app.no')}}</option>
                                        <option value="1">{{__('app.yes')}}</option>
                                    </select>
                                </div>
                                <div class="btn-group">
                                    <button type="button" class="btn btn-outline-primary dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                                        <i class="bi bi-gear me-1"></i>{{__('app.actions')}}
                                    </button>
                                    <ul class="dropdown-menu">
                                        <li><a class="dropdown-item" href="javascript:;" onclick="destroyMany('{{ route('schedule_campaigns.destroy', [0]) }}')">
                                            <i class="bi bi-trash me-2"></i>{{ __('app.delete') }}
                                        </a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <table id="data" class="table table-bordered text-nowrap w-100">
                        <thead>
                            <tr>
                                <th><input type="checkbox" id='checkAll' value="0" class="form-check-input"></th>
                                <th>{{ __('app.name') }}</th>
								<th>{{ __('app.started_at') }}</th>
								<th>{{ __('app.speed_per_hour') }}</th>
								<th>{{ __('app.status') }}</th>
								<th>{{ __('app.total') }}</th>
								<th>{{ __('app.scheduled') }}</th>
								<th>{{ __('app.progress') }}</th>
								<th>{{ __('app.created') }}</th>
								<th>{{ __('app.actions') }}</th>
                            </tr>
                        </thead>
                         <tbody></tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<span id="route-schedule-campaigns" data-route="{{ route('get.schedule_campaigns') }}"></span>
<div id="running" data-value="{{ __('app.running') }}"></div>
<div id="running-msg" data-value="{{ __('app.msg_campaign_running') }}"></div>
<div id="paused" data-value="{{ __('app.paused') }}"></div>
<div id="paused-msg" data-value="{{ __('app.msg_campaign_paused') }}"></div>
@include('includes.datatables')
@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
@endpush
@endsection
