<div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg">
<div class="modal-content">
  <div class="modal-header">
    <h6 class="modal-title">{{ __('app.scheduled') }} {{ __('app.detail') }}</h6>
    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="{{__('app.close')}}"></button>
  </div>
  <div class="modal-body">
    <div class="box-body">
      <div class="col-md-12">
        <div class="row">
          <label class="col-md-3 form-label">{{ __('app.name') }}</label>
          <div class="col-md-9">{{ $scheduled->name ?? '---' }}</div>
        </div>
        <div class="row">
          <label class="col-md-3 form-label">{{ __('app.status') }}</label>
          <div class="col-md-9">{{ $scheduled->status ?? '---' }}</div>
        </div>
        <div class="row">
          <label class="col-md-3 form-label">{{ __('app.scheduled_by') }}</label>
          <div class="col-md-9">{{ \App\Models\User::getUserValue($scheduled->user_id, 'name') ?? '---' }}</div>
        </div>
        <div class="row">
          <label class="col-md-3 form-label">{{ __('app.lists') }}</label>
          @php $lists = \App\Models\Lists::whereIn('id', explode(',', $scheduled->list_ids))->pluck('name')->toArray(); @endphp
          <div class="col-md-9 form-label">{{ implode(', ', $lists) }}</div>
        </div>
        <div class="row">
          <label class="col-md-3 form-label">{{ __('app.subject') }}</label>
          <div class="col-md-9">{{ $scheduled->email_subject ?? '---' }}</div>
        </div>
        <div class="row">
          <label class="col-md-3 form-label">{{ __('app.content') }}</label>
          <div class="col-md-9"><a class="link-info" target="_blank" href="{{route('get.schedule_campaign.content', [$scheduled->id])}}">{{ __('app.view') }}</a></div>
        </div>
        <div class="row">
          <label class="col-md-3 form-label">{{ __('app.delivery_servers') }}</label>
          @php $sending_servers = \App\Models\SendingServer::whereIn('id', explode(',', $scheduled->sending_server_ids))->pluck('name')->toArray(); @endphp
          <div class="col-md-9">{{ implode(', ', $sending_servers) }}</div>
        </div>
        <div class="row">
          <label class="col-md-3 form-label">{{ __('app.total') }}</label>
          <div class="col-md-9">{{ $scheduled->total }}</div>
        </div>
        <div class="row">
          <label class="col-md-3 form-label">{{ __('app.created') }}</label>
          <div class="col-md-9">{{ \App\Http\Helper\Helper::datetimeDisplay($scheduled->created_at) ?? '---' }}</div>
        </div>
        <div class="row">
          <label class="col-md-3 form-label">{{ __('app.started_at') }}</label>
          <div class="col-md-9">{{ $scheduled->status != 'Preparing' && $scheduled->status != 'Draft' ? \App\Http\Helper\Helper::datetimeDisplay($scheduled->start_datetime) : '---' }}</div>
        </div>
        <div class="row">
          <label class="col-md-3 form-label">{{ __('app.ended_at') }}</label>
          <div class="col-md-9">{{ $scheduled->status != 'Preparing' && $scheduled->status != 'Draft' ? \App\Http\Helper\Helper::datetimeDisplay($scheduled->end_datetime) : '---' }}</div>
        </div>
        
        <!-- Delivery Timing Section -->
        <hr class="my-3">
        <h6 class="text-primary mb-3">{{ __('app.delivery_timing') }}</h6>
        @php
          $delivery_timing = json_decode($scheduled->delivery_timing_detail, true);
        @endphp
        <div class="row">
          <label class="col-md-3 form-label">{{ __('app.delivery_timing') }}</label>
          <div class="col-md-9">
            @if(isset($delivery_timing['delivery_timing']))
              @if($delivery_timing['delivery_timing'] == 'specific_hours')
                <span class="badge bg-info">{{ __('app.specific_hours') }}</span>
              @else
                <span class="badge bg-secondary">{{ __('app.no_time_restriction') }}</span>
              @endif
            @else
              <span class="badge bg-secondary">{{ __('app.no_time_restriction') }}</span>
            @endif
          </div>
        </div>
        
        @if(isset($delivery_timing['delivery_timing']) && $delivery_timing['delivery_timing'] == 'specific_hours')
          @if(isset($delivery_timing['days']) && is_array($delivery_timing['days']))
            <div class="row">
              <label class="col-md-3 form-label">{{ __('app.days') }}</label>
              <div class="col-md-9">
                @foreach($delivery_timing['days'] as $day)
                  <span class="badge bg-primary me-1">{{ ucfirst($day) }}</span>
                @endforeach
              </div>
            </div>
          @endif
          
          @if(isset($delivery_timing['start_time']))
            <div class="row">
              <label class="col-md-3 form-label">{{ __('app.start_time') }}</label>
              <div class="col-md-9">{{ date('g:i A', strtotime($delivery_timing['start_time'] . ':00')) }}</div>
            </div>
          @endif
          
          @if(isset($delivery_timing['end_time']))
            <div class="row">
              <label class="col-md-3 form-label">{{ __('app.end_time') }}</label>
              <div class="col-md-9">{{ date('g:i A', strtotime($delivery_timing['end_time'] . ':00')) }}</div>
            </div>
          @endif
        @endif
        
        <!-- Sending Speed Section -->
        <hr class="my-3">
        <h6 class="text-primary mb-3">{{ __('app.sending_speed') }}</h6>
        @php
          $sending_speed = json_decode($scheduled->sending_speed, true);
        @endphp
        <div class="row">
          <label class="col-md-3 form-label">{{ __('app.speed_type') }}</label>
          <div class="col-md-9">
            @if(isset($sending_speed['speed']))
              @if($sending_speed['speed'] == 'unlimited')
                <span class="badge bg-success">{{ __('app.maximum') }}</span>
              @else
                <span class="badge bg-warning">{{ __('app.limited') }}</span>
              @endif
            @else
              <span class="badge bg-success">{{ __('app.maximum') }}</span>
            @endif
          </div>
        </div>
        
        @if(isset($sending_speed['speed']) && $sending_speed['speed'] == 'limited')
          @if(isset($sending_speed['limit']))
            <div class="row">
              <label class="col-md-3 form-label">{{ __('app.hourly_speed') }}</label>
              <div class="col-md-9">{{ $sending_speed['limit'] }} {{ __('app.emails_per_hour') }}</div>
            </div>
          @endif
          
          @if(isset($sending_speed['pause_limit']) && $sending_speed['pause_limit'] > 0)
            <div class="row">
              <label class="col-md-3 form-label">{{ __('app.pause_after_send') }}</label>
              <div class="col-md-9">{{ $sending_speed['pause_limit'] }} {{ __('app.emails') }} - {{ $sending_speed['pause_duration'] ?? 'minutes' }}</div>
            </div>
          @endif
          
          @if(isset($sending_speed['duration']))
            <div class="row">
              <label class="col-md-3 form-label">{{ __('app.duration') }}</label>
              <div class="col-md-9">{{ ucfirst($sending_speed['duration']) }}</div>
            </div>
          @endif
        @endif
        
        <!-- Auto Scheduled Next Section -->
        <hr class="my-3">
        <h6 class="text-primary mb-3">{{ __('app.auto_scheduled_next') }}</h6>
        <div class="row">
          <label class="col-md-3 form-label">{{ __('app.auto_scheduled_next') }}</label>
          <div class="col-md-9">
            @if($scheduled->auto_scheduled_next)
              <span class="badge bg-success">{{ __('app.yes') }}</span>
            @else
              <span class="badge bg-secondary">{{ __('app.no') }}</span>
            @endif
          </div>
        </div>
      </div>
    </div>
  </div>
  <div class="modal-footer">
    <button type="button" class="btn btn-danger" data-bs-dismiss="modal">{{__('app.close')}}</button>
    @if($scheduled->status != 'Preparing' && $scheduled->status != 'Draft')
      <a href="{{route('detail.stat.campaign', ['id' => $scheduled->stats_id])}}">
      <button type="button" class="btn btn-primary" >{{__('app.detail')}}</button>
      </a>
    @endif
  </div>
</div>
</div>
