@extends('layouts.app')
@section('title', $page_title)

@section('styles')

@endsection

@push('scripts')
<script src="{{asset('assets/js/app.js')}}"></script>
@endpush

@section('content')
<div class="row">
  <div class="col-12">
    <div class="card custom-card">
      <div class="card-body">
        <form method="post" action="{{route('list_segmentations.store')}}" class="needs-validation" novalidate>
          @csrf
          <input type="hidden" name="type" value="{{ isset($type) ? $type : 'Campaign' }}">
          
          <!-- Basic Information Section -->
          <div class="row">
            <div class="col-12">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{__('app.name')}}</label>
                <input type="text" class="form-control" placeholder="{{__('app.name')}}" id="name" name="name" required>
                <div class="invalid-feedback">{{__('app.name_required')}}</div>
              </div>
            </div>
            <div class="col-12">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{__('app.campaigns')}}
                  <a tabindex="-1" role="button" data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" 
                     title="{{__('app.campaigns')}}" data-bs-content="{{__('app.segmentation_campaigns_help')}}" 
                     data-bs-custom-class="header-primary" class="text-primary ms-1">
                    <i class="bi bi-question-circle"></i>
                  </a>
                </label>
                @include('includes.dropdown_campaigns', ['multiple' => 1, 'required' => 1])
              </div>
            </div>
            <div class="col-md-12">
            <label class="form-label fw-semibold">{{ __('app.criteria') }}
  <a tabindex="-1" role="button"
    data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.criteria')}}"
    data-bs-content="{{__('app.trigger_criteria_help')}}" data-bs-custom-class="header-primary"><i class="bi bi-question-square text-primary"></i>
  </a>
  </label>
  <select class="form-select form-select-lg" name="action_campaign" id="action-campaign" required>
    <option value="both">{{ __('app.both_open_not_open') }}</option>
    <option value="is_opened">{{ __('app.is_opened') }}</option>
    <option value="is_not_opened">{{ __('app.is_not_opened') }}</option>
    <option value="is_clicked">{{ __('app.is_clicked') }}</option>
    <option value="is_replied">{{ __('app.is_replied') }}</option>
  </select>
</div>
            <div class="col-md-6">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{__('app.allow_unsub')}}
                  <a tabindex="-1" role="button" data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" 
                     title="{{__('app.allow_unsub')}}" data-bs-content="{{__('app.segmentation_allow_unsub_help')}}" 
                     data-bs-custom-class="header-primary" class="text-primary ms-1">
                    <i class="bi bi-question-circle"></i>
                  </a>
                </label>
                <select name="allow_unsub" class="form-select form-select-lg">
                  <option value="Yes">{{ __('app.yes') }}</option>
                  <option value="No">{{ __('app.no')}}</option>			          
                </select>
              </div>
            </div>
            <div class="col-md-6">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{__('app.allow_bounced')}}
                  <a tabindex="-1" role="button" data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" 
                     title="{{__('app.allow_bounced')}}" data-bs-content="{{__('app.segmentation_allow_bounced_help')}}" 
                     data-bs-custom-class="header-primary" class="text-primary ms-1">
                    <i class="bi bi-question-circle"></i>
                  </a>
                </label>
                <select name="allow_bounced" class="form-select form-select-lg">
                  <option value="Yes">{{ __('app.yes') }}</option>
                  <option value="No">{{ __('app.no')}}</option>			          
                </select>
              </div>
            </div>
          </div>

          <!-- Action Buttons -->
          <div class="row mt-3">
            <div class="col-12">
              <div class="d-flex gap-2 justify-content-start">
              <button type="submit" name="save" class="btn btn-primary btn-loading">
                  <i class="bi bi-check-lg me-1"></i>{{__('app.save')}}
                </button>
                <a href="{{route('campaign_segmentations.index')}}" class="btn btn-light">
                  <i class="bi bi-arrow-left me-1"></i>{{__('app.cancel')}}
                </a>                
              </div>
            </div>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>
<span id="segment_delete_msg" data-value="{{ __('app.segment_delete_msg')}}"></span>
@endsection
