@extends('layouts.app')
@section('title', $page_title)

@section('styles')

@endsection

@push('scripts')
<script src="{{asset('components/jquery-repeater/jquery.repeater.min.js')}}"></script>
<script src="{{asset('assets/js/app.js')}}"></script>
<script src="{{asset('assets/js/segmentation.js')}}"></script>
<script>
$(document).ready(function() {
  // Add validation for list multiselect
  var forms = document.getElementsByClassName('needs-validation');
  Array.prototype.filter.call(forms, function (form) {
    form.addEventListener('submit', function (event) {
      var formIsValid = form.checkValidity();
      
      // Always validate lists
      const listDropdown = document.getElementById("list_ids");
      var listValid = true;
      
      if (listDropdown && !listDropdown.disabled) {
        var listSelectedValues = $(listDropdown).val();
        var isValid = false;
        
        if (listSelectedValues === null || listSelectedValues === undefined) {
          isValid = false;
        } else if (Array.isArray(listSelectedValues)) {
          var validValues = listSelectedValues.filter(function(val) { 
            return val !== '' && val !== null && val !== undefined && String(val).trim() !== ''; 
          });
          isValid = validValues.length > 0;
        } else if (typeof listSelectedValues === 'string') {
          isValid = listSelectedValues.trim() !== '' && listSelectedValues !== null;
        }
        
        if (isValid) {
          var $selectedOptions = $(listDropdown).find('option:selected[value!=""]');
          isValid = $selectedOptions.length > 0;
        }
        
        listValid = isValid;
        
        var $listMultiselectBtn = $(listDropdown).next('.btn-group').find('.multiselect');
        if ($listMultiselectBtn.length === 0) {
          $listMultiselectBtn = $(listDropdown).siblings('.btn-group').find('.multiselect');
        }
        if ($listMultiselectBtn.length === 0) {
          $listMultiselectBtn = $(listDropdown).closest('.form-group, .col-md-12, .col-12').find('.multiselect');
        }
        
        if (!isValid) {
          if ($listMultiselectBtn.length > 0) {
            $listMultiselectBtn.addClass("is-invalid").css({
              'border-color': '#dc3545',
              'box-shadow': '0 0 0 0.2rem rgba(220, 53, 69, 0.25)'
            });
          }
          $(listDropdown).addClass("is-invalid");
          var $feedback = $('#list_ids_feedback');
          if ($feedback.length === 0) {
            $feedback = $(listDropdown).next('.invalid-feedback');
          }
          if ($feedback.length === 0) {
            $feedback = $(listDropdown).siblings('.invalid-feedback');
          }
          if ($feedback.length === 0) {
            $feedback = $(listDropdown).closest('.form-group, .col-md-12, .col-12').find('.invalid-feedback');
          }
          if ($feedback.length > 0) {
            $feedback.show();
          }
        } else {
          if ($listMultiselectBtn.length > 0) {
            $listMultiselectBtn.removeClass("is-invalid").css({
              'border-color': '',
              'box-shadow': ''
            });
            $listMultiselectBtn.addClass("is-valid");
          }
          $(listDropdown).removeClass("is-invalid");
          var $feedback = $('#list_ids_feedback');
          if ($feedback.length === 0) {
            $feedback = $(listDropdown).next('.invalid-feedback');
          }
          if ($feedback.length === 0) {
            $feedback = $(listDropdown).siblings('.invalid-feedback');
          }
          if ($feedback.length === 0) {
            $feedback = $(listDropdown).closest('.form-group, .col-md-12, .col-12').find('.invalid-feedback');
          }
          if ($feedback.length > 0) {
            $feedback.hide();
          }
        }
      }
      
      if (!formIsValid || !listValid) {
        event.preventDefault();
        event.stopPropagation();
      }
      
      form.classList.add('was-validated');
    }, false);
  });
  
  // Clear validation on change for lists
  $('#list_ids').on('change', function() {
    var $select = $(this);
    if ($select.prop('disabled')) return; // Skip if disabled
    
    var selectedValues = $select.val();
    var hasSelection = false;
    
    if (selectedValues === null || selectedValues === undefined) {
      hasSelection = false;
    } else if (Array.isArray(selectedValues)) {
      var validValues = selectedValues.filter(function(val) { 
        return val !== '' && val !== null && val !== undefined && String(val).trim() !== ''; 
      });
      hasSelection = validValues.length > 0;
    } else if (typeof selectedValues === 'string') {
      hasSelection = selectedValues.trim() !== '' && selectedValues !== null;
    }
    
    if (hasSelection) {
      var $selectedOptions = $select.find('option:selected[value!=""]');
      hasSelection = $selectedOptions.length > 0;
    }
    
    var $multiselectBtn = $select.next('.btn-group').find('.multiselect');
    if ($multiselectBtn.length === 0) {
      $multiselectBtn = $select.siblings('.btn-group').find('.multiselect');
    }
    if ($multiselectBtn.length === 0) {
      $multiselectBtn = $select.closest('.form-group, .col-md-12, .col-12').find('.multiselect');
    }
    
    if (hasSelection) {
      $select.removeClass("is-invalid");
      if ($multiselectBtn.length > 0) {
        $multiselectBtn.removeClass("is-invalid").css({
          'border-color': '',
          'box-shadow': ''
        });
      }
      var $feedback = $('#list_ids_feedback');
      if ($feedback.length === 0) {
        $feedback = $select.next('.invalid-feedback');
      }
      if ($feedback.length === 0) {
        $feedback = $select.siblings('.invalid-feedback');
      }
      if ($feedback.length === 0) {
        $feedback = $select.closest('.form-group, .col-md-12, .col-12').find('.invalid-feedback');
      }
      if ($feedback.length > 0) {
        $feedback.hide();
      }
    }
  });
});
</script>
@endpush

@php $attributes = json_decode($segment->attributes) @endphp
@section('content')
<div class="row">
  <div class="col-12">
    <div class="card custom-card">
      <div class="card-body">
        <form method="post" action="{{route('list_segmentations.update', $segment->id)}}" class="needs-validation" novalidate>
          @csrf
          @method('PUT')
          
          <!-- Basic Information Section -->
          <div class="row mb-3">
            <div class="col-12">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{__('app.name')}}</label>
                <input type="text" class="form-control" placeholder="{{__('app.name')}}" id="name" name="name" value="{{ $segment->name }}" required>
                <div class="invalid-feedback">{{__('app.name_required')}}</div>
              </div>
            </div>
            <div class="col-12">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{__('app.lists')}}
                  <a href="{{route('lists.create')}}" class="text-primary ms-1">
                    <i class="bi bi-plus-circle"></i>
                  </a>
                  <a tabindex="-1" role="button" data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" 
                     title="{{__('app.lists')}}" data-bs-content="{{__('app.segmentation_lists_help')}}" 
                     data-bs-custom-class="header-primary" class="text-primary ms-1">
                    <i class="bi bi-question-circle"></i>
                  </a>
                </label>
                @php $list_ids = $attributes->list_ids  @endphp
                @include('includes.dropdown_lists', ['popup' => 0, 'multiple' => 1, 'required' => 1])
              </div>
            </div>
            <div class="col-md-6">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{__('app.allow_unsub')}}
                  <a tabindex="-1" role="button" data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" 
                     title="{{__('app.allow_unsub')}}" data-bs-content="{{__('app.segmentation_allow_unsub_help')}}" 
                     data-bs-custom-class="header-primary" class="text-primary ms-1">
                    <i class="bi bi-question-circle"></i>
                  </a>
                </label>
                <select name="allow_unsub" class="form-select form-select-lg">
                  <option value="Yes" {{ !empty($attributes->allow_unsub) && $attributes->allow_unsub == 'Yes' ? 'selected' : '' }}>{{ __('app.yes') }}</option>
                  <option value="No" {{ !empty($attributes->allow_unsub) && $attributes->allow_unsub == 'No' ? 'selected' : '' }}>{{ __('app.no')}}</option>			          
                </select>
              </div>
            </div>
            <div class="col-md-6">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{__('app.allow_bounced')}}
                  <a tabindex="-1" role="button" data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" 
                     title="{{__('app.allow_bounced')}}" data-bs-content="{{__('app.segmentation_allow_bounced_help')}}" 
                     data-bs-custom-class="header-primary" class="text-primary ms-1">
                    <i class="bi bi-question-circle"></i>
                  </a>
                </label>
                <select name="allow_bounced" class="form-select form-select-lg">
                  <option value="Yes" {{ !empty($attributes->allow_bounced) && $attributes->allow_bounced == 'Yes' ? 'selected' : '' }}>{{ __('app.yes') }}</option>
                  <option value="No" {{ !empty($attributes->allow_bounced) && $attributes->allow_bounced == 'No' ? 'selected' : '' }}>{{ __('app.no')}}</option>			          
                </select>
              </div>
            </div>
          </div>
          <!-- Contact Filters Section -->
          <div class="row mb-3">
            <div class="col-12">
              <div class="d-flex align-items-center">
                <div class="me-3">
                  <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                    <i class="bi bi-people"></i>
                  </span>
                </div>
                <h6 class="mb-0 text-info fw-semibold fs-14">{{ __('app.contact_filters') }}
                  <a tabindex="-1" role="button" data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" 
                     title="{{__('app.contact_filters')}}" data-bs-content="{{__('app.segmentation_contact_filters_help')}}" 
                     data-bs-custom-class="header-primary" class="text-primary ms-1">
                    <i class="bi bi-question-circle"></i>
                  </a>
                </h6>
              </div>
            </div>
            <div class="col-12">
              <div class="box-body repeater-contact">
                <div data-repeater-list="contact_filter">
                  @php $contact_filter = $attributes->contact_filter @endphp
                  @foreach($contact_filter as $filter)
                    <div data-repeater-item class="row mt-3">
                      <div class="col-md-4">
                        <span data-repeater-delete>AND</span>
                        <select name="name" class="form-select" onchange="loadContactAction(this);">
                          <option value=""></option>
                          <option value="email" {{ $filter->name == 'email' ? 'selected' : '' }}>{{ __('app.email') }}</option>
                          <option value="status" {{ $filter->name == 'status' ? 'selected' : '' }}>{{ __('app.status') }}</option>
                          <option value="source" {{ $filter->name == 'source' ? 'selected' : '' }}>{{ __('app.source') }}</option>
                        </select>
                      </div>
                      <div class="col-md-3">
                        <span data-repeater-delete>&nbsp;</span>
                        <select name="action" class="form-select">
                          <option value='is' {{ !empty($filter->action) &&  $filter->action == 'is' ? 'selected' : '' }}>is</option>
                          <option value='is_not' {{ !empty($filter->action) &&  $filter->action == 'is_not' ? 'selected' : '' }}>is not</option>
                          @if($filter->name == 'email')
                          <option value='contain' {{ !empty($filter->action) && $filter->action == 'contain' ? 'selected' : '' }}>contain</option>
                          <option value='not_contain' {{ !empty($filter->action) && $filter->action == 'not_contain' ? 'selected' : '' }}>doesn't</option>
                          @endif
                        </select>
                      </div>
                      <div class="col-md-4">
                        <span data-repeater-delete>&nbsp;</span>
                        @if($filter->name == 'email')
                          <input type='text' class='form-control' placeholder='Use comma for multiples' name='value' value="{{ $filter->value }}">
                        @else
                          <select name="value" class="form-select">
                            @if($filter->name == 'status')
                              <option value='active' {{ $filter->value == 'is_not' ? 'selected' : '' }}>Active</option>
                              <option value='inactive' {{ $filter->value == 'is_not' ? 'selected' : '' }}>Inactive</option>
                            @endif
                          </select>
                        @endif
                      </div>
                      <div class="col-md-1" style="margin:inherit;">
                        <span data-repeater-delete>&nbsp;</span>
                        <input data-repeater-delete type="button" class="btn btn-danger" value="Delete"/>
                      </div>
                    </div>
                  @endforeach
                </div>
                <div class="col-12 mt-2">
                  <input data-repeater-create type="button" class="btn btn-outline-primary" value="Add"/>
                </div>
              </div>
            </div>
          </div>
          <!-- Custom Fields Filters Section -->
          <div class="row mb-3">
            <div class="col-12">
              <div class="d-flex align-items-center">
                <div class="me-3">
                  <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                    <i class="bi bi-list-check"></i>
                  </span>
                </div>
                <h6 class="mb-0 text-info fw-semibold fs-14">{{ __('app.custom_fields_filters') }}
                  <a tabindex="-1" role="button" data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" 
                     title="{{__('app.custom_fields_filters')}}" data-bs-content="{{__('app.segmentation_custom_fields_filters_help')}}" 
                     data-bs-custom-class="header-primary" class="text-primary ms-1">
                    <i class="bi bi-question-circle"></i>
                  </a>
                </h6>
              </div>
            </div>
            <div class="col-12">
              <div class="box-body repeater-contact">
                @php $custom_fields_filter = $attributes->custom_fields_filter @endphp
                @foreach($custom_fields_filter as $filter)
                  <div data-repeater-list="custom_fields_filter">
                    <div data-repeater-item class="row mt-3">
                      <div class="col-md-4">
                        <span data-repeater-delete>AND</span>
                        <select name="name" class="form-select" onchange="loadCustomFieldAction(this, '{{ __('app.use_comma_for_multiples') }}')">
                          <option value=""></option>
                          @if(!empty($custom_fields))
                            @foreach($custom_fields as $custom_field)
                              <option value="{{ $custom_field->id }}" {{ $filter->name == $custom_field->id ? 'selected' : '' }}>{{ $custom_field->name }}</option>
                            @endforeach
                          @endif
                        </select>
                      </div>
                      <div class="col-md-3">
                        <span data-repeater-delete>&nbsp;</span>
                        <select name="action" class="form-select">
                          <option value=""></option>
                          <option value="is" {{ $filter->action == 'is' ? 'selected' : '' }}>is</option>
                          <option value="is_not" {{ $filter->action == 'is_not' ? 'selected' : '' }}>is not</option>
                          <option value="contain" {{ $filter->action == 'contain' ? 'selected' : '' }}>contain</option>
                          <option value="not_contain" {{ $filter->action == 'not_contain' ? 'selected' : '' }}>doesn't</option>
                        </select>
                      </div>
                      <div class="col-md-4">
                        <span data-repeater-delete>&nbsp;</span>
                        <input type="text" name="value" class="form-control" placeholder="Use comma for multiples" value="{{ $filter->value }}">
                      </div>
                      <div class="col-md-1" style="margin:inherit;">
                        <span data-repeater-delete>&nbsp;</span>
                        <input data-repeater-delete type="button" class="btn btn-danger" value="Delete"/>
                      </div>
                    </div>
                  </div>
                @endforeach
                <div class="col-12 mt-2">
                  <input data-repeater-create type="button" class="btn btn-outline-primary" value="Add"/>
                </div>
              </div>
            </div>
          </div>
          <!-- Date Filters Section -->
          <div class="row mb-3">
            <div class="col-12">
              <div class="d-flex align-items-center">
                <div class="me-3">
                  <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                    <i class="bi bi-calendar"></i>
                  </span>
                </div>
                <h6 class="mb-0 text-info fw-semibold fs-14">{{ __('app.date_filters') }}
                  <a tabindex="-1" role="button" data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" 
                     title="{{__('app.date_filters')}}" data-bs-content="{{__('app.segmentation_date_filters_help')}}" 
                     data-bs-custom-class="header-primary" class="text-primary ms-1">
                    <i class="bi bi-question-circle"></i>
                  </a>
                </h6>
              </div>
            </div>
            <div class="col-12">
              <div class="box-body repeater-contact">
                <div data-repeater-list="dates_filter">
                  @php $dates_filter = $attributes->dates_filter @endphp
                  @foreach($dates_filter as $filter)
                    <div data-repeater-item class="row mt-3">
                      <div class="col-md-4">
                        <span data-repeater-delete>AND</span>
                        <select name="name" class="form-select" onchange="loadDateFieldAction(this)">
                          <option value=""></option>
                          <option value="subscription_date" {{ $filter->name == 'subscription_date' ? 'selected' : '' }}>Subscription Date</option>
                          @if(!empty($custom_fields))
                            @foreach($custom_fields_date as $custom_field)
                              <option value="{{ $custom_field->id }}" {{ $filter->name == $custom_field->id ? 'selected' : '' }}>{{ $custom_field->name }}</option>
                            @endforeach
                          @endif
                        </select>
                      </div>
                      <div class="col-md-3">
                        <span data-repeater-delete>&nbsp;</span>
                        <select name="action" class="form-select" onchange="loadDate(this)">
                          <option value=""></option>
                          <option value="is" {{ $filter->action == 'is' ? 'selected' : '' }}>is</option>
                          <option value="is_not" {{ $filter->action == 'is_not' ? 'selected' : '' }}>is not</option>
                          <option value="after" {{ $filter->action == 'after' ? 'selected' : '' }}>after</option>
                          <option value="before" {{ $filter->action == 'before' ? 'selected' : '' }}>before</option>
                        </select>
                      </div>
                      <div class="col-md-4">
                        <span data-repeater-delete>&nbsp;</span>
                        <input type="text" name="value" class="form-control" value="{{ $filter->value }}" id="datetime">
                      </div>
                      <div class="col-md-1" style="margin:inherit;">
                        <span data-repeater-delete>&nbsp;</span>
                        <input data-repeater-delete type="button" class="btn btn-danger" value="Delete"/>
                      </div>
                    </div>
                  @endforeach
                </div>
                <div class="col-12 mt-2">
                  <input data-repeater-create type="button" class="btn btn-outline-primary" value="Add"/>
                </div>
              </div>
            </div>
          </div>

          <!-- Action Buttons -->
          <div class="row">
            <div class="col-12">
              <div class="d-flex gap-2 justify-content-start">
                <button type="submit" name="save" class="btn btn-primary btn-loading">
                  <i class="bi bi-check-lg me-1"></i>{{__('app.update')}}
                </button>
                <a href="{{route('list_segmentations.index')}}" class="btn btn-light">
                  <i class="bi bi-arrow-left me-1"></i>{{__('app.cancel')}}
                </a>
              </div>
            </div>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>
<span id="segment_delete_msg" data-value="{{ __('app.segment_delete_msg')}}"></span>
@endsection
