<script>
(function () {
  'use strict';
  $(".single-select").select2({
      dir: "ltr",
      minimumResultsForSearch: Infinity // This disables the search box
    });
});
$('[data-bs-toggle="popover"]').popover({
    container: 'body'
});
</script>
<script src="{{asset('assets/js/app.js')}}"></script>
<div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg">
    <div class="modal-content">
      <form id="frm-group" method="post" action="{{route('sending_domains.store')}}" class="needs-validation" novalidate>
        @csrf
        <div class="modal-header">
          <div class="d-flex align-items-center">
            <div class="me-3">
              <span class="avatar avatar-sm avatar-rounded bg-info svg-white">
                <i class="bi bi-plus-circle"></i>
              </span>
            </div>
            <h6 class="modal-title mb-0 fw-semibold">{{__('app.add_new_sending_domain')}}</h6>
          </div>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="{{__('app.close')}}"></button>
        </div>
        <div class="modal-body">
          <div class="box-body">
            <!-- Domain Configuration Section -->
            <div class="row">
              <div class="col-md-3">
                <div class="form-group">
                  <label class="form-label fw-semibold">{{__('app.protocol')}}</label>
                  <select name="protocol" class="form-select form-select-lg">
                     <option value="https://">https://</option>
                     <option value="http://">http://</option>
                  </select>
                </div>
              </div>
              <div class="col-md-9">
                <div class="form-group">
                  <label class="form-label fw-semibold">{{__('app.domain')}}</label>
                  <input type="text" class="form-control" placeholder="example.com" value="" name="domain" required>
                  <div class="invalid-feedback">{{__('app.domain_required')}}</div>
                </div>
              </div>
            </div>

            <!-- Configuration Section -->
            <div class="row mt-3">
              <div class="col-12">
                <div class="d-flex align-items-center">
                  <div class="me-3">
                    <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                      <i class="bi bi-gear"></i>
                    </span>
                  </div>
                  <h6 class="mb-0 text-info fw-semibold fs-14">{{__('app.settings')}}</h6>
                </div>
              </div>
              <div class="col-md-4">
                <div class="form-group">
                  <label class="form-label fw-semibold mt-3">{{__('app.group')}}
                    <a href="javascript:;" onclick="viewModal('modal', '{{route('group.create', ['type_id' => config('custom.group_sending_domains')])}}');" tabindex="-1">
                      <i class="bi bi-plus-circle text-primary"></i>
                    </a>
                  </label>
                  <select name="group_id" class="single-select form-select" id="group_id" required>
                    <option value="">{{__('app.select_group')}}</option>
                    @foreach($groups as $id => $group_name)
                    <option value="{{ $id }}" {{ old('group_id') == $id ? 'selected' : '' }}>{{$group_name}}</option>
                    @endforeach
                  </select>
                  <div class="invalid-feedback">{{ __('app.select_group_error')}}</div>
                </div>
              </div>
              <div class="col-md-4">
                <div class="form-group">
                  <label class="form-label fw-semibold mt-3">{{__('app.active')}}</label>
                  <select name="is_active" class="form-select form-select-lg">
                     <option value="1">{{ __('app.yes')}}</option>
                     <option value="0">{{ __('app.no') }}</option>
                  </select>
                </div>
              </div>
              <div class="col-md-4">
                <div class="form-group">
                  <label class="form-label fw-semibold mt-3">{{__('app.auto_verification')}}
                    <a tabindex="-1" role="button"
                    data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.auto_verification')}}"
                    data-bs-content="{{__('app.domain_auto_verfication_help')}}" data-bs-custom-class="header-primary" class="text-primary ms-1">
                      <i class="bi bi-question-circle"></i>
                    </a>
                  </label>
                  <select name="auto_verification" class="form-select form-select-lg">
                     <option value="0">{{ __('app.no')}}</option>
                     <option value="1">{{ __('app.yes') }}</option>
                  </select>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-light" data-bs-dismiss="modal">
            <i class="bi bi-x-lg me-1"></i>{{__('app.close')}}
          </button>
          <button type="submit" class="btn btn-primary btn-loading">
            <i class="bi bi-check-lg me-1"></i>{{__('app.create')}}
          </button>
        </div>
      </form>
    </div>
</div>
