@extends('layouts.app')
@section('title', __('app.sending_domain_detil'))

@push('scripts')
<script>
  $(document).on('click', '.bi-copy', function() {
    // Find the nearest input field within the same input group
    var inputVal = $(this).closest('.input-group').find('input').val();
    
    // Create a temporary input element to hold the value
    var tempInput = $('<input>');
    $('body').append(tempInput);
    tempInput.val(inputVal).select();
    
    // Copy the value to the clipboard
    document.execCommand('copy');
    
    // Remove the temporary input element
    tempInput.remove();
    toastr.success('Copied successfully!');
});

$(document).ready(function() {
  // Initialize Select2 for group dropdown with search enabled
  $('#group_id').select2({
    placeholder: '{{__("app.select_group")}}',
    allowClear: false,
    width: '100%',
    minimumResultsForSearch: 0 // Enable search for group dropdown
  });
});
</script>
<style>
/* Ensure consistent dropdown heights */
select[name="is_active"], 
select[name="auto_verification"] {
  height: 38px;
  min-height: 38px;
}
</style>
@endpush

@section('content')
<div class="row">
  <div class="col-xl-12">
    <div class="card custom-card">
      <div class="card-body">
        <form method="POST" action="{{route('sending_domains.update', $sending_domain->id)}}" class="needs-validation" novalidate>
          @csrf
          @method('PUT')
          
          <!-- Domain Header Section -->
          <div class="row mb-4">
            <div class="col-12">
              <div class="d-flex align-items-center">
                <div class="me-3">
                  <span class="avatar avatar-sm avatar-rounded bg-info svg-white">
                    <i class="bi bi-globe"></i>
                  </span>
                </div>
                <div class="me-3">
                  <select name="protocol" class="form-select form-select-sm">
                    <option value="https://" {{ $sending_domain->protocol == 'https://' ? 'selected' : '' }}>https://</option>
                    <option value="http://" {{ $sending_domain->protocol == 'http://' ? 'selected' : '' }}>http://</option>
                  </select>
                </div>
                <div class="flex-grow-1">
                  <h5 class="mb-0 fw-semibold text-primary">{{$sending_domain->domain}}</h5>
                </div>
              </div>
            </div>
          </div>

          <!-- Configuration Section -->
          <div class="row mb-4">
            <div class="col-md-4">
              <div class="form-group">
                <label class="form-label fw-semibold">{{__('app.group')}}
                  <a href="javascript:;" onclick="viewModal('modal', '{{route('group.create', ['type_id' => config('custom.group_sending_domains')])}}');" tabindex="-1">
                    <i class="bi bi-plus-circle text-primary"></i>
                  </a>
                </label>
                <select name="group_id" class="single-select form-select" id="group_id" required>
                  @foreach($groups as $id => $group_name)
                  <option value="{{ $id }}" {{ $sending_domain->group_id == $id ? 'selected' : '' }}>{{$group_name}}</option>
                  @endforeach
                </select>
              </div>
            </div>
            <div class="col-md-4">
              <div class="form-group">
                <label class="form-label fw-semibold">{{__('app.active')}}</label>
                <select name="is_active" class="form-select">
                  <option value="1" {{ $sending_domain->is_active ? 'selected' : '' }}>{{ __('app.yes')}}</option>
                  <option value="0" {{ $sending_domain->is_active ? '' : 'selected' }}>{{ __('app.no') }}</option>
                </select>
              </div>
            </div>
            <div class="col-md-4">
              <div class="form-group">
                <label class="form-label fw-semibold">{{__('app.auto_verification')}}
                  <a tabindex="-1" role="button"
                  data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.auto_verification')}}"
                  data-bs-content="{{__('app.domain_auto_verfication_help')}}" data-bs-custom-class="header-primary" class="text-primary ms-1">
                    <i class="bi bi-question-circle"></i>
                  </a>
                </label>
                <select name="auto_verification" class="form-select">
                  <option value="0" {{ $sending_domain->auto_verification ? '' : 'selected' }}>{{ __('app.no')}}</option>
                  <option value="1" {{ $sending_domain->auto_verification ? 'selected' : '' }}>{{ __('app.yes') }}</option>
                </select>
              </div>
            </div>
          </div>

          <!-- DNS Setup Help Section -->
          <div class="row mb-4">
            <div class="col-12">
              <div class="alert alert-info d-flex align-items-center" role="alert">
                <i class="bi bi-info-circle me-2"></i>
                <div>{{__('app.dns_values_setup_help')}}</div>
              </div>
              <div class="alert alert-warning d-flex align-items-center" role="alert">
                <i class="bi bi-exclamation-triangle me-2"></i>
                <div>{{__('app.alert_keys_dns_values')}}</div>
              </div>
            </div>
          </div>

          <!-- Keys Section -->
          <div class="row mb-4">
            <div class="col-12">
              <div class="d-flex align-items-center">
                <div class="me-3">
                  <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                    <i class="bi bi-key"></i>
                  </span>
                </div>
                <h6 class="mb-0 text-info fw-semibold fs-14">{{__('app.keys')}}</h6>
                <a href="{{ route('download.keys', ['id' => $sending_domain->id]) }}" class="btn btn-outline-success btn-sm ms-auto">
                  <i class="bi bi-download me-1"></i>{{__('app.download')}}
                </a>
              </div>
            </div>
            <div class="col-md-6">
              <div class="form-group">
                <label class="form-label fw-semibold">{{__('app.public_key')}}</label>
                <textarea class="form-control" name="public_key" rows="4" placeholder="{{__('app.public_key')}}">{{$sending_domain->public_key}}</textarea>
              </div>
            </div>
            <div class="col-md-6">
              <div class="form-group">
                <label class="form-label fw-semibold">{{__('app.private_key')}}</label>
                <textarea class="form-control" name="private_key" rows="4" placeholder="{{__('app.private_key')}}">{{$sending_domain->private_key}}</textarea>
              </div>
            </div>
          </div>

          <!-- DNS Entries Section -->
          <div class="row mb-4">
            <div class="col-12">
              <div class="d-flex align-items-center mb-3">
                <div class="me-3">
                  <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                    <i class="bi bi-server"></i>
                  </span>
                </div>
                <h6 class="mb-0 text-info fw-semibold fs-14">{{__('app.dns_entries')}}</h6>
              </div>
              <div class="alert alert-light">
                {!! str_replace('[domain-name]', $sending_domain->domain , __('app.help_dns_entries')) !!}
              </div>
            </div>
          </div>

          <!-- DNS Records Table -->
          <div class="row mb-4">
            <div class="col-12">
              <div class="table-responsive">
                <table class="table table-bordered">
                  <thead class="table-light">
                    <tr>
                      <th class="fw-semibold">{{__('app.type')}}</th>
                      <th class="fw-semibold">{{__('app.host')}}</th>
                      <th class="fw-semibold">{{__('app.value')}}</th>
                      <th class="fw-semibold text-center">{{__('app.verified')}}</th>
                    </tr>
                  </thead>
                  <tbody>
                    <!-- DKIM Record -->
                    <tr>
                      <td><span class="badge bg-primary">TXT</span></td>
                      <td>
                        <div class="input-group">
                          <input type="text" class="form-control form-control-sm" name="host_dkim" value="{{$sending_domain->host_dkim}}">
                          <button class="btn btn-outline-secondary btn-sm" type="button" onclick="copyToClipboard(this)">
                            <i class="bi bi-copy"></i>
                          </button>
                        </div>
                      </td>
                      <td>
                        <div class="input-group">
                          <input type="text" class="form-control form-control-sm" name="value_dkim" value="{{$sending_domain->value_dkim}}">
                          <button class="btn btn-outline-secondary btn-sm" type="button" onclick="copyToClipboard(this)">
                            <i class="bi bi-copy"></i>
                          </button>
                        </div>
                      </td>
                      <td class="text-center">
                        <span id="key-{{$sending_domain->id}}" class="badge {{ $sending_domain->is_verified_key ? 'bg-success' : 'bg-danger' }}">
                          <i class="bi {{ $sending_domain->is_verified_key ? 'bi-check-lg' : 'bi-x-lg' }}"></i>
                        </span>
                      </td>
                    </tr>
                    <!-- SPF Record -->
                    <tr>
                      <td><span class="badge bg-primary">TXT</span></td>
                      <td>
                        <div class="input-group">
                          <input type="text" class="form-control form-control-sm" name="host_spf" value="{{$sending_domain->host_spf}}">
                          <button class="btn btn-outline-secondary btn-sm" type="button" onclick="copyToClipboard(this)">
                            <i class="bi bi-copy"></i>
                          </button>
                        </div>
                      </td>
                      <td>
                        <div class="input-group">
                          <input type="text" class="form-control form-control-sm" name="value_spf" value="{{$sending_domain->value_spf}}">
                          <button class="btn btn-outline-secondary btn-sm" type="button" onclick="copyToClipboard(this)">
                            <i class="bi bi-copy"></i>
                          </button>
                        </div>
                      </td>
                      <td class="text-center">
                        <span id="spf-{{$sending_domain->id}}" class="badge {{ $sending_domain->is_verified_spf ? 'bg-success' : 'bg-danger' }}">
                          <i class="bi {{ $sending_domain->is_verified_spf ? 'bi-check-lg' : 'bi-x-lg' }}"></i>
                        </span>
                      </td>
                    </tr>
                    <!-- DMARC Record -->
                    <tr>
                      <td><span class="badge bg-primary">TXT</span></td>
                      <td>
                        <div class="input-group">
                          <input type="text" class="form-control form-control-sm" name="host_dmarc" value="{{$sending_domain->host_dmarc}}">
                          <button class="btn btn-outline-secondary btn-sm" type="button" onclick="copyToClipboard(this)">
                            <i class="bi bi-copy"></i>
                          </button>
                        </div>
                      </td>
                      <td>
                        <div class="input-group">
                          <input type="text" class="form-control form-control-sm" name="value_dmarc" value="{{$sending_domain->value_dmarc}}">
                          <button class="btn btn-outline-secondary btn-sm" type="button" onclick="copyToClipboard(this)">
                            <i class="bi bi-copy"></i>
                          </button>
                        </div>
                      </td>
                      <td class="text-center">
                        <span id="dmarc-{{$sending_domain->id}}" class="badge {{ $sending_domain->is_verified_dmarc ? 'bg-success' : 'bg-danger' }}">
                          <i class="bi {{ $sending_domain->is_verified_dmarc ? 'bi-check-lg' : 'bi-x-lg' }}"></i>
                        </span>
                      </td>
                    </tr>
                  </tbody>
                </table>
              </div>
            </div>
          </div>

          <!-- Action Buttons -->
          <div class="row">
            <div class="col-12">
              <div class="d-flex gap-2">
                <button type="submit" class="btn btn-primary btn-loading">
                  <i class="bi bi-check-lg me-1"></i>{{__('app.update')}}
                </button>
                <button type="button" class="btn btn-info btn-loading" onclick="validateDomain('{{$sending_domain->id}}')">
                  <i class="bi bi-shield-check me-1"></i>{{__('app.validate')}}
                </button>
                <a href="{{route('sending_domains.index')}}" class="btn btn-light">
                  <i class="bi bi-arrow-left me-1"></i>{{__('app.cancel')}}
                </a>
              </div>
            </div>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>
@include('includes.modal')
@endsection
