@extends('layouts.app')
@section('title', $page_title)

{{-- Include global DataTable styling --}}
@include('components.datatable-styles')

@push('scripts')
<script src="{{asset('assets/js/sending_domain.js')}}"></script>
<script>
$(function () {
    // Handle Add Sending Domain button click with loading indicator
    $('#add-sending-domain-btn').on('click', function(e) {
        e.preventDefault();
        var $btn = $(this);
        var $icon = $btn.find('i');
        $icon.removeClass('bi-plus-circle').addClass('spinner-border spinner-border-sm');
        $.ajax({
            url: '{{route('sending_domains.create')}}', type: 'GET',
            success: function() {
                $icon.removeClass('spinner-border spinner-border-sm').addClass('bi-plus-circle');
                viewModal('modal', '{{route('sending_domains.create')}}');
            },
            error: function(xhr) {
                $icon.removeClass('spinner-border spinner-border-sm').addClass('bi-plus-circle');
                if (xhr.status === 401) { alert('You do not have permission to create sending domains. Please contact your administrator.'); }
                else if (xhr.status === 403) { alert('Access forbidden. You do not have the required permissions.'); }
                else { alert('An error occurred while trying to access the create sending domain page. Please try again.'); }
            }
        });
    });
});
</script>
@endpush
@section('content')
<div class="row">
    <div class="col-xl-12">
        <div class="card custom-card">
            <div class="card-body">
                <div class="table-responsive">
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <a href="javascript:;" class="btn btn-primary btn-loading" id="add-sending-domain-btn">
                                <i class="bi bi-plus-circle me-2"></i>{{__('app.add_new_sending_domain')}}
                            </a>
                        </div>
                        <div class="col-md-6 text-end">
                            <div class="btn-group">
                                <button type="button" class="btn btn-outline-primary dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                                    <i class="bi bi-gear me-1"></i>{{__('app.actions')}}
                                </button>
                                <ul class="dropdown-menu">
                                    <li><a class="dropdown-item" href="javascript:;" onclick="setStatusMany('{{ route('sending_domains.set_status') }}', '1')">
                                        <i class="bi bi-unlock me-2"></i>{{ __('app.active') }}
                                    </a></li>
                                    <li><a class="dropdown-item" href="javascript:;" onclick="setStatusMany('{{ route('sending_domains.set_status') }}', '0')">
                                        <i class="bi bi-lock me-2"></i>{{ __('app.inactive') }}
                                    </a></li>
                                    <li><a class="dropdown-item" href="javascript:;" onclick="destroyMany('{{ route('sending_domains.destroy', [0]) }}')">
                                        <i class="bi bi-trash me-2"></i>{{ __('app.delete') }}
                                    </a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <table id="data" class="table table-bordered text-nowrap w-100">
                        <thead>
                            <tr>
                                <th><input type="checkbox" id='checkAll' value="0" class="form-check-input"></th>
                                <th>{{ __('app.id') }}</th>
                                <th>{{ __('app.domain') }}</th>
                                <th>{{ __('app.group') }}</th>
                                <th>{{ __('app.active') }}</th>
                                <th>{{ __('app.dkim') }}</th>
                                <th>{{ __('app.spf') }}</th>
                                <th>{{ __('app.dmarc') }}</th>
                                <th>{{ __('app.created') }}</th>
                                <th>{{ __('app.actions') }}</th>
                            </tr>
                        </thead>
                         <tbody></tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<input type="hidden" id="route-group" value="{{ route('group.delete', ['model' => 'sending_domain']) }}">
<span id="route-sending-domains" data-route="{{ route('get.sending_domains') }}"></span>
<span id="route-group-edit" data-route="{{ route('groups.edit', 'group-id') }}"></span>
<span id="tooltip-group-edit" data-value="{{ __('app.tooltip_group_edit') }}"></span>
<span id="tooltip-group-delete-list" data-value="{{ __('app.tooltip_group_delete_sending_domain') }}"></span>
<span id="msg-group-delete-list" data-value="{{ __('app.msg_group_delete_sending_domain') }}"></span>
<span id="tooltip-group-eraser-list" data-value="{{ __('app.tooltip_group_eraser_sending_domain') }}"></span>
<span id="route-group-eraser-list" data-route="{{ route('group.delete', ['model' => 'sending_domain']) }}"></span>
<span id="msg-group-erase-list" data-value="{{ __('app.msg_group_eraser_sending_domain') }}"></span>
@include('groups.move')
@include('includes.datatables')
@endsection
