<script>
$(function(){
    'use strict';
    $('#copy-callback-url').click(function() {
        document.getElementById("callback-url").select();
        document.execCommand("copy");
        toastr.success('Copied successfully!');
    });
    $('#process-reports').change(function() {
        $('.div-webhook-url').toggle('slow');
    });
});
</script>
@if($type == 'smtp' || $type == 'gmail' || $type == 'microsoft')
<div class="col-md-12">
    <label class="form-label">{{ __('app.host') }}</label>
    <input type="text" class="form-control" name="host" value="{{ $action == 'edit' && !empty($data->host) ? $data->host : '' }}" placeholder="{{ __('app.host') }}" required>
</div>
<div class="col-md-12 mt-3">
    <label class="form-label">
        @if($type == 'gmail')
            {{ __('app.gmail_address') }}
        @else
            {{ __('app.username') }}
        @endif
    </label>
    <input type="text" class="form-control" name="username" value="{{ $action == 'edit' && !empty($data->username) ? $data->username : '' }}" placeholder="{{ __('app.username') }}" required>
</div>
<div class="col-md-12 mt-3">
    <label class="form-label">
        @if($type == 'gmail')
            {{ __('app.gmail_app_password') }}
        @else
            {{ __('app.password') }}
        @endif
    </label>
    <a tabindex="-1" href="javascript:void(0);" class="" onclick="createpassword('password',this)" id="button-addon2"><i class="ri-eye-off-line align-middle text-primary"></i></a>

    @if($type == 'gmail' || $type == 'microsoft')
    &nbsp;
    <a href="javascript:;" onclick="viewModal('modal', '{{ route('callback.help', [$type]) }}')"><i class="bi bi-info-circle text-primary"></i></a>
    @endif
    <input type="password" id="password" class="form-control" name="password" value="{{ $action == 'edit' && !empty($data->password) ? \Crypt::decrypt($data->password) : '' }}" placeholder="{{ __('app.password') }}" required>
</div>
<div class="col-md-12 mt-3">
    <label class="form-label">{{ __('app.port') }}</label>
    <input type="number" class="form-control" name="port" value="{{ $action == 'edit' && !empty($data->port) ? explode(',', $data->port)[0] : '' }}" min="1" placeholder="{{ __('app.port') }}" required>
</div>
<div class="col-md-12 mt-3">
    <label class="form-label">{{ __('app.encryption') }}</label>
    <select name="encryption" class="form-select form-select-lg">
        <option value="none" {{ $action == 'edit' && !empty($data->encryption) && $data->encryption == 'none' ? 'selected="selected"' : '' }}>{{ __('app.none') }}</option>
        <option value="ssl" {{ $action == 'edit' && !empty($data->encryption) &&  $data->encryption == 'ssl' ? 'selected="selected"' : '' }}>SSL</option>
        <option value="tls" {{ $action == 'edit' && !empty($data->encryption) &&  $data->encryption == 'tls' ? 'selected="selected"' : '' }}>TLS</option>
    </select>
</div>
@elseif($type == 'amazon_ses_api')
@php $section='amazon'; @endphp
<div class="col-md-12">
    <label class="form-label">{{ __('app.amazon_access_key') }}</label>
    <input type="text" class="form-control" name="access_key" value="{{ $action == 'edit' && !empty($data->access_key) ? $data->access_key : '' }}" min="1" placeholder="{{ __('app.amazon_access_key') }}" required>
</div>
<div class="col-md-12 mt-3">
    <label class="form-label">{{ __('app.amazon_secret_key') }}</label>
    <a tabindex="-1"  href="javascript:void(0);" class="" onclick="createpassword('secret_key',this)" id="button-addon2"><i class="ri-eye-off-line align-middle text-primary"></i></a>
    <input type="password" class="form-control" id="secret_key" name="secret_key" value="{{ $action == 'edit' && !empty($data->secret_key) ? \Crypt::decrypt($data->secret_key) : '' }}" placeholder="{{ __('app.amazon_secret_key') }}">
</div>
<div class="col-md-12 mt-3">
    <label class="form-label">{{ __('app.amazon_region') }}</label>
    <select name="region" class="form-select form-select-lg">
        @foreach(\App\Http\Helper\Helper::amazonRegions() as $region_key => $region)
        <option value="{{ $region_key }}" {{ $action == 'edit' && $data->region == $region_key ? 'selected="selected"' : '' }}>{{ $region }}</option>
        @endforeach
    </select>
</div>
@elseif($type == 'mailgun_api')
@php $section='mailgun'; @endphp
<!-- <div class="col-md-12">
    <label class="form-label">{{ __('app.mailgun_domain') }}</label>
    <input type="text" class="form-control" name="domain" value="{{ $action == 'edit' && !empty($data->domain) ? $data->domain : '' }}" placeholder="{{ __('app.mailgun_domain') }}">
</div> -->
<div class="col-md-12">
    <label class="form-label">{{ __('app.mailgun_api_key') }}</label>
    <a tabindex="-1"  href="javascript:void(0);" class="" onclick="createpassword('api_key',this)" id="button-addon2"><i class="ri-eye-off-line align-middle text-primary"></i></a>
    <input type="password" class="form-control" id="api_key" name="api_key" value="{{ $action == 'edit' && !empty($data->api_key) ? \Crypt::decrypt($data->api_key) : '' }}" placeholder="{{ __('app.mailgun_api_key') }}">
</div>

@elseif($type == 'sparkpost_api')
@php $section='sparkpost'; @endphp
<div class="col-md-12">
    <label class="form-label">{{ __('app.sparkpost_api_key') }}</label>
    <a tabindex="-1"  href="javascript:void(0);" class="" onclick="createpassword('api_key',this)" id="button-addon2"><i class="ri-eye-off-line align-middle text-primary"></i></a>
    <input type="password" class="form-control" id="api_key" name="api_key" value="{{ $action == 'edit' && !empty($data->api_key) ? \Crypt::decrypt($data->api_key) : '' }}" placeholder="{{ __('app.sparkpost_api_key') }}">
</div>
@elseif($type == 'sendgrid_api')
@php $section='sendgrid'; @endphp
<div class="col-md-12">
    <label class="form-label">{{ __('app.sendgrid_api_key') }}</label>
    <a tabindex="-1"  href="javascript:void(0);" class="" onclick="createpassword('api_key',this)" id="button-addon2"><i class="ri-eye-off-line align-middle text-primary"></i></a>
    <input type="password" class="form-control" id="api_key" name="api_key" value="{{ $action == 'edit' && !empty($data->api_key) ? \Crypt::decrypt($data->api_key) : '' }}" placeholder="{{ __('app.sendgrid_api_key') }}">
</div>
@elseif($type == 'elastic_email_api')
@php $section='elasticemail'; @endphp
<div class="col-md-12">
    <label class="form-label">{{ __('app.elastic_email_api_key') }}</label>
    <a tabindex="-1"  href="javascript:void(0);" class="" onclick="createpassword('api_key',this)" id="button-addon2"><i class="ri-eye-off-line align-middle text-primary"></i></a>
    <input type="password" class="form-control" id="api_key" name="api_key" value="{{ $action == 'edit' && !empty($data->api_key) ? \Crypt::decrypt($data->api_key) : '' }}" placeholder="{{ __('app.elastic_email_api_key') }}">
</div>
@elseif($type == 'postal_api')
@php $section='postal'; @endphp
<div class="col-md-12">
    <label class="form-label">{{ __('app.postal_server_url') }}</label>
    <input type="text" class="form-control" placeholder="https://example.com" name="postal_server_url" value="{{$data->postal_server_url ?? ''}}">
</div>
<div class="col-md-12 mt-3">
    <label class="form-label">{{ __('app.postal_api_key') }}</label>
    <a tabindex="-1"  href="javascript:void(0);" class="" onclick="createpassword('api_key',this)" id="button-addon2"><i class="ri-eye-off-line align-middle text-primary"></i></a>
    <input type="password" class="form-control" id="api_key" name="api_key" value="{{ $action == 'edit' && !empty($data->api_key) ? \Crypt::decrypt($data->api_key) : '' }}" placeholder="{{ __('app.postal_api_key') }}">
</div>
@endif


@if($type == 'mailgun_api' || $type == 'sendgrid_api' || $type == 'sparkpost_api' || $type == 'amazon_ses_api' || $type == 'elastic_email_api' || $type == 'postal_api')
<div class="col-md-12 mt-3 process-reports-div">
    <label class="form-label">{{ __('app.process_reports') }}</label>
    <select name="process_reports" id="process-reports" class="form-select" >
        <option value="no" {{ $action == 'edit' && !empty($data->process_reports) && $data->process_reports == 'no' ? 'selected="selected"' : '' }}>{{ __('app.no') }}</option>
        <option value="yes" {{ $action == 'edit' && !empty($data->process_reports) && $data->process_reports == 'yes' ? 'selected="selected"' : '' }}>{{ __('app.yes') }}</option>
    </select>
</div>
@endif

@if($type == 'mailgun_api' || $type == 'sendgrid_api' || $type == 'sparkpost_api' || $type == 'elastic_email_api' || $type == 'postal_api' || $type == 'amazon_ses_api')
<div class="form-group div-webhook-url mt-3" style="{{ $action == 'edit' && !empty($data->process_reports) && $data->process_reports == 'yes' ? '' : 'display:none' }}">
    <label class="form-label">{{ __('app.webhook_url') }}</label>
    <div class="input-group">
        <input type="text" class="form-control" name="callback_url" id="callback-url" value="{{\App\Http\Helper\Helper::getAppURL()}}/callback/{{$section}}" readonly="readonly">
        <div class="input-group-text">
            <a href="javascript:;" id="copy-callback-url"><i class="bi bi-copy"></i></a>
        </div>
        <div class="input-group-text">
            <a href="javascript:;" onclick="viewModal('modal', '{{ route('callback.help', [$section]) }}')"><i class="bi bi-info-square"></i></a>
        </div>
    </div>
</div>
@endif

@if($type == 'amazon_ses_api')
<div class="form-group div-webhook-url mt-3" style="{{ $action == 'edit' && !empty($data->process_reports) && $data->process_reports == 'yes' ? '' : 'display:none' }}">
    <label class="form-label">{{ __('app.amazon_configuration_set') }}</label>
    <div class="input-group">
        <input type="text" class="form-control" name="amazon_configuration_set" value="{{$data->amazon_configuration_set ?? ''}}">
        <div class="input-group-text">
            <a href="javascript:;" onclick="viewModal('modal', '{{ route('callback.help', [$section]) }}')"><i class="bi bi-info-square"></i></a>
        </div>
    </div>
</div>
@endif
