@extends('layouts.app')
@section('title', $page_title)

@section('styles')
<style type="text/css">
  .modal-body {
    overflow: scroll !important;
   }
   .select2-container {
    z-index: 1040 !important;
   }

  .input-group > .select2-container {
    flex: 1 1 auto;
    width: auto !important;
  }
  #from_email_part1 {
    height: 100%;
  }

  /* Group dropdown styling */
  .select2-container { z-index: 1040 !important; }
  .select2-dropdown { max-height: 300px; overflow-y: auto; z-index: 1040 !important; position: absolute !important; }
  .select2-results__options { max-height: 250px; overflow-y: auto; }
  .select2-results__option { padding: 8px 12px; font-size: 14px; }
  .select2-results__option--highlighted { background-color: #007bff; color: white; }
  .select2-container--default .select2-results > .select2-results__options { max-height: 250px; overflow-y: auto; }
  .select2-dropdown--below { z-index: 1040 !important; }
  .form-group { overflow: visible !important; }
  .col-md-4 { overflow: visible !important; }
}
</style>
@endsection

@push('scripts')
<script type="text/javascript">
  $(document).ready(function() {
    $('#type').select2();
    $('#sending-domains').select2();
    $('#bounce-id').select2();
    $('select[name="tracking_domain"]').select2();
    
    // Initialize Select2 for group dropdown
    $('#group_id').select2({
      placeholder: '{{__("app.select_group")}}',
      allowClear: false,
      width: '100%',
      dropdownParent: $('body')
    });
  });
</script>
@endpush

@section('content')
<div class="row">
  <div class="col-12">
    <div class="card custom-card">
      <div class="card-body">
        <form method="POST" action="{{ route('sending_servers.store') }}" class="needs-validation" novalidate>
          @csrf
          
          <!-- General Information Section -->
          <div class="row mb-3 m">
            
            <div class="col-md-4">
              <div class="form-group">
                <label class="form-label fw-semibold">{{__('app.group')}}
                  <a href="javascript:;" onclick="viewModal('modal', '{{route('group.create', ['type_id' => config('custom.group_sending_servers')])}}');" class="text-primary ms-1">
                    <i class="bi bi-plus-circle"></i>
                  </a>
                </label>
                <select name="group_id" class="form-select" id="group_id" required>
                  <option value="">{{__('app.select_group')}}</option>
                  @foreach($groups as $id => $group_name)
                  <option value="{{ $id }}" {{ old('group_id') == $id ? 'selected' : '' }}>{{$group_name}}</option>
                  @endforeach
                </select>
                <div class="invalid-feedback">{{ __('app.select_group_error')}}</div>
              </div>
            </div>
            
            <div class="col-md-2">
              <div class="form-group">
                <label class="form-label fw-semibold">{{__('app.status')}}</label>
                <select name="status" class="form-select form-select-lg" required>
                  <option value="Active" {{ old('status', 'Active') == 'Active' ? 'selected' : '' }}>{{ __('app.active')}}</option>
                  <option value="Inactive" {{ old('status') == 'Inactive' ? 'selected' : '' }}>{{ __('app.in_active') }}</option>
                </select>
                <div class="invalid-feedback">{{__('app.status_required')}}</div>
              </div>
            </div>
            
            <div class="col-md-6">
              <div class="form-group">
                <label class="form-label fw-semibold">{{__('app.name')}}</label>
                <input type="text" class="form-control" placeholder="{{__('app.name')}}" value="{{ old('name') }}" name="name" required>
                <div class="invalid-feedback">{{__('app.name_required')}}</div>
              </div>
            </div>
            
            <div class="col-12 mt-3">
              <div class="form-group">
                <label class="form-label fw-semibold">{{__('app.detail')}}</label>
                <textarea class="form-control" placeholder="{{__('app.detail')}}" rows="3" name="detail">{{ old('detail') }}</textarea>
              </div>
            </div>
          </div>

          <!-- Delivery Server Configuration Section -->
          <div class="row mb-3">
            <div class="col-12">
              <div class="d-flex align-items-center">
                <div class="me-3">
                  <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                    <i class="bi bi-server"></i>
                  </span>
                </div>
                <h6 class="mb-0 text-info fw-semibold fs-14">{{__('app.delivery_server')}}
                  <a tabindex="-1" role="button"
                  data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.delivery_server')}}"
                  data-bs-content="{{__('app.delivery_server_type_help')}}" data-bs-custom-class="header-primary" class="text-primary ms-1">
                    <i class="bi bi-question-circle"></i>
                  </a>
                </h6>
              </div>
            </div>
            
            <div class="col-12 mb-3 mt-3">
              <div class="form-group">
                <select name="type" id="type" class="single-select form-select" required>
                  @foreach(\App\Http\Helper\Helper::sendingServers() as $type => $value)
                    <option value="{{ $type }}">{{ $value }}</option>
                  @endforeach
                </select>
                <div class="invalid-feedback">{{__('app.server_type_required')}}</div>
              </div>
            </div>
            
            <div id="sending-attributes"></div>
          </div>

          <!-- Sender Information Section -->
          <div class="row mb-3">
            <div class="col-12">
              <div class="d-flex align-items-center">
                <div class="me-3">
                  <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                    <i class="bi bi-person-gear"></i>
                  </span>
                </div>
                <h6 class=" text-info fw-semibold fs-14">{{__('app.from_detail')}}
                  <a tabindex="-1" role="button"
                  data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.from_detail')}}"
                  data-bs-content="{{__('app.delivery_server_from_detail_help')}}" data-bs-custom-class="header-primary" class="text-primary ms-1">
                    <i class="bi bi-question-circle"></i>
                  </a>
                </h6>
              </div>
            </div>
            
            <div class="col-md-3 mt-3">
              <div class="form-group">
                <label class="form-label fw-semibold">{{__('app.from_name')}}</label>
                <input type="text" class="form-control" placeholder="{{__('app.from_name')}}" value="{{ old('from_name') }}" name="from_name" required>
                <div class="invalid-feedback">{{__('app.from_name_required')}}</div>
              </div>
            </div>
            
            <div class="col-md-6 mt-3">
              <div class="form-group">
                <label class="form-label fw-semibold">{{__('app.from_email')}}
                  <a href="{{route('sending_domains.index')}}" class="text-primary ms-1">
                    <i class="bi bi-plus-circle"></i>
                  </a>
                </label>
                <div class="input-group">
                  <div style="width: 35%;">
                    <input type="text" name="from_email_part1" id="from_email_part1" class="form-control" placeholder="{{__('app.from_email_example')}}" value="{{ old('from_email_part1') }}" required>
                  </div>
                  <span class="input-group-text">@</span>
                  <select name="from_email_part2" id="sending-domains" class="single-select form-select" required>
                    <option value="">{{__('app.select_domain')}}</option>
                    @foreach($sending_domains as $sending_domain)
                      <option value="{{ $sending_domain->domain }}" {{ old('from_email_part2') == $sending_domain->domain ? 'selected' : '' }}>{{ $sending_domain->domain }}</option>
                    @endforeach
                  </select>
                </div>
                <div class="invalid-feedback">{{__('app.from_email_required')}}</div>
              </div>
            </div>
            
            <div class="col-md-3 mt-3">
              <div class="form-group">
                <label class="form-label fw-semibold">{{__('app.reply_email')}}</label>
                <input type="email" class="form-control" placeholder="{{__('app.reply_email')}}" value="{{ old('reply_email') }}" name="reply_email" required>
                <div class="invalid-feedback">{{__('app.reply_email_required')}}</div>
              </div>
            </div>
          </div>

          <!-- Additional Configuration Section -->
          <div class="row mb-3">
            <div class="col-12 mb-3">
              <div class="d-flex align-items-center">
                <div class="me-3">
                  <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                    <i class="bi bi-gear"></i>
                  </span>
                </div>
                <h6 class="mb-0 text-info fw-semibold fs-14">{{__('app.other_detail')}}</h6>
              </div>
            </div>
            
            <div class="col-md-6">
              <div class="form-group">
                <label class="form-label fw-semibold">{{__('app.bounce_email')}}
                  <a href="{{route('bounces.create')}}" class="text-primary ms-1">
                    <i class="bi bi-plus-circle"></i>
                  </a>
                  <a tabindex="-1" role="button"
                  data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.bounce_email')}}"
                  data-bs-content="{{__('app.delivery_server_bounce_email_help')}}" data-bs-custom-class="header-primary" class="text-primary ms-1">
                    <i class="bi bi-question-circle"></i>
                  </a>
                </label>
                <select name="bounce_id" id="bounce-id" class="form-select">
                  <option value="0">{{ __('app.none') }}</option>
                  @foreach($bounces as $bounce)
                    <option value="{{ $bounce->id }}">{{ $bounce->email }}</option>
                  @endforeach
                </select>
              </div>
            </div>
            
            <div class="col-md-6">
              <div class="form-group">
                <label class="form-label fw-semibold">{{__('app.tracking_domain')}}
                  <a href="{{route('tracking_domains.index')}}" class="text-primary ms-1">
                    <i class="bi bi-plus-circle"></i>
                  </a>
                  <a tabindex="-1" role="button"
                  data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.tracking_domain')}}"
                  data-bs-content="{{__('app.delivery_server_tracking_domain_help')}}" data-bs-custom-class="header-primary" class="text-primary ms-1">
                    <i class="bi bi-question-circle"></i>
                  </a>
                </label>
                <select name="tracking_domain" class="form-select">
                  <option value="{{\App\Http\Helper\Helper::getAppURL()}}">{{\App\Http\Helper\Helper::getAppURL()}}</option>
                  @foreach($tracking_domains as $tracking_domain)
                    <option value="{{ $tracking_domain->protocol }}{{ $tracking_domain->domain }}">{{ $tracking_domain->protocol }}{{ $tracking_domain->domain }}</option>
                  @endforeach
                </select>
              </div>
            </div>
          </div>

          <!-- Speed Configuration Section -->
          <div class="row mb-3">
            <div class="col-12 mb-3">
              <div class="d-flex align-items-center">
                <div class="me-3">
                  <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                    <i class="bi bi-speedometer2"></i>
                  </span>
                </div>
                <h6 class="mb-0 text-info fw-semibold fs-14">{{__('app.sending_speed')}}
                  <a tabindex="-1" role="button"
                  data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.sending_speed')}}"
                  data-bs-content="{{__('app.delivery_server_sending_speed_help')}}" data-bs-custom-class="header-primary" class="text-primary ms-1">
                    <i class="bi bi-question-circle"></i>
                  </a>
                </h6>
              </div>
            </div>
            
            <div class="col-12">
              <div class="form-group">
                <select name="speed" id="speed_sending_server" class="form-select" required>
                  <option value="unlimited">{{ __('app.unlimited') }}</option>
                  <option value="limited">{{ __('app.limited') }}</option>
                  @if(count($warmup_plans) > 0)
                    <option value="warmup">{{ __('app.warmup_plan') }}</option>
                  @endif
                </select>
                <div class="invalid-feedback">{{__('app.speed_required')}}</div>
              </div>
            </div>

            <div class="col-12 mt-3" id="speed-attributes" style="display: none;">
              <div class="row">
                <div class="col-md-6">
                  <div class="form-group">
                    <label class="form-label fw-semibold">{{__('app.limit')}}</label>
                    <input type="number" class="form-control" name="limit" value="100" min="1">
                    <div class="invalid-feedback">{{__('app.limit_required')}}</div>
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="form-group">
                    <label class="form-label fw-semibold">{{__('app.duration')}}</label>
                    <select name="duration" class="form-select form-select-lg">
                      <option value="hourly">{{ __('app.hourly') }}</option>
                      <option value="daily">{{ __('app.daily') }}</option>
                    </select>
                    <div class="invalid-feedback">{{__('app.duration_required')}}</div>
                  </div>
                </div>
              </div>
            </div>

            <div class="col-12 mt-3" id="warmup-plan" style="display: none;">
              <div class="form-group">
                <label class="form-label fw-semibold">{{__('app.warmup_plan')}}</label>
                <select name="warmup_plan" class="form-select">
                  @foreach($warmup_plans as $plan)
                    <option value="{{ $plan->id }}">{{ $plan->name }}</option>
                  @endforeach
                </select>
                <div class="invalid-feedback">{{__('app.warmup_plan_required')}}</div>
              </div>
            </div>
          </div>

          <!-- Action Buttons -->
          <div class="row">
            <div class="col-12">
              <div class="d-flex gap-2 justify-content-start">
                <button type="submit" name="save_continue" value="1" class="btn btn-primary">
                  <i class="bi bi-save me-1"></i>{{__('app.save_continue')}}
                </button>
                <button type="submit" name="save_exit" value="1" class="btn btn-success">
                  <i class="bi bi-check-lg me-1"></i>{{__('app.save_exit')}}
                </button>
                <button type="submit" name="save_validate" value="1" class="btn btn-info">
                  <i class="bi bi-check-circle me-1"></i>{{__('app.save_validate')}}
                </button>
                <a href="{{route('sending_servers.index')}}" class="btn btn-light">
                  <i class="bi bi-arrow-left me-1"></i>{{__('app.cancel')}}
                </a>
              </div>
            </div>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>
@include('includes.modal')
@endsection
