@extends('layouts.app')
@section('title', $page_title)

{{-- Include global DataTable styling --}}
@include('components.datatable-styles')

@push('scripts')
<script src="{{asset('assets/js/sending_server.js')}}"></script>
@endpush

@section('content')
<div class="row">
    <div class="col-xl-12">
        <div class="card custom-card">
            <div class="card-body">
                <div class="table-responsive">
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <a href="{{route('sending_servers.create')}}" class="btn btn-primary btn-loading" id="add-sending-server-btn">
                                <i class="bi bi-plus-circle me-2"></i>{{__('app.add_new_delivery_server')}}
                            </a>
                        </div>
                        <div class="col-md-6 text-end">
                            <div class="btn-group">
                                <button type="button" class="btn btn-outline-primary dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                                    <i class="bi bi-gear me-1"></i>{{__('app.actions')}}
                                </button>
                                <ul class="dropdown-menu">
                                    <li><a class="dropdown-item" href="javascript:;" onclick="setStatusMany('{{ route('sending_servers.set_status') }}', 'Active')">
                                        <i class="bi bi-unlock me-2"></i>{{ __('app.active') }}
                                    </a></li>
                                    <li><a class="dropdown-item" href="javascript:;" onclick="setStatusMany('{{ route('sending_servers.set_status') }}', 'Inactive')">
                                        <i class="bi bi-lock me-2"></i>{{ __('app.inactive') }}
                                    </a></li>
                                    <li><a class="dropdown-item text-danger" href="javascript:;" onclick="destroyMany('{{ route('sending_servers.destroy', [0]) }}')">
                                        <i class="bi bi-trash me-2"></i>{{ __('app.delete') }}
                                    </a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <table id="data" class="table table-bordered text-nowrap w-100">
                        <thead>
                            <tr>
                                <th><input type="checkbox" id='checkAll' value="0" class="form-check-input"></th>
                                <th>{{ __('app.id') }}</th>
                                <th>{{ __('app.name') }}</th>
                                <th>{{ __('app.group') }}</th>
                                <th>{{ __('app.type') }}</th>
                                <th>{{ __('app.speed') }}</th>
                                <th>{{ __('app.sent') }}</th>
                                <th>{{ __('app.status') }}</th>
                                <th>{{ __('app.created') }}</th>
                                <th>{{ __('app.actions') }}</th>
                            </tr>
                        </thead>
                         <tbody></tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<input type="hidden" id="route-group" value="{{ route('group.delete', ['model' => 'sending_server']) }}">
<span id="route-sending-server" data-route="{{ route('get.sending_servers') }}"></span>
<span id="route-group-edit" data-route="{{ route('groups.edit', 'group-id') }}"></span>
<span id="tooltip-group-edit" data-value="{{ __('app.tooltip_group_edit') }}"></span>
<span id="tooltip-group-delete-list" data-value="{{ __('app.tooltip_group_delete_sending_server') }}"></span>
<span id="msg-group-delete-list" data-value="{{ __('app.msg_group_delete_sending_server') }}"></span>
<span id="tooltip-group-eraser-list" data-value="{{ __('app.tooltip_group_eraser_sending_server') }}"></span>
<span id="route-group-eraser-list" data-route="{{ route('group.delete', ['model' => 'sending_server']) }}"></span>
<span id="msg-group-erase-list" data-value="{{ __('app.msg_group_eraser_sending_server') }}"></span>
@include('groups.move')
@include('includes.datatables')
@endsection
