@extends('layouts.app')
@section('title', $page_title)

{{-- Include global DataTable styling --}}
@include('components.datatable-styles')

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card custom-card">
            <div class="card-body">
                <!-- Page Header -->
                <div class="row mb-4">
                    <div class="col-12">
                        <div class="d-flex align-items-center">
                            <div class="me-3">
                              <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                                    <i class="bi bi-key"></i>
                                </span>
                            </div>
                            <div>
                                <h6 class="mb-0 text-info fw-semibold fs-14">{{ __('app.api_settings') }}</h6>
                                <p class="mb-0 fs-12">{{ __('app.api_settings_description') }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <form id="frm-api" action="{{ route('api') }}" method="post" class="needs-validation" novalidate>
                    @csrf
                    @method('PUT')
                    <!-- API Configuration Section -->
                    <div class="row mb-4">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label fw-semibold">{{__('app.status')}} <span class="text-danger">*</span></label>
                                <select class="form-select" name="api_enabled" id="api-status" required>
                                    <option value="1" {{ $user->api_enabled ? 'selected' : ''}}>{{__('app.active')}}</option>
                                    <option value="0" {{ !$user->api_enabled ? 'selected' : ''}}>{{__('app.in_active')}}</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label fw-semibold">{{__('app.api_base_url')}}</label>
                                <div class="input-group">
                                    <input type="text" class="form-control" value="{{ \App\Http\Helper\Helper::getAppURL() }}/api/v1" id="api-base-url" readonly="readonly">
                                    <div class="input-group-text">
                                        <a href="javascript:;" tabindex="-1" title="{{__('app.copy')}}"><i class="bi bi-copy text-primary" id="copy-api-url"></i></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- API Key Section -->
                    <div class="row mb-4">
                        <div class="col-12">
                            <div class="form-group">
                                <label class="form-label fw-semibold">{{__('app.api_key')}}</label>
                                <div class="input-group">
                                    <input type="text" class="form-control" name="api_key" id="api-key" value="{{ $user->api_token }}" readonly="readonly">
                                    <div class="input-group-text">
                                        <a href="javascript:;" tabindex="-1" title="{{__('app.copy')}}"><i class="bi bi-copy text-primary" id="copy-api-key"></i></a>
                                    </div>
                                    <div class="input-group-text">
                                        <a href="javascript:;" tabindex="-1" title="{{__('app.regenerate')}}"><i class="bi bi-arrow-clockwise text-primary" id="regenerate-api-key"></i></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Documentation Section -->
                    <div class="row mb-4">
                        <div class="col-12">
                            <div class="alert alert-info">
                                <div class="d-flex align-items-center">
                                    <i class="bi bi-info-circle me-2"></i>
                                    <div>
                                        <strong>{{__('app.api_documentation')}}</strong>
                                        <div class="mt-1">{!!__('app.api_documentaion_url')!!}</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Action Buttons -->
                    <div class="row mt-4">
                        <div class="col-12">
                            <div class="d-flex gap-2">
                                <button type="submit" class="btn btn-primary btn-loading">
                                    <i class="bi bi-check-circle me-1"></i>{{__('app.update')}}
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<span id="api_msg_regenerate" data-value="{{__('app.api_msg_regenerate')}}"></span>
@endsection
