@extends('layouts.app')
@section('title', $page_title)

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card custom-card">
            <div class="card-body">
                <!-- Page Header -->
                <div class="row mb-4">
                    <div class="col-12">
                        <div class="d-flex align-items-center">
                            <div class="me-3">
                              <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                                    <i class="bi bi-robot"></i>
                                </span>
                            </div>
                            <div>
                                <h6 class="mb-0 text-info fw-semibold fs-14">{{ __('app.chatgpt_settings') }}</h6>
                                <p class="mb-0 fs-12">{{ __('app.chatgpt_settings_description') }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <form id="frm-api" action="{{ route('chatGPT.settings') }}" method="post" class="needs-validation" novalidate>
                    @csrf
                    @method('PUT')
                    <!-- ChatGPT Configuration Section -->
                    <div class="row mb-4">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label fw-semibold">{{__('app.status')}} <span class="text-danger">*</span></label>
                                <select class="form-select" name="chatgpt_enabled" required>
                                    <option value="1" {{ $user->chatgpt_enabled ? 'selected' : ''}}>{{__('app.active')}}</option>
                                    <option value="0" {{ !$user->chatgpt_enabled ? 'selected' : ''}}>{{__('app.in_active')}}</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label fw-semibold">{{__('app.chatGPT_model')}} <span class="text-danger">*</span></label>
                                <select class="form-select" name="chatgpt_model" required>
                                    @foreach(\App\Http\Helper\Helper::chatGPTModles() as $model)
                                    <option value="{{$model}}" {{ $user->chatgpt_model == $model ? 'selected' : ''}}>{{$model}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <!-- API Key Section -->
                    <div class="row mb-4">
                        <div class="col-12">
                            <div class="form-group">
                                <label class="form-label fw-semibold">{{__('app.chatGPT_key')}} <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <input type="text" class="form-control" name="chatgpt_key" value="{{ $user->chatgpt_key }}" required>
                                    <div class="input-group-text">
                                        <i class="bi bi-key"></i>
                                    </div>
                                </div>
                                <div class="form-text">{{__('app.chatgpt_key_help')}}</div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Action Buttons -->
                    <div class="row mt-4">
                        <div class="col-12">
                            <div class="d-flex gap-2">
                                <button type="submit" class="btn btn-primary btn-loading">
                                    <i class="bi bi-check-circle me-1"></i>{{__('app.update')}}
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<span id="api_msg_regenerate" data-value="{{__('app.api_msg_regenerate')}}"></span>
@endsection
