@extends('layouts.app')
@section('title', $page_title)

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card custom-card">
            <div class="card-body">
                <!-- Page Header -->
                <div class="row mb-4">
                    <div class="col-12">
                        <div class="d-flex align-items-center">
                            <div class="me-3">
                              <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                                    <i class="bi bi-gear"></i>
                                </span>
                            </div>
                            <div>
                                <h6 class="mb-0 text-info fw-semibold fs-14">{{ __('app.general_settings') }}</h6>
                                <p class="mb-0 fs-12">{{ __('app.general_settings_description') }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <form id="frm-general" action="{{ route('general.settings') }}" method="post" class="needs-validation" novalidate>
                    @csrf
                    @method('PUT')
                    <!-- General Configuration Section -->
                    <div class="row mb-4">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label fw-semibold">{{__('app.unsubscribed_mark_as_suppressed')}} <span class="text-danger">*</span></label>
                                <select class="form-select" name="unsubscribed_mark_as_suppressed" required>
                                    <option value="1" {{ isset($user->unsubscribed_mark_as_suppressed) && $user->unsubscribed_mark_as_suppressed ? 'selected' : ''}}>{{__('app.yes')}}</option>
                                    <option value="0" {{ !isset($user->unsubscribed_mark_as_suppressed) || !$user->unsubscribed_mark_as_suppressed ? 'selected' : ''}}>{{__('app.no')}}</option>
                                </select>
                                <div class="form-text">{{__('app.unsubscribed_mark_as_suppressed_help')}}</div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Action Buttons -->
                    <div class="row mt-4">
                        <div class="col-12">
                            <div class="d-flex gap-2">
                                <button type="submit" class="btn btn-primary btn-loading">
                                    <i class="bi bi-check-circle me-1"></i>{{__('app.update')}}
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

