@extends('layouts.app')
@section('title', $page_title)

{{-- Include global DataTable styling --}}
@include('components.datatable-styles')

@push('scripts')
<script>
loadSendingServerAttributes($("#type").val(), 'edit',0);
$(document).ready(function() {
   $('#type').select2();
});
</script>
@endpush

@section('styles')
<style type="text/css">
   .div-webhook-url,.process-reports-div{
      display: none !important;
   }
   .select2-container {
    z-index: 10 !important;
   }
</style>
@endsection

@section('content')
<div class="row">
    <div class="col-12">
        <div class="card custom-card">
            <div class="card-body">
                <!-- Page Header -->
                <div class="row mb-4">
                    <div class="col-12">
                        <div class="d-flex align-items-center">
                            <div class="me-3">
                              <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                                    <i class="bi bi-gear"></i>
                                </span>
                            </div>
                            <div>
                                <h6 class="mb-0 text-info fw-semibold fs-14">{{ __('app.application_settings') }}</h6>
                                <p class="mb-0 fs-12">{{ __('app.application_settings_description') }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <ul class="nav nav-pills mb-4" id="pills-tab" role="tablist">
                    <li class="nav-item" role="presentation">
                        <button class="nav-link active" id="pills-general-tab" data-bs-toggle="pill" data-bs-target="#pills-general" type="button" role="tab" aria-controls="pills-general" aria-selected="true">
                            <i class="bi bi-gear me-2"></i>{{__('app.general')}}
                        </button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="pills-mail-tab" data-bs-toggle="pill" data-bs-target="#pills-mail" type="button" role="tab" aria-controls="pills-mail" aria-selected="false">
                            <i class="bi bi-envelope me-2"></i>{{__('app.mail')}}
                            @if(empty($settings->from_name) || empty($settings->from_email))
                            <span class="text-danger">*</span>
                            @endif
                        </button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="pills-tracking-tab" data-bs-toggle="pill" data-bs-target="#pills-tracking" type="button" role="tab" aria-controls="pills-tracking" aria-selected="false">
                            <i class="bi bi-graph-up me-2"></i>{{__('app.tracking')}}
                        </button>
                    </li>
                </ul>

                <form method="POST" action="{{ route('settings.update', config('custom.app_id')) }}" class="needs-validation" novalidate enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    
                    <div class="tab-content" id="pills-tabContent">
                        <div class="tab-pane fade show active" id="pills-general" role="tabpanel" aria-labelledby="pills-general-tab">
                        
                        <div class="row mb-4">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="form-label fw-semibold">{{__('app.application_cron')}} 
                                        <i class='bi bi-copy text-primary' onclick="copyShortcode('{{ \App\Http\Helper\Helper::getCronCommand() }}')" style="cursor: pointer !important;" title="{{__('app.copy')}}"></i>
                                    </label>
                                    <input type="text" class="form-control" value="{{ \App\Http\Helper\Helper::getCronCommand() }}" id="shortcode-textbox" readonly>
                                </div>
                            </div>
                        </div>
                        <div class="row mb-4">
                        <div class="col-md-12">
                                <div class="form-group">
                                    <label class="form-label fw-semibold">{{__('app.app_name')}} <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" placeholder="{{__('app.app_name')}}"
                                    aria-label="{{__('app.app_name')}}" value="{{ $settings->app_name ?? '' }}" name="app_name" required>
                                </div>
                            </div>
                        </div>
                        
                        
                        <div class="row mb-4">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label fw-semibold">{{__('app.app_url')}} <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" placeholder="{{__('app.app_url')}}" value="{{ $settings->app_url ?? '' }}" name="app_url" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label fw-semibold">{{__('app.license_key')}}</label>
                                    <input type="text" class="form-control" value="{{ $settings->license_key ?? '' }}" readonly>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row mb-4">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label fw-semibold">{{__('app.server_ip')}}</label>
                                    <input type="text" class="form-control" value="{{$_SERVER['SERVER_ADDR']}}" readonly>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label fw-semibold">{{__('app.application_version')}}</label>
                                    <input type="text" class="form-control" value="{{ $settings->current_version ?? '' }}" readonly>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row mb-4">
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label fw-semibold">{{__('app.activity_log_retention')}}
                                        <a tabindex="-1" role="button"
                                        data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.activity_log_retention')}}"
                                        data-bs-content="{{__('app.activity_log_retention_help')}}" data-bs-custom-class="header-primary">
                                            <i class="bi bi-question-circle text-primary"></i>
                                        </a>
                                    </label>
                                    <div class="input-group">
                                        <input type="number" class="form-control" name="activity_log_retention" value="{{ json_decode($settings->attributes)->activity_log_retention ?? config('custom.activity_log_retention') }}" min="1" required>
                                        <div class="input-group-text">
                                            <a href="javascript:;" tabindex="-1"><i>{{__('app.days')}}</i></a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="form-label fw-semibold">{!! \App\Http\Helper\Helper::getMaxFileSize() !!}</label>
                                    <div class="input-group">                     
                                        <input type="number" class="form-control" name="max_allowed_file_size" value="{{ json_decode($settings->attributes)->max_file_size ?? '2'}}" min="1" required>
                                        <div class="input-group-text">
                                            <a href="javascript:;" tabindex="-1"><i>MB</i></a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- File Upload Section -->
                        <div class="row">
                            <div class="col-12">
                                <div class="d-flex align-items-center mb-3">
                                    <div class="me-3">
                                      <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                                            <i class="bi bi-image"></i>
                                        </span>
                                    </div>
                                    <h6 class="mb-0 text-info fw-semibold fs-14">{{ __('app.file_uploads') }}</h6>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row mb-4">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-label fw-semibold">{{__('app.login_page_logo')}} <small>(.png)</small></label>
                                    <input class="form-control" name="file_login_page_logo" type="file" id="file">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-label fw-semibold">{{__('app.application_logo')}} <small>(.png)</small></label>
                                    <input class="form-control" name="file_application_logo" type="file" id="file">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-label fw-semibold">{{__('app.favicon')}} <small>(.ico) (50x50)</small></label>
                                    <input class="form-control" name="file_favicon" type="file" id="file">
                                </div>
                            </div>
                        </div>
                        </div>
                        
                        <div class="tab-pane fade" id="pills-mail" role="tabpanel" aria-labelledby="pills-mail-tab">
                            
                            <div class="row mb-4">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label class="form-label fw-semibold">{{__('app.delivery_server')}}
                                            <a tabindex="-1" role="button"
                                            data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="bottom" title="{{__('app.delivery_server')}}"
                                            data-bs-content="{{__('app.delivery_server_setting_help')}}" data-bs-custom-class="header-primary">
                                                <i class="bi bi-question-circle text-primary"></i>
                                            </a>
                                        </label>
                                        <select name="type" id="type" class="single-select form-control">
                                            @foreach(\App\Http\Helper\Helper::sendingServers() as $type => $value)
                                            <option value="{{ $type }}" {{ $type == $settings->sending_type ? 'selected="selected"' : '' }}>{{ $value }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row mb-4">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-label fw-semibold">{{__('app.from_name')}} <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" placeholder="{{__('app.from_name')}}" value="{{ $settings->from_name ?? '' }}" name="from_name" required>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="form-label fw-semibold">{{__('app.from_email')}} <span class="text-danger">*</span>
                                            <a href="{{route('sending_domains.index')}}" tabindex="-1">
                                                <i class="bi bi-plus-circle text-primary"></i>
                                            </a>
                                        </label>
                                        <div class="input-group">
                                            <div style="width: 35%;">
                                                <input type="text" name="from_email_part1" class="form-control" placeholder="{{__('app.from_email_example')}}" value="{{strstr($settings->from_email, '@', true)}}" required>
                                            </div>
                                            <span class="input-group-text">@</span>
                                            @php
                                            $from_email_domain = '';
                                            if(!empty($settings->from_email))
                                            $from_email_domain = explode('@', $settings->from_email)[1];
                                            @endphp
                                            <select name="from_email_part2" class="form-select" required>
                                                <option value="">{{__('app.select_domain')}}</option>
                                                @foreach(\App\Models\SendingDomain::getSendingDomains() as $sending_domain)
                                                <option value="{{ $sending_domain->domain }}" {{ ($from_email_domain == $sending_domain->domain) ? 'selected="selected"' : '' }}>{{ $sending_domain->domain }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row mb-4">
                                <div class="col-md-12">
                                    <div id="sending-attributes"></div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="tab-pane fade" id="pills-tracking" role="tabpanel" aria-labelledby="pills-tracking-tab">
                            
                            <div class="row mb-4">
                                <div class="col-md-12">
                                    @if(!file_exists(config('custom.path_maxmind_geo_db')))
                                    <div class="alert alert-danger">
                                        {!! str_replace('[path]', config('custom.path_maxmind_geo_db'), __('app.geo_file_missing_msg')) !!}
                                        <br>
                                        {!! str_replace('[path]', config('custom.path_maxmind_geo_db'), __('app.geo_file_download_msg')) !!}
                                    </div>
                                    @endif
                                </div>
                            </div>
                            
                            <div class="row mb-4">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label class="form-label fw-semibold">{{__('app.tracking')}}
                                            <a tabindex="-1" role="button"
                                            data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="bottom" title="{{__('app.tracking')}}"
                                            data-bs-content="{{__('app.settings_tracking_help')}}" data-bs-custom-class="header-primary">
                                                <i class="bi bi-question-circle text-primary"></i>
                                            </a>
                                        </label>
                                        <select name="tracking" class="form-select">
                                            <option value="enabled" {{ ($settings->tracking == 'enabled') ? 'selected' : '' }}>{{ __('app.enabled') }}</option>
                                            <option value="disabled" {{ ($settings->tracking == 'disabled') ? 'selected' : '' }}>{{ __('app.disabled') }}</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        </div>
                        <!-- Action Buttons -->
                    <div class="row mt-4">
                        <div class="col-12">
                            <div class="d-flex gap-2">
                                <button type="submit" class="btn btn-primary btn-loading">
                                    <i class="bi bi-check-circle me-1"></i>{{__('app.update')}}
                                </button>
                            </div>
                        </div>
                    </div>
                    </div>
                    
                    
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
