<script src="{{asset('assets/js/app.js')}}"></script>
<script type="text/javascript">
  $('[data-bs-toggle="popover"]').popover({
    container: 'body'
  });
</script>
<style>
/* Override any conflicting CSS from schedule.css or smart_wizard CSS */
.modal-dialog.modal-lg {
  max-width: 600px !important;
  width: 90% !important;
  margin: 1.75rem auto !important;
}

.modal-content {
  border-radius: 0.5rem !important;
  box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15) !important;
}

.modal-body {
  max-height: 70vh !important;
  overflow-y: auto !important;
  padding: 1.5rem !important;
  scrollbar-width: thin !important;
  scrollbar-color: #888 #f0f0f0 !important;
}

/* Professional form styling */
.modal .form-label {
  font-weight: 600 !important;
  color: var(--bs-body-color) !important;
  margin-bottom: 0.5rem !important;
}

.modal .form-control {
  border-radius: 0.375rem !important;
  border: 1px solid var(--bs-border-color) !important;
  font-size: 0.875rem !important;
  transition: border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out !important;
}

.modal .form-control:focus {
  border-color: var(--bs-primary) !important;
  box-shadow: 0 0 0 0.2rem rgba(var(--bs-primary-rgb), 0.25) !important;
}

.modal textarea.form-control {
  resize: vertical !important;
  min-height: 120px !important;
}
</style>

<div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg">
  <div class="modal-content">
    <form id="frm-group" method="post" action="{{route('spintags.store')}}" class="needs-validation" novalidate>
      @csrf
      <div class="modal-header">
        <div class="d-flex align-items-center">
          <div class="p-2 border border-primary border-opacity-10 bg-primary-transparent rounded-circle me-3">
            <span class="avatar avatar-sm avatar-rounded bg-primary svg-white">
              <i class="bi bi-tags"></i>
            </span>
          </div>
          <h6 class="modal-title mb-0 fw-semibold">{{__('app.add_new_spintag')}}</h6>
        </div>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="{{__('app.close')}}"></button>
      </div>
      
      <div class="modal-body">
        
        <div class="row">
          <div class="col-md-12">
            <label class="form-label fw-semibold">{{__('app.name')}}</label>
            <input type="text" class="form-control" placeholder="{{__('app.name')}}" value="" name="name" required>
            <div class="invalid-feedback">{{__('app.name_required')}}</div>
          </div>
        </div>
        
        
        <div class="row">
          <div class="col-md-12">
            <label class="form-label fw-semibold mt-2">{{__('app.values')}}
              <a tabindex="-1" role="button"
                data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" title="{{__('app.values')}}"
                data-bs-content="{{__('app.sping_tag_values_help')}}" data-bs-custom-class="header-primary">
                <i class="bi bi-question-square text-primary"></i>
              </a>
            </label>
            <textarea class="form-control" name="values" rows="7" placeholder="{{ __('app.custom_field_values_placeholder') }}"></textarea>
            <div class="invalid-feedback">{{__('app.values_required')}}</div>
          </div>
        </div>
      </div>
      
      <div class="modal-footer">
        <button type="button" class="btn btn-light" data-bs-dismiss="modal">
          <i class="bi bi-arrow-left me-1"></i>{{__('app.close')}}
        </button>
        <button type="submit" class="btn btn-primary btn-loading">
          <i class="bi bi-check-circle me-1"></i>{{__('app.create')}}
        </button>
      </div>
    </form>
  </div>
</div>
