@extends('layouts.app')
@section('title', $page_title)

@section('styles')
<style>
/* Email input group styling */
.input-group > .select2-container {
  flex: 1 1 auto;
  width: auto !important;
}
#from_email_part1 {
  height: 100%;
}
</style>
@endsection

@push('scripts')
<script src="{{asset('assets/js/split_test.js')}}"></script>
<script>
$(document).ready(function() {
  // Initialize Select2 for email domain dropdown
  $('#sending-domains').select2({
    placeholder: '{{__("app.select_domain")}}',
    allowClear: false,
    width: '100%'
  });
  
  // Add validation for sending server multiselect
  var forms = document.getElementsByClassName('needs-validation');
  Array.prototype.filter.call(forms, function (form) {
    form.addEventListener('submit', function (event) {
      var formIsValid = form.checkValidity();
      
      // Always validate lists
      const listDropdown = document.getElementById("list_ids");
      var listValid = true;
      
      if (listDropdown && !listDropdown.disabled) {
        var listSelectedValues = $(listDropdown).val();
        var isValid = false;
        
        if (listSelectedValues === null || listSelectedValues === undefined) {
          isValid = false;
        } else if (Array.isArray(listSelectedValues)) {
          var validValues = listSelectedValues.filter(function(val) { 
            return val !== '' && val !== null && val !== undefined && String(val).trim() !== ''; 
          });
          isValid = validValues.length > 0;
        } else if (typeof listSelectedValues === 'string') {
          isValid = listSelectedValues.trim() !== '' && listSelectedValues !== null;
        }
        
        if (isValid) {
          var $selectedOptions = $(listDropdown).find('option:selected[value!=""]');
          isValid = $selectedOptions.length > 0;
        }
        
        listValid = isValid;
        
        var $listMultiselectBtn = $(listDropdown).next('.btn-group').find('.multiselect');
        if ($listMultiselectBtn.length === 0) {
          $listMultiselectBtn = $(listDropdown).siblings('.btn-group').find('.multiselect');
        }
        if ($listMultiselectBtn.length === 0) {
          $listMultiselectBtn = $(listDropdown).closest('.form-group, .col-md-12, .col-12').find('.multiselect');
        }
        
        if (!isValid) {
          if ($listMultiselectBtn.length > 0) {
            $listMultiselectBtn.addClass("is-invalid").css({
              'border-color': '#dc3545',
              'box-shadow': '0 0 0 0.2rem rgba(220, 53, 69, 0.25)'
            });
          }
          $(listDropdown).addClass("is-invalid");
          var $feedback = $('#list_ids_feedback');
          if ($feedback.length === 0) {
            $feedback = $(listDropdown).next('.invalid-feedback');
          }
          if ($feedback.length === 0) {
            $feedback = $(listDropdown).siblings('.invalid-feedback');
          }
          if ($feedback.length === 0) {
            $feedback = $(listDropdown).closest('.form-group, .col-md-12, .col-12').find('.invalid-feedback');
          }
          if ($feedback.length > 0) {
            $feedback.show();
          }
        } else {
          if ($listMultiselectBtn.length > 0) {
            $listMultiselectBtn.removeClass("is-invalid").css({
              'border-color': '',
              'box-shadow': ''
            });
          }
          $(listDropdown).removeClass("is-invalid");
          var $feedback = $('#list_ids_feedback');
          if ($feedback.length === 0) {
            $feedback = $(listDropdown).next('.invalid-feedback');
          }
          if ($feedback.length === 0) {
            $feedback = $(listDropdown).siblings('.invalid-feedback');
          }
          if ($feedback.length === 0) {
            $feedback = $(listDropdown).closest('.form-group, .col-md-12, .col-12').find('.invalid-feedback');
          }
          if ($feedback.length > 0) {
            $feedback.hide();
          }
        }
      }
      
      // Always validate sending server
      const sendingServerDropdown = document.getElementById("sending_server_ids");
      var sendingServerValid = true;
      
      if (sendingServerDropdown && !sendingServerDropdown.disabled) {
        var selectedValues = $(sendingServerDropdown).val();
        var isValid = false;
        
        if (selectedValues === null || selectedValues === undefined) {
          isValid = false;
        } else if (Array.isArray(selectedValues)) {
          var validValues = selectedValues.filter(function(val) { 
            return val !== '' && val !== null && val !== undefined && String(val).trim() !== ''; 
          });
          isValid = validValues.length > 0;
        } else if (typeof selectedValues === 'string') {
          isValid = selectedValues.trim() !== '' && selectedValues !== null;
        }
        
        if (isValid) {
          var $selectedOptions = $(sendingServerDropdown).find('option:selected[value!=""]');
          isValid = $selectedOptions.length > 0;
        }
        
        sendingServerValid = isValid;
        
        var $multiselectBtn = $(sendingServerDropdown).next('.btn-group').find('.multiselect');
        if ($multiselectBtn.length === 0) {
          $multiselectBtn = $(sendingServerDropdown).siblings('.btn-group').find('.multiselect');
        }
        if ($multiselectBtn.length === 0) {
          $multiselectBtn = $(sendingServerDropdown).closest('.form-group, .col-md-12, .col-12').find('.multiselect');
        }
        
        if (!isValid) {
          if ($multiselectBtn.length > 0) {
            $multiselectBtn.addClass("is-invalid").css({
              'border-color': '#dc3545',
              'box-shadow': '0 0 0 0.2rem rgba(220, 53, 69, 0.25)'
            });
          }
          $(sendingServerDropdown).addClass("is-invalid");
          var $feedback = $('#sending_server_ids_feedback');
          if ($feedback.length === 0) {
            $feedback = $(sendingServerDropdown).next('.invalid-feedback');
          }
          if ($feedback.length === 0) {
            $feedback = $(sendingServerDropdown).siblings('.invalid-feedback');
          }
          if ($feedback.length === 0) {
            $feedback = $(sendingServerDropdown).closest('.form-group, .col-md-12, .col-12').find('.invalid-feedback');
          }
          if ($feedback.length > 0) {
            $feedback.show();
          }
        } else {
          if ($multiselectBtn.length > 0) {
            $multiselectBtn.removeClass("is-invalid").css({
              'border-color': '',
              'box-shadow': ''
            });
          }
          $(sendingServerDropdown).removeClass("is-invalid");
          var $feedback = $('#sending_server_ids_feedback');
          if ($feedback.length === 0) {
            $feedback = $(sendingServerDropdown).next('.invalid-feedback');
          }
          if ($feedback.length === 0) {
            $feedback = $(sendingServerDropdown).siblings('.invalid-feedback');
          }
          if ($feedback.length === 0) {
            $feedback = $(sendingServerDropdown).closest('.form-group, .col-md-12, .col-12').find('.invalid-feedback');
          }
          if ($feedback.length > 0) {
            $feedback.hide();
          }
        }
      }
      
      // Prevent submission if form is invalid OR lists is invalid OR sending server is invalid
      if (!formIsValid || !listValid || !sendingServerValid) {
        event.preventDefault();
        event.stopPropagation();
        // Remove button loader if validation fails
        $(".btn-loading").find("i").removeClass("spinner-border spinner-border-sm align-middle");
      }
      
      form.classList.add('was-validated');
    }, false);
  });
  
  // Clear validation on change for lists
  $('#list_ids').on('change', function() {
    var $select = $(this);
    if ($select.prop('disabled')) return; // Skip if disabled
    
    var selectedValues = $select.val();
    var hasSelection = false;
    
    if (selectedValues === null || selectedValues === undefined) {
      hasSelection = false;
    } else if (Array.isArray(selectedValues)) {
      var validValues = selectedValues.filter(function(val) { 
        return val !== '' && val !== null && val !== undefined && String(val).trim() !== ''; 
      });
      hasSelection = validValues.length > 0;
    } else if (typeof selectedValues === 'string') {
      hasSelection = selectedValues.trim() !== '' && selectedValues !== null;
    }
    
    if (hasSelection) {
      var $selectedOptions = $select.find('option:selected[value!=""]');
      hasSelection = $selectedOptions.length > 0;
    }
    
    var $multiselectBtn = $select.next('.btn-group').find('.multiselect');
    if ($multiselectBtn.length === 0) {
      $multiselectBtn = $select.siblings('.btn-group').find('.multiselect');
    }
    if ($multiselectBtn.length === 0) {
      $multiselectBtn = $select.closest('.form-group, .col-md-12, .col-12').find('.multiselect');
    }
    
    if (hasSelection) {
      $select.removeClass("is-invalid");
      if ($multiselectBtn.length > 0) {
        $multiselectBtn.removeClass("is-invalid").css({
          'border-color': '',
          'box-shadow': ''
        });
      }
      var $feedback = $('#list_ids_feedback');
      if ($feedback.length === 0) {
        $feedback = $select.next('.invalid-feedback');
      }
      if ($feedback.length === 0) {
        $feedback = $select.siblings('.invalid-feedback');
      }
      if ($feedback.length === 0) {
        $feedback = $select.closest('.form-group, .col-md-12, .col-12').find('.invalid-feedback');
      }
      if ($feedback.length > 0) {
        $feedback.hide();
      }
    }
  });
  
  // Clear validation on change for sending server
  $('#sending_server_ids').on('change', function() {
    var $select = $(this);
    if ($select.prop('disabled')) return; // Skip if disabled
    
    var selectedValues = $select.val();
    var hasSelection = false;
    
    if (selectedValues === null || selectedValues === undefined) {
      hasSelection = false;
    } else if (Array.isArray(selectedValues)) {
      var validValues = selectedValues.filter(function(val) { 
        return val !== '' && val !== null && val !== undefined && String(val).trim() !== ''; 
      });
      hasSelection = validValues.length > 0;
    } else if (typeof selectedValues === 'string') {
      hasSelection = selectedValues.trim() !== '' && selectedValues !== null;
    }
    
    if (hasSelection) {
      var $selectedOptions = $select.find('option:selected[value!=""]');
      hasSelection = $selectedOptions.length > 0;
    }
    
    var $multiselectBtn = $select.next('.btn-group').find('.multiselect');
    if ($multiselectBtn.length === 0) {
      $multiselectBtn = $select.siblings('.btn-group').find('.multiselect');
    }
    if ($multiselectBtn.length === 0) {
      $multiselectBtn = $select.closest('.form-group, .col-md-12, .col-12').find('.multiselect');
    }
    
    if (hasSelection) {
      $select.removeClass("is-invalid");
      if ($multiselectBtn.length > 0) {
        $multiselectBtn.removeClass("is-invalid").css({
          'border-color': '',
          'box-shadow': ''
        });
      }
      var $feedback = $('#sending_server_ids_feedback');
      if ($feedback.length === 0) {
        $feedback = $select.next('.invalid-feedback');
      }
      if ($feedback.length === 0) {
        $feedback = $select.siblings('.invalid-feedback');
      }
      if ($feedback.length === 0) {
        $feedback = $select.closest('.form-group, .col-md-12, .col-12').find('.invalid-feedback');
      }
      if ($feedback.length > 0) {
        $feedback.hide();
      }
    }
  });
  
  // Clear validation on change for campaigns (broadcasts)
  $('#broadcast_ids').on('change', function() {
    var $select = $(this);
    if ($select.prop('disabled')) return; // Skip if disabled
    
    var selectedValues = $select.val();
    var hasSelection = false;
    
    if (selectedValues === null || selectedValues === undefined) {
      hasSelection = false;
    } else if (Array.isArray(selectedValues)) {
      var validValues = selectedValues.filter(function(val) { 
        return val !== '' && val !== null && val !== undefined && String(val).trim() !== ''; 
      });
      hasSelection = validValues.length > 0;
    } else if (typeof selectedValues === 'string') {
      hasSelection = selectedValues.trim() !== '' && selectedValues !== null;
    }
    
    if (hasSelection) {
      var $selectedOptions = $select.find('option:selected[value!=""]');
      hasSelection = $selectedOptions.length > 0;
    }
    
    var $multiselectBtn = $select.next('.btn-group').find('.multiselect');
    if ($multiselectBtn.length === 0) {
      $multiselectBtn = $select.siblings('.btn-group').find('.multiselect');
    }
    if ($multiselectBtn.length === 0) {
      $multiselectBtn = $select.closest('.form-group, .col-md-12, .col-12').find('.multiselect');
    }
    
    if (hasSelection) {
      $select.removeClass("is-invalid");
      if ($multiselectBtn.length > 0) {
        $multiselectBtn.removeClass("is-invalid").css({
          'border-color': '',
          'box-shadow': ''
        });
      }
      var $feedback = $('#broadcast_ids_feedback');
      if ($feedback.length === 0) {
        $feedback = $select.next('.invalid-feedback');
      }
      if ($feedback.length === 0) {
        $feedback = $select.siblings('.invalid-feedback');
      }
      if ($feedback.length === 0) {
        $feedback = $select.closest('.form-group, .col-md-12, .col-12').find('.invalid-feedback');
      }
      if ($feedback.length > 0) {
        $feedback.hide();
      }
    }
  });
});
</script>
@endpush

@section('content')
<div class="row">
  <div class="col-12">
    <div class="card custom-card">
      <div class="card-body">
        <form method="POST" action="{{ route('split_tests.store') }}" class="needs-validation" novalidate>
          @csrf
          
          <!-- General Information Fields -->
          <div class="row mb-3">
            <div class="col-md-6">
              <div class="form-group">
                <label class="form-label fw-semibold">{{__('app.active')}}</label>
                <select name="is_active" class="form-select" required>
                  <option value="1" {{ old('is_active', '1') == '1' ? 'selected' : '' }}>{{ __('app.yes') }}</option>
                  <option value="0" {{ old('is_active') == '0' ? 'selected' : '' }}>{{ __('app.no')}}</option>
                </select>
                <div class="invalid-feedback">{{__('app.active_required')}}</div>
              </div>
            </div>
            
            <div class="col-md-6">
              <div class="form-group">
                <label class="form-label fw-semibold">{{__('app.name')}}</label>
                <input type="text" class="form-control" placeholder="{{__('app.name')}}" value="{{ old('name') }}" name="name" required>
                <div class="invalid-feedback">{{__('app.name_required')}}</div>
              </div>
            </div>
          </div>
          <!-- Scheduling Section -->
          <div class="row mb-3">            
            <div class="col-md-6">
              <div class="form-group">
                <label class="form-label fw-semibold">{{ __('app.send') }}
                  <a tabindex="-1" role="button" data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" 
                     title="{{__('app.send')}}" data-bs-content="{{__('app.split_test_speed_help')}}" 
                     data-bs-custom-class="header-primary" class="text-primary ms-1">
                    <i class="bi bi-question-circle"></i>
                  </a>
                </label>
                <select name="send" id="send" class="form-select" required>
                  <option value="now" {{ old('send', 'now') == 'now' ? 'selected' : '' }}>{{ __('app.now') }}</option>
                  <option value="later" {{ old('send') == 'later' ? 'selected' : '' }}>{{ __('app.later') }}</option>
                </select>
                <div class="invalid-feedback">{{__('app.send_required')}}</div>
              </div>
            </div>
            
            <div class="col-md-6" id="send_datetime_div" style="display: none;">
              <div class="form-group">
                <label class="form-label fw-semibold">{{ __('app.sending_datetime') }}</label>
                <div class="input-group">
                  <div class="input-group-text"><i class="ri-calendar-line"></i></div>
                  <input type="text" name="send_datetime" class="form-control" id="send_datetime" placeholder="{{ __('app.choose_date_time') }}" value="{{ !empty($attributes->send_datetime) ? \App\Http\Helper\Helper::datetimeDisplay($attributes->send_datetime) : ''}}">
                  <input type="hidden" name="db_send_datetime" id="db_send_datetime" value="">
                  <input type="hidden" name="timezone" id="timezone" value="{{ \Auth::user()->timezone }}">
                </div>
                <div class="invalid-feedback">{{__('app.sending_datetime_required')}}</div>
              </div>
            </div>
          </div>
          <!-- Content Selection Section -->
          <div class="row">
            <div class="col-12">
              <div class="d-flex align-items-center">
                <div class="me-3">
                  <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                    <i class="bi bi-collection"></i>
                  </span>
                </div>
                <h6 class="mb-0 text-info fw-semibold fs-14">{{__('app.content_selection')}}</h6>
              </div>
            </div>
            
            <div class="col-md-6">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{__('app.lists')}}
                  <a href="{{route('lists.create')}}" class="text-primary ms-1">
                    <i class="bi bi-plus-circle"></i>
                  </a>
                  <a tabindex="-1" role="button" data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" 
                     title="{{__('app.lists')}}" data-bs-content="{{__('app.split_test_lists')}}" 
                     data-bs-custom-class="header-primary" class="text-primary ms-1">
                    <i class="bi bi-question-circle"></i>
                  </a>
                </label>
                @include('includes.dropdown_lists', ['popup' => 0, 'multiple' => 1, 'required' => 1, 'client_package_lists' => 1])
                <div class="invalid-feedback">{{__('app.lists_required')}}</div>
              </div>
            </div>
            
            <div class="col-md-6">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{__('app.campaigns')}}
                  <a href="{{route('broadcasts.create')}}" class="text-primary ms-1">
                    <i class="bi bi-plus-circle"></i>
                  </a>
                  <a tabindex="-1" role="button" data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" 
                     title="{{__('app.campaigns')}}" data-bs-content="{{__('app.split_test_campaigns')}}" 
                     data-bs-custom-class="header-primary" class="text-primary ms-1">
                    <i class="bi bi-question-circle"></i>
                  </a>
                </label>
                @include('includes.dropdown_broadcasts', ['popup' => 0, 'multiple' => 1, 'required' => 1])
                <div class="invalid-feedback">{{__('app.campaigns_required')}}</div>
              </div>
            </div>
          </div> 
          <!-- Split Test Configuration Section -->
          <div class="row mb-3 mt-3">
            <div class="col-12">
              <div class="d-flex align-items-center">
                <div class="me-3">
                  <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                    <i class="bi bi-graph-up"></i>
                  </span>
                </div>
                <h6 class="mb-0 text-info fw-semibold fs-14">{{__('app.split_test_configuration')}}</h6>
              </div>
            </div>
            
            <div class="col-md-4">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{ __('app.winning_criteria') }}
                  <a tabindex="-1" role="button" data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" 
                     title="{{__('app.winning_criteria')}}" data-bs-content="{{__('app.split_test_winning_criteria_help')}}" 
                     data-bs-custom-class="header-primary" class="text-primary ms-1">
                    <i class="bi bi-question-circle"></i>
                  </a>
                </label>
                <select name="winning_criteria" class="form-select" required>
                  <option value="open" {{ old('winning_criteria', 'open') == 'open' ? 'selected' : '' }}>{{ __('app.split_test_winning_criteria_open') }}</option>
                  <option value="click" {{ old('winning_criteria') == 'click' ? 'selected' : '' }}>{{ __('app.split_test_winning_criteria_click') }}</option>
                </select>
                <div class="invalid-feedback">{{__('app.winning_criteria_required')}}</div>
              </div>
            </div>
            
            <div class="col-md-4">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{ __('app.decision_percentage') }}
                  <a tabindex="-1" role="button" data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" 
                     title="{{__('app.decision_percentage')}}" data-bs-content="{{__('app.split_test_decision_percentage_help')}}" 
                     data-bs-custom-class="header-primary" class="text-primary ms-1">
                    <i class="bi bi-question-circle"></i>
                  </a>
                </label>
                <select name="decision_percentage" class="form-select" required>
                  @for($i=5; $i<=100; $i+=5)
                    <option value="{{$i}}" {{ old('decision_percentage', '50') == $i ? 'selected' : '' }}>{{$i}} %</option>
                  @endfor
                </select>
                <div class="invalid-feedback">{{__('app.decision_percentage_required')}}</div>
              </div>
            </div>
            
            <div class="col-md-4">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{ __('app.action') }}
                  <a tabindex="-1" role="button" data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" 
                     title="{{__('app.action')}}" data-bs-content="{{__('app.split_test_action_help')}}" 
                     data-bs-custom-class="header-primary" class="text-primary ms-1">
                    <i class="bi bi-question-circle"></i>
                  </a>
                </label>
                <select name="action" class="form-select" required>
                  <option value="send_remaining" {{ old('action', 'send_remaining') == 'send_remaining' ? 'selected' : '' }}>{{ __('app.send_remaining') }}</option>
                  <option value="show_results" {{ old('action') == 'show_results' ? 'selected' : '' }}>{{ __('app.show_results') }}</option>
                </select>
                <div class="invalid-feedback">{{__('app.action_required')}}</div>
              </div>
            </div>
            
            <div class="col-md-4">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{ __('app.split_test_after') }}
                  <a tabindex="-1" role="button" data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" 
                     title="{{__('app.split_test_after')}}" data-bs-content="{{__('app.split_test_after_help')}}" 
                     data-bs-custom-class="header-primary" class="text-primary ms-1">
                    <i class="bi bi-question-circle"></i>
                  </a>
                </label>
                <input type="number" class="form-control" name="send_remaining_after" value="{{ old('send_remaining_after', '30') }}" min="1" placeholder="30" required>
                <div class="invalid-feedback">{{__('app.split_test_after_required')}}</div>
              </div>
            </div>
            
            <div class="col-md-4">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{__('app.duration')}}</label>
                <select name="send_remaining_after_duration" class="form-select" required>
                  <option value="minutes" {{ old('send_remaining_after_duration', 'minutes') == 'minutes' ? 'selected' : '' }}>{{ __('app.minutes') }}</option>
                  <option value="hours" {{ old('send_remaining_after_duration') == 'hours' ? 'selected' : '' }}>{{ __('app.hours') }}</option>
                  <option value="days" {{ old('send_remaining_after_duration') == 'days' ? 'selected' : '' }}>{{ __('app.days') }}</option>
                </select>
                <div class="invalid-feedback">{{__('app.duration_required')}}</div>
              </div>
            </div>
          </div>
          <!-- Sending Configuration Section -->
          <div class="row">
            <div class="col-12">
              <div class="d-flex align-items-center">
                <div class="me-3">
                  <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                    <i class="bi bi-send"></i>
                  </span>
                </div>
                <h6 class="mb-0 text-info fw-semibold fs-14">{{__('app.sending_configuration')}}</h6>
              </div>
            </div>
            
            <div class="col-md-12">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{__('app.sending_server')}}
                  <a href="{{route('sending_servers.create')}}" class="text-primary ms-1">
                    <i class="bi bi-plus-circle"></i>
                  </a>
                  <a tabindex="-1" role="button" data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" 
                     title="{{__('app.delivery_servers')}}" data-bs-content="{{__('app.split_test_sending_servers')}}" 
                     data-bs-custom-class="header-primary" class="text-primary ms-1">
                    <i class="bi bi-question-circle"></i>
                  </a>
                </label>
                @include('includes.dropdown_sending_server', ['popup' => 0, 'multiple' => 1, 'required' => 1, 'client_package_lists' => 1])
                <div class="invalid-feedback">{{__('app.sending_server_required')}}</div>
              </div>
            </div>
          </div>
            <div class="col-12 mt-3">
              <div class="form-group">
                <label class="form-label fw-semibold">{{__('app.from_detail')}}
                  <a tabindex="-1" role="button" data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" 
                     title="{{__('app.from_detail')}}" data-bs-content="{{__('app.from_detail_help')}}" 
                     data-bs-custom-class="header-primary" class="text-primary ms-1">
                    <i class="bi bi-question-circle"></i>
                  </a>
                </label>
                <div class="form-check-group">
                  <div class="form-check form-check-inline">
                    <input name="from_detail" class="form-check-input" type="radio" id="from_sending_server" value="sending_server" {{ old('from_detail', 'sending_server') == 'sending_server' ? 'checked' : '' }}>
                    <label class="form-check-label" for="from_sending_server">{{__('app.as_defined_for_sending_server')}}</label>
                  </div>
                  <div class="form-check form-check-inline">
                    <input name="from_detail" class="form-check-input" type="radio" id="from_list" value="list" {{ old('from_detail') == 'list' ? 'checked' : '' }}>
                    <label class="form-check-label" for="from_list">{{__('app.as_defined_for_list')}}</label>
                  </div>
                  <div class="form-check form-check-inline">
                    <input name="from_detail" class="form-check-input" type="radio" id="from_custom" value="custom" {{ old('from_detail') == 'custom' ? 'checked' : '' }}>
                    <label class="form-check-label" for="from_custom">{{__('app.custom')}}</label>
                  </div>
                </div>
              </div>
            </div>
            
            <div class="row mt-3" id="custom_email_data" style="display: none;">
              <div class="col-md-3">
                <div class="form-group">
                  <label class="form-label fw-semibold">{{__('app.from_name')}}</label>
                  <input type="text" class="form-control" placeholder="{{__('app.from_name')}}" value="{{ old('from_name') }}" name="from_name">
                </div>
              </div>
              <div class="col-md-5">
                <div class="form-group">
                  <label class="form-label fw-semibold">{{__('app.from_email')}}</label>
                  <div class="input-group">
                    <div style="width: 35%;">
                      <input type="text" name="from_email_part1" id="from_email_part1" value="{{ old('from_email_part1') }}" class="form-control" placeholder="{{__('app.from_email_example')}}">
                    </div>
                    <span class="input-group-text">@</span>
                    <select name="from_email_part2" id="sending-domains" class="single-select form-select">
                      @include('includes.dropdown_sending_domains')
                    </select>
                  </div>
                </div>
              </div>
              <div class="col-md-4">
                <div class="form-group">
                  <label class="form-label fw-semibold">{{__('app.reply_email')}}</label>
                  <input type="email" class="form-control" placeholder="{{__('app.reply_email')}}" value="{{ old('reply_email') }}" name="reply_email">
                </div>
              </div>
            </div>

            <!-- Speed Configuration Section -->
          <div class="row mb-3 mt-3">
            <div class="col-md-12">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{ __('app.sending_speed') }}
                  <a tabindex="-1" role="button" data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" 
                     title="{{__('app.sending_speed')}}" data-bs-content="{{__('app.sending_speed_help')}}" 
                     data-bs-custom-class="header-primary" class="text-primary ms-1">
                    <i class="bi bi-question-circle"></i>
                  </a>
                </label>
                <select class="form-select" name="sending_speed" id="speed" required>
                  <option value="unlimited" {{ old('sending_speed', 'unlimited') == 'unlimited' ? 'selected' : '' }}>{{ __('app.unlimited') }}</option>
                  <option value="limited" {{ old('sending_speed') == 'limited' ? 'selected' : '' }}>{{ __('app.limited') }}</option>
                </select>
                <div class="invalid-feedback">{{__('app.sending_speed_required')}}</div>
              </div>
            </div>
            
          </div>
          
            
            
            <div class="col-md-12" id="speed-attributes" style="display: none;">
              <div class="row">
                <div class="col-md-6">
                  <div class="form-group">
                    <label class="form-label fw-semibold">{{__('app.limit')}}</label>
                    <input type="number" class="form-control" name="limit" id="limit" value="{{ old('limit', '1000') }}" min="1" placeholder="1000">
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="form-group">
                    <label class="form-label fw-semibold">{{__('app.duration')}}</label>
                    <select name="duration" id="duration" class="form-select">
                      <option value="hour" {{ old('duration', 'hour') == 'hour' ? 'selected' : '' }}>{{ __('app.hourly') }}</option>
                    </select>
                  </div>
                </div>
              </div>

              <div class="row">
                <div class="col-md-6">
                  <div class="form-group">
                    <label class="form-label fw-semibold">{{ __('app.pause_after_send') }}
                      <a tabindex="-1" role="button" data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="right" 
                         title="{{__('app.pause_after_send')}}" data-bs-content="{{__('app.pause_after_send_help')}}" 
                         data-bs-custom-class="header-primary" class="text-primary ms-1">
                        <i class="bi bi-question-circle"></i>
                      </a>
                    </label>
                    <input type="number" class="form-control" name="pause_limit" value="{{ old('pause_limit', '0') }}" min="0" placeholder="0">
                  </div>
                </div>
                <div class="col-md-6">
                  <div class="form-group">
                    <label class="form-label fw-semibold">{{__('app.pause_duration')}}</label>
                    <select name="pause_duration" class="form-select">
                      <option value="minutes" {{ old('pause_duration', 'minutes') == 'minutes' ? 'selected' : '' }}>{{ __('app.minutes') }}</option>
                    </select>
                  </div>
                </div>
              </div>
            </div>

            <!-- Action Buttons -->
          <div class="row mt-2">
            <div class="col-12">
              <div class="d-flex gap-2 justify-content-start">
                <button type="submit" name="save_continue" value="1" class="btn btn-primary btn-loading">
                  <i class="bi bi-save me-1"></i>{{__('app.save_continue')}}
                </button>
                <button type="submit" name="save_exit" value="1" class="btn btn-success btn-loading">
                  <i class="bi bi-check-lg me-1"></i>{{__('app.save_exit')}}
                </button>
                <a href="{{route('split_tests.index')}}" class="btn btn-light">
                  <i class="bi bi-arrow-left me-1"></i>{{__('app.cancel')}}
                </a>
              </div>
            </div>
          </div>

          </div>

          
        </form>
      </div>
    </div>
  </div>
</div>
@include('includes.modal')
@endsection
