@extends('layouts.app')
@section('title', $page_title)

{{-- Include global DataTable styling --}}
@include('components.datatable-styles')

@push('scripts')
<script>
$(function () {
    'use strict';
    var table = $('#data').DataTable({
        "columnDefs": [{"sortable": false, "targets": [0,3,4,5,6,7,8,9,10,11,13]}],
        "order": [[ 0, "desc" ]],
        "lengthMenu": [[100, 500, 1000], [100, 500, 1000]],
        "ajax": {
          "url" : $('#route-split_tests').data('route')
        },
    });

    table.on('draw', function() {
    $('#data_paginate a').addClass('btn btn-primary me-1');
    $('#data_paginate .paginate_button.current').addClass('btn-light').removeClass('btn-primary');
    });

    setInterval(function(){ table.ajax.reload(null, false); }, 30*1000);
    
    // Handle Add Split Test button click with error handling
    $('#add-split-test-btn').on('click', function(e) {
        e.preventDefault();
        var href = $(this).attr('href');
        var $btn = $(this);
        var $icon = $btn.find('i');
        
        // Show loading spinner
        $icon.removeClass('bi-plus-circle').addClass('spinner-border spinner-border-sm');
        
        // Try to navigate to the create page
        $.ajax({
            url: href,
            type: 'GET',
            success: function() {
                // If successful, navigate to the page
                window.location.href = href;
            },
            error: function(xhr) {
                // Reset button
                $icon.removeClass('spinner-border spinner-border-sm').addClass('bi-plus-circle');
                
                if (xhr.status === 401) {
                    alert('You do not have permission to create split tests. Please contact your administrator.');
                } else if (xhr.status === 403) {
                    alert('Access forbidden. You do not have the required permissions.');
                } else {
                    alert('An error occurred while trying to access the create split test page. Please try again.');
                }
            }
        });
    });
});
</script>
@endpush

@section('content')
<div class="row">
    <div class="col-xl-12">
        <div class="card custom-card">            
            <div class="card-body">
                <div class="table-responsive">
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <a href="{{route('split_tests.create')}}" class="btn btn-primary btn-loading" id="add-split-test-btn">
                                <i class="bi bi-plus-circle me-2"></i>{{__('app.add_new_split_test')}}
                            </a>
                        </div>
                        <div class="col-md-6 text-end">
                            <div class="btn-group">
                                <button type="button" class="btn btn-outline-primary dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                                    <i class="bi bi-gear me-1"></i>{{__('app.actions')}}
                                </button>
                                <ul class="dropdown-menu">
                                    <li><a class="dropdown-item" href="javascript:;" onclick="destroyMany('{{ route('split_tests.destroy', [0]) }}')">
                                        <i class="bi bi-trash me-2"></i>{{ __('app.delete') }}
                                    </a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <table id="data" class="table table-bordered text-nowrap w-100">
                        <thead>
                            <tr>
                                <th><input type="checkbox" id='checkAll' value="0" class="form-check-input"></th>
                                <th>{{ __('app.name') }}</th>
                                <th>{{ __('app.started_at') }}</th>
                                <th>{!! nl2br(wordwrap(__('app.winning_criteria'),  10, "\n", true)) !!}</th>
                                <th>{!! nl2br(wordwrap(__('app.decision_percentage'),  10, "\n", true)) !!}</th>
                                <th>{{ __('app.action') }}</th>
                                <th>{{ __('app.split_test_after') }}</th>
                                <th>{{ __('app.speed_per_hour') }}</th>
                                <th>{{ __('app.status') }}</th>
                                <th>{{ __('app.total') }}</th>
                                <th>{{ __('app.scheduled') }}</th>
                                <th>{{ __('app.progress') }}</th>
                                <th>{{ __('app.created') }}</th>
                                <th>{{ __('app.actions') }}</th>
                            </tr>
                        </thead>
                         <tbody></tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<span id="route-split_tests" data-route="{{ route('get.split_tests') }}"></span>
<div id="running" data-value="{{ __('app.running')}}"></div>
<div id="running-msg" data-value="{{ __('app.msg_split_test_paused')}}"></div>
<div id="paused" data-value="{{ __('app.paused')}}"></div>
<div id="paused-msg" data-value="{{ __('app.msg_split_test_running')}}"></div>
@include('includes.datatables')
@endsection
