<script src="{{asset('assets/js/app.js')}}"></script>
<script type="text/javascript">
  $('[data-bs-toggle="popover"]').popover({
    container: 'body'
  });
</script>
<div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-lg">
    <div class="modal-content">
      <form id="frm-group" method="post" action="{{route('suppressions.store')}}" enctype="multipart/form-data" class="needs-validation" novalidate>
        @csrf
        <div class="modal-header">
          <div class="d-flex align-items-center">
            <div class="p-2 border border-primary border-opacity-10 bg-primary-transparent rounded-circle me-3">
              <span class="avatar avatar-sm avatar-rounded bg-primary svg-white">
                <i class="bi bi-plus-circle"></i>
              </span>
            </div>
            <h6 class="modal-title mb-0 fw-semibold">{{__('app.add_suppression')}}</h6>
          </div>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="{{__('app.close')}}"></button>
        </div>
        <div class="modal-body">
          <!-- Basic Information Section -->
          <div class="row mb-3">
            <div class="col-12">
            <div class="col-12">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2">{{__('app.group')}}
                  <a href="javascript:;" onclick="viewModal('modal', '{{route('group.create', ['type_id' => config('custom.group_suppression')])}}');" class="text-primary ms-1">
                    <i class="bi bi-plus-circle"></i>
                  </a>
                </label>
                <select name="group_id" class="single-select form-select" id="group_id" required>
                  <option value="">{{__('app.select_group')}}</option> 
                  @foreach($groups as $id => $group_name)
                    <option value="{{ $id }}">{{$group_name}}</option>
                  @endforeach
                </select>
                <div class="invalid-feedback">{{ __('app.select_group_error')}}</div>
              </div>
            </div>
          </div>

          <!-- Resource Selection Section -->
          <div class="row mb-3 mt-3">
            <div class="col-12">
              <div class="d-flex align-items-center justify-content-between">
                <div class="d-flex align-items-center">
                  <div class="me-3">
                    <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                      <i class="bi bi-gear"></i>
                    </span>
                  </div>
                  <h6 class="mb-0 text-info fw-semibold fs-14">{{__('app.resource_settings')}}</h6>
                </div>
                <a tabindex="-1" role="button" data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="left" 
                   title="{{__('app.resource')}}" data-bs-content="{{__('app.suppression_resource_help')}}" 
                   data-bs-custom-class="header-primary" class="text-primary">
                  <i class="bi bi-question-circle"></i>
                </a>
              </div>
            </div>
            <div class="col-12">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2"></label>
                <select name="resource" id="resource" class="form-select form-select-lg">
                  <option value="emails">{{ __('app.email_addresses')}}</option>
                  <option value="file">{{ __('app.file') }}</option>
                </select>
              </div>
            </div>
          </div>

          <!-- Email Addresses Section -->
          <div class="row mb-3" id="section-emails">
            <div class="col-12">
              <div class="d-flex align-items-center justify-content-between">
                <div class="d-flex align-items-center">
                  <div class="me-3">
                    <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                      <i class="bi bi-envelope"></i>
                    </span>
                  </div>
                  <h6 class="mb-0 text-info fw-semibold fs-14">{{__('app.email_input')}}</h6>
                </div>
                <a tabindex="-1" role="button" data-bs-toggle="popover" data-bs-trigger="focus" data-bs-placement="left" 
                   title="{{__('app.email_addresses')}}" data-bs-content="{{__('app.suppression_email_addresses_help')}}" 
                   data-bs-custom-class="header-primary" class="text-primary">
                  <i class="bi bi-question-circle"></i>
                </a>
              </div>
            </div>
            <div class="col-12">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2"></label>
                <textarea class="form-control" name="emails" rows="7" placeholder="{{ __('app.multiple_emails_placeholder') }}"></textarea>
              </div>
            </div>
          </div>

          <!-- File Upload Section -->
          <div class="row mb-3" id="section-file" style="display: none;">
            <div class="col-12">
              <div class="d-flex align-items-center">
                <div class="me-3">
                  <span class="avatar avatar-xs avatar-rounded bg-info svg-white">
                    <i class="bi bi-file-earmark-arrow-up"></i>
                  </span>
                </div>
                <h6 class="mb-0 text-info fw-semibold fs-14">{{__('app.file_upload')}}</h6>
              </div>
            </div>
            <div class="col-12">
              <div class="form-group">
                <label class="form-label fw-semibold mt-2"></label>
                <input class="form-control" name="file" type="file" id="file">
              </div>
            </div>
            <div class="col-12">
              <div class="form-group">
                <div id="info-filesize" style="display: none;">
                  <label class="form-label">{!! \App\Http\Helper\Helper::getMaxFileSize(false, true) !!}</label>
                </div>
              </div>
            </div>
          </div>

          <!-- Fields Mapping Section -->
          <div class="row mb-3" id="fields-mapping" style="display: none;">
            <div class="col-12">
              <div class="d-flex align-items-center">
                <div class="p-2 border border-secondary border-opacity-10 bg-secondary-transparent rounded-circle me-3">
                  <span class="avatar avatar-xs avatar-rounded bg-secondary svg-white">
                    <i class="bi bi-diagram-3"></i>
                  </span>
                </div>
                <h6 class="mb-0 text-secondary fw-semibold fs-14">{{__('app.fields_mapping')}}</h6>
              </div>
            </div>
            <div class="col-12">
              <div class="box-body" id="suppression-fields"></div>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-light" data-bs-dismiss="modal">
            <i class="bi bi-arrow-left me-1"></i>{{__('app.cancel')}}
          </button>
          <button type="submit" class="btn btn-primary btn-loading" id="btn-save">
            <i class="bi bi-check-lg me-1"></i>{{__('app.save')}}
          </button>
          <button type="button" class="btn btn-primary btn-loading" id="btn-proceed" style="display:none" onclick="suppressionImport(this, this.form, '{{ route('suppression.import') }}');">
            <i class="bi bi-arrow-right me-1"></i>{{__('app.proceed')}}
          </button>
          <button type="button" class="btn btn-primary btn-loading" id="btn-import" style="display:none" onclick="doSuppressionImport(this, this.form, '{{ route('suppression.import') }}');">
            <i class="bi bi-upload me-1"></i>{{__('app.import')}}
          </button>
        </div>
      </form>
    </div>
</div>
