@extends('layouts.app')
@section('title', $page_title)

{{-- Include global DataTable styling --}}
@include('components.datatable-styles')

@push('scripts')
<script src="{{asset('assets/js/suppression.js')}}"></script>
<script>
$(function () {
  // Handle Add Suppression button click with loading indicator
  $('#add-suppression-btn').on('click', function(e) {
    e.preventDefault();
    var $btn = $(this);
    var $icon = $btn.find('i');
    
    // Show loading spinner
    $icon.removeClass('bi-plus-circle').addClass('spinner-border spinner-border-sm');
    
    // Test the route first to check permissions
    $.ajax({
      url: '{{route('suppressions.create')}}',
      type: 'GET',
      success: function() {
        // If successful, proceed with the original modal call
        $icon.removeClass('spinner-border spinner-border-sm').addClass('bi-plus-circle');
        viewModal('modal', '{{route('suppressions.create')}}');
      },
      error: function(xhr) {
        // Reset button
        $icon.removeClass('spinner-border spinner-border-sm').addClass('bi-plus-circle');
        
        if (xhr.status === 401) {
          alert('You do not have permission to create suppressions. Please contact your administrator.');
        } else if (xhr.status === 403) {
          alert('Access forbidden. You do not have the required permissions.');
        } else {
          alert('An error occurred while trying to access the create suppression page. Please try again.');
        }
      }
    });
  });
});
</script>
@endpush

@section('content')
<div class="row">
    <div class="col-xl-12">
        <div class="card custom-card">
            <div class="card-body">
                <div class="table-responsive">
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <div class="d-flex gap-2">
                                <a href="javascript:;" class="btn btn-primary btn-loading" id="add-suppression-btn">
                                    <i class="bi bi-plus-circle me-2"></i>{{__('app.add_suppression')}}
                                </a>
                                <a href="javascript:;" onclick="exportBounced('{{ route('suppression.export') }}', '{{__('app.export_suppressions_alert')}}', '{{ __('app.msg_export_suppressions') }}');" class="btn btn-success" data-no-loading="true">
                                    <i class="bi bi-download me-2"></i>{{__('app.export_suppressions')}}
                                </a>
                            </div>
                        </div>
                        <div class="col-md-6 text-end">
                            <div class="btn-group">
                                <button type="button" class="btn btn-outline-primary dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                                    <i class="bi bi-gear me-1"></i>{{__('app.actions')}}
                                </button>
                                <ul class="dropdown-menu">
                                    <li><a class="dropdown-item" href="javascript:;" onclick="destroyMany('{{ route('suppressions.destroy', [0]) }}')">
                                        <i class="bi bi-trash me-2"></i>{{ __('app.delete') }}
                                    </a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <table id="data" class="table table-bordered text-nowrap w-100">
                        <thead>
                            <tr>
                                <th><input type="checkbox" id='checkAll' value="0" class="form-check-input"></th>
                                <th>{{ __('app.id') }}</th>
                                <th>{{ __('app.email') }}</th>
                                <th>{{ __('app.group') }}</th>
                                <th>{{ __('app.created') }}</th>
                                <th>{{ __('app.actions') }}</th>
                            </tr>
                        </thead>
                         <tbody></tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<span id="route-suppression" data-route="{{ route('get.suppressions') }}"></span>
<input type="hidden" id="route-group-delete-list" value="{{ route('group.delete', ['model' => 'suppression']) }}">
<span id="route-group-edit" data-route="{{ route('groups.edit', 'group-id') }}"></span>
<span id="tooltip-group-edit" data-value="{{ __('app.tooltip_group_edit') }}"></span>
<span id="tooltip-group-delete-list" data-value="{{ __('app.tooltip_group_delete_list') }}"></span>
<span id="msg-group-delete-list" data-value="{{ __('app.msg_group_delete_list') }}"></span>
<span id="tooltip-group-eraser-list" data-value="{{ __('app.tooltip_group_eraser_list') }}"></span>
<span id="route-group-eraser-list" data-route="{{ route('group.delete', ['model' => 'suppression']) }}"></span>
<span id="msg-group-erase-list" data-value="{{ __('app.msg_group_eraser_list') }}"></span>
@include('groups.move')
@include('includes.datatables')
@endsection
