@extends('layouts.app')
@section('title', $page_title)
@section('scripts')
<script>
$(function () {
  'use strict';
  $(".modal").on("hidden.bs.modal", function() {
    document.getElementById("shortcode").select();
    document.execCommand("copy");
    $('.btn-primary').focus();
  });
});
</script>
@endsection
@section('content')
<!-- Professional Builder Card Container -->
<div class="builder-card-container">
    <!-- Professional Card Header -->
    <div class="builder-card-header">
        <div class="builder-card-title-section">
            <h2 class="builder-card-title">{{ __('app.email_builder') }}</h2>
            <button type="button" class="btn btn-outline-primary btn-sm" onclick="viewModal('modal', '{{ route('shortcodes') }}');">
            <i class="bi bi-code-slash me-2"></i> {{ __('app.shortcodes') }}
            </button>
            <small class="text-info">
                {!! __('app.shortcode_help_template') !!}
            </small>
        </div>
    </div>
    
    <!-- Professional Card Body -->
    <div class="builder-card-body">
        
        <!-- Builder Loading State (Hidden) -->
        <div class="builder-loading" id="builder-loading" style="display: none;">
            <div class="loading-spinner"></div>
            <p class="loading-text">{{ __('app.initializing_builder') }}</p>
        </div>
        
        <!-- Builder Status (Hidden) -->
        <div class="builder-status" id="builder-status" style="display: none;">
            <div class="status-indicator">
                <i class="fas fa-check-circle"></i>
            </div>
            <span class="status-text">{{ __('app.builder_ready') }}</span>
        </div>
        
        <!-- Professional Iframe Container -->
        <div class="builder-iframe-container">
            <iframe 
                src="/get_builder?id={{$id ?? 0}}&action={{$action ?? 'create'}}" 
                frameborder="0" 
                scrolling="yes" 
                height="820" 
                width="100%"
                id="builder-iframe"
                onload="hideBuilderLoading()"
                onerror="showBuilderError()">
            </iframe>
        </div>
    </div>
</div>

<!-- Professional Builder Card Styles -->
<style>
/* Professional Builder Card Container */
.builder-card-container {
    background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
    border-radius: 20px;
    box-shadow: 0 12px 40px rgba(0, 0, 0, 0.12);
    border: 1px solid #dee2e6;
    overflow: hidden;
    position: relative;
    margin: 20px;
    transition: all 0.4s ease;
}

.builder-card-container::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    height: 6px;
    background: linear-gradient(90deg, #667eea 0%, #764ba2 50%, #f093fb 100%);
    z-index: 10;
}

.builder-card-container:hover {
    box-shadow: 0 16px 50px rgba(0, 0, 0, 0.18);
}

/* Professional Card Header */
.builder-card-header {
    background: linear-gradient(135deg, #ffffff 0%, #f8f9fa 100%);
    padding: 1.5rem 2rem;
    border-bottom: 1px solid #e9ecef;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
    position: relative;
    z-index: 5;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.builder-card-title-section {
    flex: 1;
    display: flex;
    align-items: center;
    gap: 1rem;
    flex-wrap: wrap;
}

.builder-card-title {
    font-size: 1.5rem;
    font-weight: 700;
    color: #2c3e50;
    margin: 0;
    display: flex;
    align-items: center;
    gap: 0.75rem;
}

.builder-card-title::before {
    content: '📧';
    font-size: 1.8rem;
    filter: grayscale(0.2);
}

.builder-card-title-section .btn {
    margin: 0;
}

.builder-card-actions {
    display: flex;
    gap: 1rem;
    align-items: center;
    flex-wrap: wrap;
    justify-content: flex-start;
}

.help-text-inline {
    color: #6c757d;
    font-size: 0.9rem;
    line-height: 1.4;
    max-width: 300px;
    text-align: right;
}

.builder-card-actions .btn {
    border-radius: 4px;
    font-weight: 500;
    padding: 0.25rem 0.5rem;
    transition: all 0.3s ease;
    border: 1px solid transparent;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    text-decoration: none;
    display: inline-flex;
    align-items: center;
    gap: 0.25rem;
    font-size: 0.7rem;
    position: relative;
    overflow: hidden;
    box-shadow: 0 2px 6px rgba(102, 126, 234, 0.3);
}

.builder-card-actions .btn::before {
    content: '';
    position: absolute;
    top: 0;
    left: -100%;
    width: 100%;
    height: 100%;
    background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
    transition: left 0.5s;
}

.builder-card-actions .btn:hover::before {
    left: 100%;
}

.builder-card-actions .btn:hover {
    transform: translateY(-1px);
    box-shadow: 0 4px 12px rgba(102, 126, 234, 0.4);
    text-decoration: none;
    color: white;
}

.builder-card-actions .btn:active {
    transform: translateY(0);
    box-shadow: 0 1px 4px rgba(102, 126, 234, 0.3);
}

.builder-card-actions .btn:focus {
    box-shadow: 0 0 0 0.15rem rgba(102, 126, 234, 0.25);
    color: white;
}

/* Professional Card Body */
.builder-card-body {
    background: #ffffff;
    padding: 2rem;
    position: relative;
}


/* Loading State */
.builder-loading {
    text-align: center;
    padding: 3rem 2rem;
    background: rgba(102, 126, 234, 0.05);
    border-radius: 12px;
    margin-bottom: 2rem;
}

.loading-spinner {
    width: 40px;
    height: 40px;
    border: 4px solid #e2e8f0;
    border-top: 4px solid #667eea;
    border-radius: 50%;
    animation: spin 1s linear infinite;
    margin: 0 auto 1rem;
}

@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

.loading-text {
    color: #667eea;
    font-weight: 600;
    font-size: 1.1rem;
    margin: 0;
}

/* Builder Status */
.builder-status {
    background: linear-gradient(135deg, #d4edda 0%, #c3e6cb 100%);
    border: 1px solid #c3e6cb;
    border-radius: 8px;
    padding: 1rem 1.5rem;
    margin-bottom: 2rem;
    display: flex;
    align-items: center;
    gap: 0.75rem;
    animation: slideInDown 0.5s ease-out;
}

@keyframes slideInDown {
    from {
        opacity: 0;
        transform: translateY(-20px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.status-indicator {
    color: #28a745;
    font-size: 1.2rem;
}

.status-text {
    color: #155724;
    font-weight: 600;
    font-size: 0.95rem;
}

/* Professional Iframe Container */
.builder-iframe-container {
    background: #ffffff;
    border-radius: 16px;
    box-shadow: 0 8px 32px rgba(0, 0, 0, 0.08);
    overflow: hidden;
    position: relative;
    border: 1px solid #e9ecef;
    transition: all 0.3s ease;
}

.builder-iframe-container:hover {
    box-shadow: 0 12px 40px rgba(0, 0, 0, 0.12);
}

.builder-iframe-container iframe {
    display: block;
    border: none;
    width: 100%;
    height: 820px;
    background: #ffffff;
}

/* Responsive Design */
@media (max-width: 768px) {
    .builder-card-header {
        flex-direction: column;
        gap: 1rem;
        text-align: center;
        padding: 1rem 1.5rem;
    }
    
    .builder-card-title {
        font-size: 1.3rem;
    }
    
    .builder-card-title-section {
        flex-direction: column;
        align-items: flex-start;
        gap: 0.75rem;
        width: 100%;
    }
    
    .builder-card-actions {
        flex-direction: column;
        gap: 0.75rem;
        width: 100%;
    }
    
    .help-text-inline {
        text-align: center;
        max-width: 100%;
        font-size: 0.85rem;
    }
    
    .builder-card-actions .btn {
        padding: 0.2rem 0.4rem;
        font-size: 0.65rem;
    }
    
    .builder-card-body {
        padding: 1.5rem;
    }
    
    .builder-iframe-container iframe {
        height: 600px;
    }
}

/* Professional Hover Effects */
.builder-card-container:hover {
    box-shadow: 0 25px 50px rgba(102, 126, 234, 0.4);
}

/* Card Animation */
.builder-card-container {
    animation: cardFadeIn 0.6s ease-out;
}

@keyframes cardFadeIn {
    from {
        opacity: 0;
        transform: translateY(30px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}
</style>

<!-- Professional Builder JavaScript -->
<script>
$(document).ready(function() {
    'use strict';
    
    // Initialize builder card
    initializeBuilderCard();
    
    // Card hover effects
    $('.builder-card-container').on('mouseenter', function() {
        $(this).addClass('card-hover');
    }).on('mouseleave', function() {
        $(this).removeClass('card-hover');
    });
    
    // Button click animations
    $('.builder-card-actions .btn').on('click', function() {
        $(this).addClass('btn-clicked');
        setTimeout(() => {
            $(this).removeClass('btn-clicked');
        }, 200);
    });
});

// Initialize builder card
function initializeBuilderCard() {
    console.log('Builder card initialized');
    
    // Hide loading state initially
    $('#builder-loading').hide();
    $('#builder-status').hide();
}

// Hide loading and show status
function hideBuilderLoading() {
    $('#builder-loading').fadeOut(500);
    // Status message is hidden and will not be shown
}

// Show error state
function showBuilderError() {
    $('#builder-loading').hide();
    $('#builder-status').html(`
        <div class="status-indicator" style="color: #dc3545;">
            <i class="fas fa-exclamation-triangle"></i>
        </div>
        <span class="status-text" style="color: #721c24;">{{ __('app.builder_error') }}</span>
    `).show();
}

// Professional CSS for additional states
$('<style>')
    .prop('type', 'text/css')
    .html(`
        .btn-clicked {
            animation: btnClick 0.2s ease-out;
        }
        
        @keyframes btnClick {
            0% { transform: scale(1); }
            50% { transform: scale(0.95); }
            100% { transform: scale(1); }
        }
        
        .card-hover {
            transform: translateY(-4px) !important;
            box-shadow: 0 25px 50px rgba(102, 126, 234, 0.4) !important;
        }
    `)
    .appendTo('head');
</script>
@endsection
