@php
session_save_path(__DIR__ . '/sessions');
if (!is_dir(__DIR__ . '/sessions')) {
    mkdir(__DIR__ . '/sessions', 0777, true);
}
session_start();
$_SESSION['mc_user_id'] = Auth::user()->id;
@endphp
<meta name="csrf-token" content="{{ csrf_token() }}">
<link id="style" href="{{asset('assets/libs/bootstrap/css/bootstrap.min.css')}}" rel="stylesheet" >
<link href="{{asset('assets/css/sweetalert.css')}}" rel="stylesheet" >
<link href="{{asset('assets/css/toastr.min.css')}}" rel="stylesheet" >
<link href="{{asset('components/rz_builder/dist/css/editor.css')}}" rel="stylesheet" >
<link href="{{asset('components/rz_builder/dist/css/custom.css')}}" rel="stylesheet" >

<!-- Professional Button Styles for rz_builder -->
<style>
/* Professional Button Styling for rz_builder */
.btn-main {
    border-radius: 8px;
    font-weight: 600;
    padding: 0.75rem 1.5rem;
    transition: all 0.3s ease;
    border: none;
    text-decoration: none;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    gap: 0.5rem;
    font-size: 0.9rem;
    position: relative;
    overflow: hidden;
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
}

.btn-main::before {
    content: '';
    position: absolute;
    top: 0;
    left: -100%;
    width: 100%;
    height: 100%;
    background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
    transition: left 0.5s;
}

.btn-main:hover::before {
    left: 100%;
}

       .btn-main:hover {
           box-shadow: 0 6px 20px rgba(0, 0, 0, 0.25);
           text-decoration: none;
       }

.btn-main:active {
    transform: translateY(0);
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.2);
}

/* Save Button */
.btn-save {
    background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
    color: white;
    border: 2px solid transparent;
}

.btn-save:hover {
    background: linear-gradient(135deg, #218838 0%, #1ea085 100%);
    color: white;
    box-shadow: 0 6px 20px rgba(40, 167, 69, 0.4);
}

.btn-save:focus {
    box-shadow: 0 0 0 0.2rem rgba(40, 167, 69, 0.25);
    color: white;
}

.btn-save::after {
    content: '💾';
    margin-left: 0.5rem;
    font-size: 0.8rem;
}

/* Cancel/Exit Button */
.btn-cancel {
    background: linear-gradient(135deg, #dc3545 0%, #fd7e14 100%);
    color: white;
    border: 2px solid transparent;
}

.btn-cancel:hover {
    background: linear-gradient(135deg, #c82333 0%, #e55a00 100%);
    color: white;
    box-shadow: 0 6px 20px rgba(220, 53, 69, 0.4);
}

.btn-cancel:focus {
    box-shadow: 0 0 0 0.2rem rgba(220, 53, 69, 0.25);
    color: white;
}

.btn-cancel::after {
    content: '❌';
    margin-left: 0.5rem;
    font-size: 0.8rem;
}

/* Modal Buttons */
.modal-btn-cancel,
.modal-btn-ok {
    border-radius: 6px;
    font-weight: 600;
    padding: 0.5rem 1.25rem;
    transition: all 0.3s ease;
    border: none;
    font-size: 0.875rem;
    position: relative;
    overflow: hidden;
    min-width: 80px;
}

.modal-btn-cancel {
    background: linear-gradient(135deg, #6c757d 0%, #495057 100%);
    color: white;
    box-shadow: 0 3px 8px rgba(108, 117, 125, 0.3);
}

       .modal-btn-cancel:hover {
           background: linear-gradient(135deg, #5a6268 0%, #343a40 100%);
           color: white;
           box-shadow: 0 4px 12px rgba(108, 117, 125, 0.4);
       }

.modal-btn-ok {
    background: linear-gradient(135deg, #007bff 0%, #0056b3 100%);
    color: white;
    box-shadow: 0 3px 8px rgba(0, 123, 255, 0.3);
}

       .modal-btn-ok:hover {
           background: linear-gradient(135deg, #0056b3 0%, #004085 100%);
           color: white;
           box-shadow: 0 4px 12px rgba(0, 123, 255, 0.4);
       }

/* Toolbar Items (Clear, Mobile, Tablet) */
.sidebar-top .item {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    padding: 0.5rem 1rem;
    border-radius: 6px;
    cursor: pointer;
    transition: all 0.3s ease;
    font-size: 0.875rem;
    font-weight: 500;
    border: 1px solid rgba(255, 255, 255, 0.2);
    backdrop-filter: blur(10px);
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    position: relative;
    overflow: hidden;
    box-shadow: 0 3px 8px rgba(102, 126, 234, 0.3);
}

.sidebar-top .item::before {
    content: '';
    position: absolute;
    top: 0;
    left: -100%;
    width: 100%;
    height: 100%;
    background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
    transition: left 0.5s;
}

.sidebar-top .item:hover::before {
    left: 100%;
}

       .sidebar-top .item:hover {
           background: linear-gradient(135deg, #5a67d8 0%, #6b46c1 100%);
           box-shadow: 0 6px 16px rgba(102, 126, 234, 0.4);
       }

.sidebar-top .item:active {
    transform: translateY(0);
    box-shadow: 0 2px 6px rgba(102, 126, 234, 0.3);
}

.sidebar-top .item i {
    font-size: 1rem;
}

/* Clear Button Special Styling - Same as Exit Button */
.template-clear {
    background: linear-gradient(135deg, #dc3545 0%, #fd7e14 100%) !important;
    box-shadow: 0 3px 8px rgba(220, 53, 69, 0.3) !important;
    color: white !important;
}

.template-clear:hover {
    background: linear-gradient(135deg, #c82333 0%, #e55a00 100%) !important;
    box-shadow: 0 6px 16px rgba(220, 53, 69, 0.4) !important;
    color: white !important;
}

.template-clear::after {
    content: '🗑️';
    margin-left: 0.5rem;
    font-size: 0.8rem;
}

/* Mobile Preview Button - No emoji */
.template-preview-mobile::after {
    content: '';
}

/* Tablet Preview Button - No emoji */
.template-preview-tablet::after {
    content: '';
}

       /* Button Loading States */
       .btn-loading {
           position: relative;
           color: white !important;
           pointer-events: none;
       }

.btn-loading::after {
    content: '';
    position: absolute;
    top: 50%;
    left: 50%;
    width: 16px;
    height: 16px;
    margin: -8px 0 0 -8px;
    border: 2px solid transparent;
    border-top: 2px solid currentColor;
    border-radius: 50%;
    animation: spin 1s linear infinite;
}

@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

/* Button Click Animation */
.btn-clicked {
    animation: btnClick 0.2s ease-out;
}

@keyframes btnClick {
    0% { transform: scale(1); }
    50% { transform: scale(0.95); }
    100% { transform: scale(1); }
}

/* Responsive Design */
@media (max-width: 768px) {
    .btn-main {
        padding: 0.6rem 1.2rem;
        font-size: 0.85rem;
    }
    
    .modal-btn-cancel,
    .modal-btn-ok {
        padding: 0.4rem 1rem;
        font-size: 0.8rem;
        min-width: 70px;
    }
    
    .sidebar-top .item {
        padding: 0.4rem 0.8rem;
        font-size: 0.8rem;
    }
}

       /* Professional Hover Effects - will-change removed to prevent movement */

       /* Prevent movement on hover for main elements */
       .container-fluid,
       .main-container,
       .sidebar-main,
       .sidebar-second,
       .holder-container,
       .editor-container,
       .nav,
       .nav-item,
       .subnav,
       .subnav-item {
           transform: none !important;
           transition: none !important;
       }

       .container-fluid:hover,
       .main-container:hover,
       .sidebar-main:hover,
       .sidebar-second:hover,
       .holder-container:hover,
       .editor-container:hover,
       .nav:hover,
       .nav-item:hover,
       .subnav:hover,
       .subnav-item:hover {
           transform: none !important;
       }
</style>

<div id="email-builder">
  <!-- Main Sidebar -->
  <div class="sidebar-main">
    <ul class="nav" data-type="nav">
      <li class="nav-item active" data-nav="has-child" style="width:100%">
        <span class="item"><i class="icon icon-sliders"></i> {{ __('app.builder_modules') }}</span>
        <ul class="subnav" data-type="subnav">
            <li class="subnav-item" data-target="modules">{{ __('app.builder_components') }}</li>
            <li class="subnav-item" data-target="styles">{{ __('app.builder_sytles') }}</li>
        </ul>
      </li>
      <li class="nav-item" data-nav="has-child">
        <span class="item"><i class="icon icon-download"></i> {{ __('app.builder_export') }}</span>
        <ul class="subnav" data-type="subnav">
            <li class="subnav-item" data-action="export-zip">{{ __('app.builder_zip') }}</li>
            <li class="subnav-item" data-action="export-html">{{ __('app.builder_html') }}</li>
        </ul>
      </li>
    </ul>
    <div class="sidebar-footer">
      <a class="btn btn-main btn-save" href="#">{{ __('app.save') }}</a>
      <a class="btn btn-main btn-cancel" href="#">{{ __('app.exit') }}</a>
    </div>
  </div>
  <!-- Main Container -->
  <div class="main-container">
    <!-- Second Sidebar -->
    <div class="sidebar-second" data-type="sidebar-second">
      <!-- Modules -->
      <div class="sidebar-inner" data-sidebar="modules">
        <div class="inner-content" data-type="modules-container"></div>
      </div>
      <!-- Styles -->
      <div class="sidebar-inner" data-sidebar="styles">
        <div class="inner-header"></div>
        <div class="inner-content">
            <div data-type="module-options"></div><!-- module-options -->
        </div>
      </div>
    </div>
    <!-- Holder Container -->
    <div class="holder-container">
        <div class="form-group col-md-12">
          <input type="text" class="form-control" id="template-name" name="name" value="{{ \App\Http\Helper\Helper::decodeString($name) ?? '' }}" placeholder="{{ __('app.name') }}">
          <input type="hidden" id='action' name="action" value="{{$action}}">
          <input type="hidden" id='id' name="id" value="{{$id}}">
        </div>
      <!-- Editor Container -->
      <div class="editor-container">
        <!-- Editor Area -->
        <div class="editor" id='editor' data-type="editor" style="overflow-y: auto; height: 85%;">
          {!! !empty($html) ? $html : '' !!}
        </div> <!-- /.editor -->
      </div>
      <div class="sidebar-top">
        <span class="item template-preview-mobile"><i class="icon-mobile"></i></span>
        <span class="item template-preview-tablet"><i class="icon-tablet"></i></span>
        <span class="item template-clear item-last"><i class="icon-close"></i> {{ __('app.clear') }}</span>
      </div>
    </div>
  </div>
  <form id="export-form" action="{{ url('/') }}/components/rz_builder/server/_export.php" method="POST">
    <input type="hidden" name="type" value="html"/>
    <input class="templateHTML" type="hidden" name="templateHTML" />
  </form> <!-- / Template Export Form  -->
</div>

<div id="linkeditor" class="modal-container">
  <div class="input-group">
    <input class="input-control" type="text" data-link="text" value="" placeholder="Text">
    <input class="input-control" type="text" data-link="url" value="" placeholder="https://example.com">
  </div>
  <div class="modal-controls">
    <button class="modal-btn-cancel">{{ __('app.cancel') }}</button>
    <button class="modal-btn-ok">{{ __('app.ok') }}</button>
  </div>
</div>

<div id="imageeditor" class="modal-container">
  <div class="modal-container-inner">
    <div class="input-group">
      <input class="input-control" type="text" data-image="url" value="" placeholder="URL">
      <input class="input-control" type="text" data-image="alt" value="" placeholder="Alt">
      <input class="input-control input-control-small" type="text" data-image="width" value="" placeholder="Width">px X
      <input class="input-control input-control-small" type="text" data-image="height" value="" placeholder="Height">px
    </div>
    <div>
      <div class="slim" id="modal-image-uploader">
        <input type="file" >
        <img src="" alt="" data-image="src">
      </div>
    </div>
  </div>
  <div class="modal-controls">
    <button class="modal-btn-cancel">{{ __('app.cancel') }}</button>
    <button class="modal-btn-ok">{{ __('app.ok') }}</button>
  </div>
</div>

<div id="bgeditor" class="modal-container">
  <div class="slim" id="modal-bg-uploader">
    <input type="file" >
    <img src="" alt="" data-image="src">
  </div>
  <div class="modal-controls">
    <button class="modal-btn-cancel">{{ __('app.cancel') }}</button>
    <button class="modal-btn-ok">{{ __('app.ok') }}</button>
  </div>
</div>
<span id="builder-msg-name-required" data-value="{{__('app.builder_msg_name_required')}}"></span>
<span id="msg-saved" data-value="{{__('app.msg_saved')}}"></span>
<span id="builder-mgs-cancel" data-value="{{__('app.builder_mgs_cancel')}}"></span>

<script src="{{asset('assets/js/jquery.min.js')}}"></script>
<script src="{{asset('assets/js/sweetalert.min.js')}}"></script>
<script src="{{asset('assets/js/toastr.min.js')}}"></script>

<script src="{{asset('components/rz_builder/dist/js/editor.js')}}"></script>
<script src="{{asset('components/rz_builder/dist/js/custom.js')}}"></script>
<script src="{{asset('assets/js/rz_builder.js')}}"></script>

<script type="text/javascript">
var url = window.location.protocol+'//'+window.location.hostname;
var config = {
  host : url+"/components/rz_builder",
  uploads : url+"/images/users/{{Auth::user()->id}}/gallery",
}

// Professional Button Enhancement JavaScript
$(document).ready(function() {
    'use strict';
    
    // Initialize builder
    try {
        var emailBuilder = new $.EmailBuilder({theme: 'default'});
        emailBuilder.init();
    } catch (error) {
        console.error('Builder initialization error:', error);
    }
    
    // Setup AJAX
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });
    
    // Professional button click animations
    $('.btn-main, .modal-btn-cancel, .modal-btn-ok, .sidebar-top .item').on('click', function() {
        $(this).addClass('btn-clicked');
        setTimeout(() => {
            $(this).removeClass('btn-clicked');
        }, 200);
    });
    
    // Save button functionality
    $('.btn-save').on('click', function(e) {
        e.preventDefault();
        const $btn = $(this);
        
        // Add loading state with white text
        $btn.addClass('btn-loading');
        $btn.attr('data-original-text', $btn.text());
        $btn.text('{{ __("app.saving") }}...');
        $btn.css('color', 'white !important');
        
        // Simulate save process
        setTimeout(function() {
            $btn.removeClass('btn-loading');
            $btn.text($btn.attr('data-original-text'));
            $btn.css('color', '');
            
        }, 2000);
    });
    
    // Cancel/Exit button functionality
    $('.btn-cancel').on('click', function(e) {
        e.preventDefault();
        const $btn = $(this);
        
        // Show SweetAlert confirmation
        if (typeof Swal !== 'undefined') {
            Swal.fire({
                title: '{{ __("app.confirm_exit") }}',
                text: '{{ __("app.are_you_sure_exit") }}',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#dc3545',
                cancelButtonColor: '#6c757d',
                confirmButtonText: '{{ __("app.yes_exit") }}',
                cancelButtonText: '{{ __("app.cancel") }}',
                reverseButtons: true
            }).then((result) => {
                if (result.isConfirmed) {
                    // Add loading state
                    $btn.addClass('btn-loading');
                    $btn.attr('data-original-text', $btn.text());
                    $btn.text('{{ __("app.exiting") }}...');
                    
                    // Redirect parent window to templates (since this is in an iframe)
                    if (window.parent && window.parent !== window) {
                        window.parent.location.href = '{{ url("/templates") }}';
                    } else {
                        window.location.href = '{{ url("/templates") }}';
                    }
                }
            });
        } else {
            // Fallback to SweetAlert v1
            swal({
                title: '{{ __("app.confirm_exit") }}',
                text: '{{ __("app.are_you_sure_exit") }}',
                type: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#dc3545',
                cancelButtonColor: '#6c757d',
                confirmButtonText: '{{ __("app.yes_exit") }}',
                cancelButtonText: '{{ __("app.cancel") }}',
                reverseButtons: true
            }, function(result) {
                if (result) {
                    // Add loading state
                    $btn.addClass('btn-loading');
                    $btn.attr('data-original-text', $btn.text());
                    $btn.text('{{ __("app.exiting") }}...');
                    
                    // Redirect parent window to templates (since this is in an iframe)
                    if (window.parent && window.parent !== window) {
                        window.parent.location.href = '{{ url("/templates") }}';
                    } else {
                        window.location.href = '{{ url("/templates") }}';
                    }
                }
            });
        }
    });
    
    // Clear button functionality
    $('.template-clear').on('click', function(e) {
        e.preventDefault();
        const $btn = $(this);
        
        // Show SweetAlert confirmation
        if (typeof Swal !== 'undefined') {
            Swal.fire({
                title: '{{ __("app.confirm_clear") }}',
                text: '{{ __("app.are_you_sure_clear") }}',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#dc3545',
                cancelButtonColor: '#6c757d',
                confirmButtonText: '{{ __("app.yes_clear") }}',
                cancelButtonText: '{{ __("app.cancel") }}',
                reverseButtons: true
            }).then((result) => {
                if (result.isConfirmed) {
                    // Add loading state
                    $btn.addClass('btn-loading');
                    $btn.attr('data-original-text', $btn.text());
                    $btn.text('{{ __("app.clearing") }}...');
                    
                    // Actually clear the canvas
                    try {
                        // Clear the editor content
                        if (typeof emailBuilder !== 'undefined' && emailBuilder.editor) {
                            emailBuilder.editor.clear();
                        } else if (typeof window.emailBuilder !== 'undefined' && window.emailBuilder.editor) {
                            window.emailBuilder.editor.clear();
                        } else {
                            // Fallback: clear the editor div directly
                            $('#editor').empty();
                        }
                    } catch (error) {
                        console.error('Error clearing canvas:', error);
                        // Fallback: clear the editor div directly
                        $('#editor').empty();
                    }
                    
                    // Remove loading state and show success
                    setTimeout(function() {
                        $btn.removeClass('btn-loading');
                        $btn.text($btn.attr('data-original-text'));
                        
                        // Show success feedback
                        showButtonFeedback($btn, '{{ __("app.cleared") }}', 'success');
                    }, 500);
                }
                // If cancelled, do nothing (no message shown)
            });
        } else {
            // Fallback to SweetAlert v1
            swal({
                title: '{{ __("app.confirm_clear") }}',
                text: '{{ __("app.are_you_sure_clear") }}',
                type: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#dc3545',
                cancelButtonColor: '#6c757d',
                confirmButtonText: '{{ __("app.yes_clear") }}',
                cancelButtonText: '{{ __("app.cancel") }}',
                reverseButtons: true
            }, function(result) {
                if (result) {
                    // Add loading state
                    $btn.addClass('btn-loading');
                    $btn.attr('data-original-text', $btn.text());
                    $btn.text('{{ __("app.clearing") }}...');
                    
                    // Actually clear the canvas
                    try {
                        // Clear the editor content
                        if (typeof emailBuilder !== 'undefined' && emailBuilder.editor) {
                            emailBuilder.editor.clear();
                        } else if (typeof window.emailBuilder !== 'undefined' && window.emailBuilder.editor) {
                            window.emailBuilder.editor.clear();
                        } else {
                            // Fallback: clear the editor div directly
                            $('#editor').empty();
                        }
                    } catch (error) {
                        console.error('Error clearing canvas:', error);
                        // Fallback: clear the editor div directly
                        $('#editor').empty();
                    }
                    
                    // Remove loading state and show success
                    setTimeout(function() {
                        $btn.removeClass('btn-loading');
                        $btn.text($btn.attr('data-original-text'));
                        
                        // Show success feedback
                        showButtonFeedback($btn, '{{ __("app.cleared") }}', 'success');
                    }, 500);
                }
                // If cancelled, do nothing (no message shown)
            });
        }
    });
    
    // Modal button functionality
    $('.modal-btn-ok').on('click', function() {
        const $btn = $(this);
        $btn.addClass('btn-loading');
        $btn.text('{{ __("app.processing") }}...');
        
        setTimeout(function() {
            $btn.removeClass('btn-loading');
            $btn.text('{{ __("app.ok") }}');
        }, 1000);
    });
    
    $('.modal-btn-cancel').on('click', function() {
        const $btn = $(this);
        $btn.addClass('btn-clicked');
        setTimeout(() => {
            $btn.removeClass('btn-clicked');
        }, 200);
    });
    
    // Preview buttons functionality
    $('.template-preview-mobile, .template-preview-tablet').on('click', function() {
        const $btn = $(this);
        $btn.addClass('btn-clicked');
        
        // Add active state
        $('.template-preview-mobile, .template-preview-tablet').removeClass('active');
        $btn.addClass('active');
        
        setTimeout(() => {
            $btn.removeClass('btn-clicked');
        }, 200);
    });
    
           // Button hover effects removed to prevent movement
});

// Show button feedback
function showButtonFeedback($btn, message, type = 'success') {
    const originalText = $btn.text();
    const originalClass = $btn.attr('class');
    
    $btn.text(message);
    $btn.removeClass().addClass(originalClass);
    
    if (type === 'success') {
        $btn.css('background', 'linear-gradient(135deg, #28a745 0%, #20c997 100%)');
    } else if (type === 'error') {
        $btn.css('background', 'linear-gradient(135deg, #dc3545 0%, #c82333 100%)');
    }
    
    setTimeout(function() {
        $btn.text(originalText);
        $btn.attr('class', originalClass);
    }, 2000);
}

// Professional CSS for additional button states
$('<style>')
    .prop('type', 'text/css')
    .html(`
        .sidebar-top .item.active {
            background: linear-gradient(135deg, #4c51bf 0%, #553c9a 100%) !important;
            box-shadow: 0 6px 16px rgba(76, 81, 191, 0.4) !important;
        }
        
        .btn-main:disabled,
        .modal-btn-cancel:disabled,
        .modal-btn-ok:disabled {
            opacity: 0.6;
            cursor: not-allowed;
            transform: none !important;
        }
        
        .btn-main:disabled:hover,
        .modal-btn-cancel:disabled:hover,
        .modal-btn-ok:disabled:hover {
            transform: none !important;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15) !important;
        }
        
        .btn-feedback {
            animation: btnFeedback 0.3s ease-out;
        }
        
        @keyframes btnFeedback {
            0% { transform: scale(1); }
            50% { transform: scale(1.05); }
            100% { transform: scale(1); }
        }
    `)
    .appendTo('head');
</script>
